/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;

@SWFVersion(from=3)
public class FrameLabelTag
extends Tag {
    public static final int ID = 43;
    public static final String NAME = "FrameLabel";
    public String name;
    @Conditional(minSwfVersion=6)
    public boolean namedAnchor = false;

    public FrameLabelTag(SWF swf) {
        super(swf, 43, NAME, null);
        this.name = "New frame label";
    }

    public FrameLabelTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 43, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.name = sis.readString("name");
        if (sis.available() > 0 && sis.readUI8("namedAnchor") == 1) {
            this.namedAnchor = true;
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeString(this.name);
        if (this.namedAnchor) {
            sos.writeUI8(1);
        }
    }

    public String getLabelName() {
        return this.name;
    }

    public boolean isNamedAnchor() {
        return this.namedAnchor;
    }

    @Override
    public String toString() {
        return this.getName() + (this.name.isEmpty() ? "" : " (" + this.name + ")");
    }
}

