/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

@SWFVersion(from=9)
public class DefineBinaryDataTag
extends CharacterTag {
    public static final int ID = 87;
    public static final String NAME = "DefineBinaryData";
    @SWFType(value=BasicType.UI16)
    public int tag;
    public ByteArrayRange binaryData;
    @Reserved
    @SWFType(value=BasicType.UI32)
    public long reserved;
    @Internal
    public SWF innerSwf;

    public DefineBinaryDataTag(SWF swf) {
        super(swf, 87, NAME, null);
        this.tag = swf.getNextCharacterId();
        this.binaryData = ByteArrayRange.EMPTY;
    }

    public DefineBinaryDataTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 87, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.tag = sis.readUI16("tag");
        this.reserved = sis.readUI32("reserved");
        this.binaryData = sis.readByteRangeEx(sis.available(), "binaryData");
        if (Configuration.autoLoadEmbeddedSwfs.get().booleanValue()) {
            String path = this.getSwf().getShortPathTitle() + "/DefineBinaryData (" + this.getCharacterId() + ")";
            SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration(path);
            String charset = conf == null ? Charset.defaultCharset().name() : conf.getCustomData("charset", Charset.defaultCharset().name());
            try {
                SWF bswf;
                ByteArrayInputStream is = new ByteArrayInputStream(this.binaryData.getArray(), this.binaryData.getPos(), this.binaryData.getLength());
                this.innerSwf = bswf = new SWF((InputStream)is, null, "(SWF Data)", Configuration.parallelSpeedUp.get(), charset);
                bswf.binaryData = this;
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.tag);
        sos.writeUI32(this.reserved);
        sos.write(this.binaryData);
    }

    @Override
    public int getCharacterId() {
        return this.tag;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.tag = characterId;
    }

    public boolean isSwfData() {
        try {
            String signature;
            if (this.binaryData.getLength() > 8 && SWF.swfSignatures.contains(signature = new String(this.binaryData.getRangeData(0, 3), Utf8Helper.charset))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this.innerSwf != null) {
            return this.innerSwf.isModified();
        }
        return false;
    }
}

