/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.math;

import com.jpexs.decompiler.flash.math.BezierUtils;
import com.jpexs.helpers.Reference;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class BezierEdge {
    public List<Point2D> points = new ArrayList<Point2D>();
    private final double MIN_SIZE = 1.0;

    public BezierEdge(List<Point2D> points) {
        this.points = points;
    }

    public BezierEdge(double x0, double y0, double x1, double y1) {
        this.points.add(new Point2D.Double(x0, y0));
        this.points.add(new Point2D.Double(x1, y1));
    }

    public BezierEdge(double x0, double y0, double cx, double cy, double x1, double y1) {
        this.points.add(new Point2D.Double(x0, y0));
        this.points.add(new Point2D.Double(cx, cy));
        this.points.add(new Point2D.Double(x1, y1));
    }

    public Point2D pointAt(double t) {
        if (this.points.size() == 2) {
            double x = (1.0 - t) * this.points.get(0).getX() + t * this.points.get(1).getX();
            double y = (1.0 - t) * this.points.get(0).getY() + t * this.points.get(1).getY();
            return new Point2D.Double(x, y);
        }
        double x = (1.0 - t) * (1.0 - t) * this.points.get(0).getX() + 2.0 * t * (1.0 - t) * this.points.get(1).getX() + t * t * this.points.get(2).getX();
        double y = (1.0 - t) * (1.0 - t) * this.points.get(0).getY() + 2.0 * t * (1.0 - t) * this.points.get(1).getY() + t * t * this.points.get(2).getY();
        return new Point2D.Double(x, y);
    }

    public Rectangle2D bbox() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point2D p : this.points) {
            if (p.getX() < minX) {
                minX = p.getX();
            }
            if (p.getX() > maxX) {
                maxX = p.getX();
            }
            if (p.getY() < minY) {
                minY = p.getY();
            }
            if (!(p.getY() > maxY)) continue;
            maxY = p.getY();
        }
        Rectangle2D.Double b = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        return b;
    }

    public double area() {
        Rectangle2D rect = this.bbox();
        double w = rect.getWidth();
        double h = rect.getHeight();
        if (w < 1.0) {
            w = 1.0;
        }
        if (h < 1.0) {
            h = 1.0;
        }
        return w * h;
    }

    private static boolean rectIntersection(Rectangle2D r1, Rectangle2D r2) {
        double xmax2;
        double xmin = Math.max(r1.getX(), r2.getX());
        double xmax1 = r1.getX() + r1.getWidth();
        double xmax = Math.min(xmax1, xmax2 = r2.getX() + r2.getWidth());
        if (Double.compare(xmax, xmin) >= 0) {
            double ymax2;
            double ymin = Math.max(r1.getY(), r2.getY());
            double ymax1 = r1.getY() + r1.getHeight();
            double ymax = Math.min(ymax1, ymax2 = r2.getY() + r2.getHeight());
            if (Double.compare(ymax, ymin) >= 0) {
                return true;
            }
        }
        return false;
    }

    public boolean intersects(BezierEdge b2, List<Double> t1Ref, List<Double> t2Ref) {
        return this.intersects(b2, 0.0, 1.0, 0.0, 1.0, t1Ref, t2Ref);
    }

    private boolean intersects(BezierEdge b2, double start1, double end1, double start2, double end2, List<Double> t1Ref, List<Double> t2Ref) {
        Rectangle2D bb2;
        double threshold = 2.0;
        Rectangle2D bb1 = this.bbox();
        if (!BezierEdge.rectIntersection(bb1, bb2 = b2.bbox())) {
            return false;
        }
        double sumAreas = this.area() + b2.area();
        if (Double.compare(sumAreas, 2.0) <= 0) {
            double t1 = (start1 + end1) / 2.0;
            double t2 = (start2 + end2) / 2.0;
            t1Ref.add(t1);
            t2Ref.add(t2);
            return true;
        }
        BezierUtils bu = new BezierUtils();
        ArrayList<Point2D> b1aPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> b1bPoints = new ArrayList<Point2D>();
        bu.subdivide(this.points, 0.5, b1aPoints, b1bPoints);
        ArrayList<Point2D> b2aPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> b2bPoints = new ArrayList<Point2D>();
        bu.subdivide(b2.points, 0.5, b2aPoints, b2bPoints);
        BezierEdge b1a = new BezierEdge(b1aPoints);
        BezierEdge b1b = new BezierEdge(b1bPoints);
        BezierEdge b2a = new BezierEdge(b2aPoints);
        BezierEdge b2b = new BezierEdge(b2bPoints);
        double half1 = start1 + (end1 - start1) / 2.0;
        double half2 = start2 + (end2 - start2) / 2.0;
        boolean ok = false;
        if (b1a.intersects(b2a, start1, half1, start2, half2, t1Ref, t2Ref)) {
            ok = true;
        }
        if (b1a.intersects(b2b, start1, half1, half2, end2, t1Ref, t2Ref)) {
            ok = true;
        }
        if (b1b.intersects(b2a, half1, end1, start2, half2, t1Ref, t2Ref)) {
            ok = true;
        }
        if (b1b.intersects(b2b, half1, end1, half2, end2, t1Ref, t2Ref)) {
            ok = true;
        }
        return ok;
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (Point2D p : this.points) {
            list.add("[" + p.getX() + "," + p.getY() + "]");
        }
        return "{" + String.join((CharSequence)"-", list) + "}";
    }

    public void split(double t, Reference<BezierEdge> left, Reference<BezierEdge> right) {
        ArrayList<Point2D> leftPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> rightPoints = new ArrayList<Point2D>();
        BezierUtils bu = new BezierUtils();
        bu.subdivide(this.points, t, leftPoints, rightPoints);
        left.setVal(new BezierEdge(leftPoints));
        right.setVal(new BezierEdge(rightPoints));
    }

    public static void main(String[] args) {
        ArrayList<Double> t1 = new ArrayList<Double>();
        ArrayList<Double> t2 = new ArrayList<Double>();
        BezierEdge be5 = new BezierEdge(25.0, 0.0, 25.0, 100.0);
        BezierEdge be6 = new BezierEdge(0.0, 50.0, 100.0, 50.0);
        System.out.println("lines " + be5 + " and " + be6);
        System.out.println("hasIntersection = " + be5.intersects(be6, t1, t2));
        System.out.println("intersection ts: " + t1 + ", " + t2);
        Point2D.Double c = new Point2D.Double((1.0 - (Double)t1.get(0)) * be5.points.get(0).getX() + (Double)t1.get(0) * be5.points.get(1).getX(), (1.0 - (Double)t1.get(0)) * be5.points.get(0).getY() + (Double)t1.get(0) * be5.points.get(1).getY());
        System.out.println("Intersection point: " + c);
    }
}

