/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg;

import com.jpexs.decompiler.flash.importers.svg.SvgColor;
import com.jpexs.decompiler.flash.importers.svg.SvgLineCap;
import com.jpexs.decompiler.flash.importers.svg.SvgLineJoin;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SvgStyleProperty {
    private final String name;
    private final boolean inherited;
    private final Object initial;
    private static final Map<String, SvgStyleProperty> properties;

    public SvgStyleProperty(String name, boolean inherited, Object initial) {
        this.name = name;
        this.inherited = inherited;
        this.initial = initial;
    }

    public String name() {
        return this.name;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public Object getInitialValue() {
        return this.initial;
    }

    public static Collection<SvgStyleProperty> getProperties() {
        return properties.values();
    }

    public static SvgStyleProperty getByName(String name) {
        return properties.get(name);
    }

    static {
        HashMap<String, SvgStyleProperty> p = new HashMap<String, SvgStyleProperty>();
        p.put("color", new SvgStyleProperty("color", true, Color.BLACK));
        p.put("fill", new SvgStyleProperty("fill", true, new SvgColor(Color.BLACK)));
        p.put("fill-opacity", new SvgStyleProperty("fill-opacity", true, 1.0));
        p.put("stroke", new SvgStyleProperty("stroke", true, null));
        p.put("stroke-width", new SvgStyleProperty("stroke-width", true, 1.0));
        p.put("stroke-opacity", new SvgStyleProperty("stroke-opacity", true, 1.0));
        p.put("stroke-linecap", new SvgStyleProperty("stroke-linecap", true, (Object)SvgLineCap.BUTT));
        p.put("stroke-linejoin", new SvgStyleProperty("stroke-linejoin", true, (Object)SvgLineJoin.MITER));
        p.put("stroke-miterlimit", new SvgStyleProperty("stroke-miterlimit", true, 4.0));
        p.put("opacity", new SvgStyleProperty("opacity", false, 1.0));
        p.put("stop-color", new SvgStyleProperty("stop-color", false, Color.BLACK));
        p.put("stop-opacity", new SvgStyleProperty("stop-opacity", false, 1.0));
        properties = p;
    }
}

