/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg;

import com.jpexs.decompiler.flash.importers.ShapeImporter;
import com.jpexs.decompiler.flash.importers.svg.SvgBitmapFill;
import com.jpexs.decompiler.flash.importers.svg.SvgColor;
import com.jpexs.decompiler.flash.importers.svg.SvgFill;
import com.jpexs.decompiler.flash.importers.svg.SvgGradient;
import com.jpexs.decompiler.flash.importers.svg.SvgGradientUnits;
import com.jpexs.decompiler.flash.importers.svg.SvgImporter;
import com.jpexs.decompiler.flash.importers.svg.SvgInterpolation;
import com.jpexs.decompiler.flash.importers.svg.SvgLineCap;
import com.jpexs.decompiler.flash.importers.svg.SvgLineJoin;
import com.jpexs.decompiler.flash.importers.svg.SvgLinearGradient;
import com.jpexs.decompiler.flash.importers.svg.SvgRadialGradient;
import com.jpexs.decompiler.flash.importers.svg.SvgSpreadMethod;
import com.jpexs.decompiler.flash.importers.svg.SvgStop;
import com.jpexs.decompiler.flash.importers.svg.SvgStyleProperty;
import com.jpexs.decompiler.flash.importers.svg.SvgTransparentFill;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.helpers.Helper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SvgStyle {
    private final Element element;
    private final SvgImporter importer;
    private final Map<String, Element> idMap;
    private final double epsilon = 0.001;
    private final Random random = new Random();

    public SvgStyle(SvgImporter importer, Map<String, Element> idMap, Element element) {
        this.importer = importer;
        this.idMap = idMap;
        this.element = element;
    }

    private Map<String, String> getStyleAttributeValues(Element element) {
        HashMap<String, String> styleValues = new HashMap<String, String>();
        String styleStr = "";
        if (element.hasAttribute("ffdec-style")) {
            styleStr = styleStr + element.getAttribute("ffdec-style");
        }
        if (element.hasAttribute("style")) {
            styleStr = styleStr + "{1000}" + element.getAttribute("style");
        }
        if (!styleStr.isEmpty()) {
            String[] styleDefs;
            String[] rulesBySpec = styleStr.split("\\{");
            List<String> rulesBySpecList = Arrays.asList(rulesBySpec);
            final ArrayList<String> rulesBySpecListUnordered = new ArrayList<String>(rulesBySpecList);
            rulesBySpecList.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int r2;
                    if (o1.isEmpty()) {
                        return -1;
                    }
                    if (o2.isEmpty()) {
                        return 1;
                    }
                    int r1 = Integer.parseInt(o1.substring(0, o1.indexOf("}")));
                    if (r1 == (r2 = Integer.parseInt(o2.substring(0, o2.indexOf("}"))))) {
                        return rulesBySpecListUnordered.indexOf(r1) - rulesBySpecListUnordered.indexOf(r2);
                    }
                    return r1 - r2;
                }
            });
            for (int i = 0; i < rulesBySpecList.size(); ++i) {
                rulesBySpecList.set(i, rulesBySpecList.get(i).substring(rulesBySpecList.get(i).indexOf("}") + 1));
            }
            styleStr = String.join((CharSequence)";", rulesBySpecList) + ";";
            for (String styleDef : styleDefs = styleStr.split(";")) {
                if (!styleDef.contains(":")) continue;
                String[] parts = styleDef.split(":", 2);
                String name = parts[0].trim();
                String value = parts[1].trim();
                SvgStyleProperty styleProperty = SvgStyleProperty.getByName(name);
                if (styleProperty == null) {
                    this.importer.showWarning(name + "StyleNotSupported", "The style '" + name + "' is not supported.");
                    continue;
                }
                styleValues.put(name, value);
            }
        }
        return styleValues;
    }

    private <E> E getValue(Element element, String name) {
        return this.getValue(element, name, false);
    }

    private <E> E getValue(Element element, String name, boolean inherit) {
        Object result;
        String value;
        Map<String, String> styleValues = this.getStyleAttributeValues(element);
        if (styleValues.containsKey(name)) {
            value = styleValues.get(name);
            if ("inherit".equals(value)) {
                if (element.getParentNode() instanceof Element) {
                    return this.getValue((Element)element.getParentNode(), name, true);
                }
            } else {
                result = this.getStyleValue(this, name, value);
                if (result != null) {
                    return (E)result;
                }
            }
        }
        if (element.hasAttribute(name)) {
            value = element.getAttribute(name).trim();
            if ("inherit".equals(value)) {
                if (element.getParentNode() instanceof Element) {
                    return this.getValue((Element)element.getParentNode(), name, true);
                }
            } else {
                result = this.getStyleValue(this, name, value);
                if (result != null) {
                    return (E)result;
                }
            }
        }
        SvgStyleProperty p = SvgStyleProperty.getByName(name);
        if (inherit || p.isInherited() && element.getParentNode() instanceof Element) {
            return this.getValue((Element)element.getParentNode(), name);
        }
        return (E)p.getInitialValue();
    }

    public Color getColor() {
        return (Color)this.getValue(this.element, "color");
    }

    public SvgFill getFill() {
        return (SvgFill)this.getValue(this.element, "fill");
    }

    public double getFillOpacity() {
        return (Double)this.getValue(this.element, "fill-opacity");
    }

    public SvgFill getStroke() {
        return (SvgFill)this.getValue(this.element, "stroke");
    }

    public double getStrokeWidth() {
        return (Double)this.getValue(this.element, "stroke-width");
    }

    public double getStrokeOpacity() {
        return (Double)this.getValue(this.element, "stroke-opacity");
    }

    public SvgLineCap getStrokeLineCap() {
        return (SvgLineCap)((Object)this.getValue(this.element, "stroke-linecap"));
    }

    public SvgLineJoin getStrokeLineJoin() {
        return (SvgLineJoin)((Object)this.getValue(this.element, "stroke-linejoin"));
    }

    public double getStrokeMiterLimit() {
        return (Double)this.getValue(this.element, "stroke-miterlimit");
    }

    public double getOpacity() {
        return (Double)this.getValue(this.element, "opacity");
    }

    public Color getStopColor() {
        return (Color)this.getValue(this.element, "stop-color");
    }

    public double getStopOpacity() {
        return (Double)this.getValue(this.element, "stop-opacity");
    }

    public SvgFill getFillWithOpacity() {
        SvgFill fill = this.getFill();
        if (fill == null) {
            return null;
        }
        if (!(fill instanceof SvgColor)) {
            return fill;
        }
        Color fillColor = ((SvgColor)fill).color;
        int opacity = (int)Math.round(this.getOpacity() * this.getFillOpacity() * 255.0);
        if (opacity > 255) {
            opacity = 255;
        }
        if (opacity < 0) {
            opacity = 0;
        }
        if (opacity == 255) {
            return fill;
        }
        return new SvgColor(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), opacity);
    }

    public SvgFill getStrokeFillWithOpacity() {
        SvgFill strokeFill = this.getStroke();
        if (strokeFill == null) {
            return null;
        }
        if (!(strokeFill instanceof SvgColor)) {
            return strokeFill;
        }
        Color strokeFillColor = ((SvgColor)strokeFill).color;
        int opacity = (int)Math.round(this.getOpacity() * this.getStopOpacity() * 255.0);
        if (opacity > 255) {
            opacity = 255;
        }
        if (opacity < 0) {
            opacity = 0;
        }
        if (opacity == 255) {
            return strokeFill;
        }
        return new SvgColor(strokeFillColor.getRed(), strokeFillColor.getGreen(), strokeFillColor.getBlue(), opacity);
    }

    public SvgFill getStrokeColorWithOpacity() {
        SvgFill strokeFill = this.getStroke();
        if (strokeFill == null) {
            return null;
        }
        if (!(strokeFill instanceof SvgColor)) {
            return strokeFill;
        }
        Color strokeColor = ((SvgColor)strokeFill).color;
        int opacity = (int)Math.round(this.getOpacity() * this.getStrokeOpacity() * 255.0);
        if (opacity == 255) {
            return strokeFill;
        }
        return new SvgColor(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue(), opacity);
    }

    private SvgFill parseGradient(Map<String, Element> idMap, Element el) {
        SvgGradientUnits gradientUnits = null;
        String gradientTransform = null;
        SvgSpreadMethod spreadMethod = null;
        SvgInterpolation interpolation = null;
        String x1 = null;
        String y1 = null;
        String x2 = null;
        String y2 = null;
        String cx = null;
        String cy = null;
        String fx = null;
        String fy = null;
        String r = null;
        List stops = new ArrayList();
        if (el.hasAttribute("xlink:href")) {
            String parent = el.getAttribute("xlink:href");
            if (parent.startsWith("#")) {
                SvgGradient parentFill;
                String parentId = parent.substring(1);
                Element parent_el = idMap.get(parentId);
                if (parent_el == null) {
                    this.importer.showWarning("fillNotSupported", "Parent gradient not found.");
                    return new SvgColor(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
                }
                if ("linearGradient".equals(el.getTagName()) && parent_el.getTagName().equals(el.getTagName())) {
                    parentFill = (SvgLinearGradient)this.parseGradient(idMap, parent_el);
                    gradientUnits = parentFill.gradientUnits;
                    gradientTransform = parentFill.gradientTransform;
                    spreadMethod = parentFill.spreadMethod;
                    x1 = parentFill.x1;
                    y1 = parentFill.y1;
                    x2 = parentFill.x2;
                    y2 = parentFill.y2;
                    interpolation = parentFill.interpolation;
                    stops = parentFill.stops;
                }
                if ("radialGradient".equals(el.getTagName()) && parent_el.getTagName().equals(el.getTagName())) {
                    parentFill = (SvgRadialGradient)this.parseGradient(idMap, parent_el);
                    gradientUnits = ((SvgRadialGradient)parentFill).gradientUnits;
                    gradientTransform = ((SvgRadialGradient)parentFill).gradientTransform;
                    spreadMethod = ((SvgRadialGradient)parentFill).spreadMethod;
                    cx = ((SvgRadialGradient)parentFill).cx;
                    cy = ((SvgRadialGradient)parentFill).cy;
                    fx = ((SvgRadialGradient)parentFill).fx;
                    fy = ((SvgRadialGradient)parentFill).fy;
                    r = ((SvgRadialGradient)parentFill).r;
                    interpolation = ((SvgRadialGradient)parentFill).interpolation;
                    stops = ((SvgRadialGradient)parentFill).stops;
                }
            } else {
                this.importer.showWarning("fillNotSupported", "Parent gradient invalid.");
                return new SvgColor(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
            }
        }
        if (el.hasAttribute("gradientUnits")) {
            switch (el.getAttribute("gradientUnits")) {
                case "userSpaceOnUse": {
                    gradientUnits = SvgGradientUnits.USER_SPACE_ON_USE;
                    break;
                }
                case "objectBoundingBox": {
                    gradientUnits = SvgGradientUnits.OBJECT_BOUNDING_BOX;
                    break;
                }
                default: {
                    this.importer.showWarning("fillNotSupported", "Unsupported  gradientUnits: " + el.getAttribute("gradientUnits"));
                    return new SvgColor(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
                }
            }
        }
        if (el.hasAttribute("gradientTransform")) {
            gradientTransform = el.getAttribute("gradientTransform");
        }
        if (el.hasAttribute("spreadMethod")) {
            switch (el.getAttribute("spreadMethod")) {
                case "pad": {
                    spreadMethod = SvgSpreadMethod.PAD;
                    break;
                }
                case "reflect": {
                    spreadMethod = SvgSpreadMethod.REFLECT;
                    break;
                }
                case "repeat": {
                    spreadMethod = SvgSpreadMethod.REPEAT;
                }
            }
        }
        if (el.hasAttribute("x1")) {
            x1 = el.getAttribute("x1").trim();
        }
        if (el.hasAttribute("y1")) {
            y1 = el.getAttribute("y1").trim();
        }
        if (el.hasAttribute("x2")) {
            x2 = el.getAttribute("x2").trim();
        }
        if (el.hasAttribute("y2")) {
            y2 = el.getAttribute("y2").trim();
        }
        if (el.hasAttribute("cx")) {
            cx = el.getAttribute("cx").trim();
        }
        if (el.hasAttribute("cy")) {
            cy = el.getAttribute("cy").trim();
        }
        if (el.hasAttribute("fx")) {
            fx = el.getAttribute("fx").trim();
        }
        if (el.hasAttribute("fy")) {
            fy = el.getAttribute("fy").trim();
        }
        if (el.hasAttribute("r")) {
            r = el.getAttribute("r").trim();
        }
        if (el.hasAttribute("color-interpolation") && interpolation == null) {
            switch (el.getAttribute("color-interpolation")) {
                case "sRGB": {
                    interpolation = SvgInterpolation.SRGB;
                    break;
                }
                case "linearRGB": {
                    interpolation = SvgInterpolation.LINEAR_RGB;
                    break;
                }
                case "auto": {
                    interpolation = SvgInterpolation.SRGB;
                }
            }
        }
        if (interpolation == null) {
            interpolation = SvgInterpolation.SRGB;
        }
        if (gradientUnits == null) {
            gradientUnits = SvgGradientUnits.OBJECT_BOUNDING_BOX;
        }
        if (spreadMethod == null) {
            spreadMethod = SvgSpreadMethod.PAD;
        }
        if (x1 == null) {
            x1 = "0%";
        }
        if (y1 == null) {
            y1 = "0%";
        }
        if (x2 == null) {
            x2 = "100%";
        }
        if (y2 == null) {
            y2 = "0%";
        }
        if (cx == null) {
            cx = "50%";
        }
        if (cy == null) {
            cy = "50%";
        }
        if (r == null) {
            r = "50%";
        }
        if (fx == null) {
            fx = cx;
        }
        if (fy == null) {
            fy = cy;
        }
        NodeList stopNodes = el.getElementsByTagName("stop");
        boolean stopsCleared = false;
        for (int i = 0; i < stopNodes.getLength(); ++i) {
            Node node = stopNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element stopEl = (Element)node;
            SvgStyle newStyle = new SvgStyle(this.importer, idMap, stopEl);
            String offsetStr = stopEl.getAttribute("offset");
            double offset = this.importer.parseNumberOrPercent(offsetStr);
            Color color = newStyle.getStopColor();
            if (color == null) {
                color = Color.BLACK;
            }
            int alpha = (int)Math.round(newStyle.getStopOpacity() * 255.0);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            if (!stopsCleared) {
                stopsCleared = true;
                stops = new ArrayList();
            }
            stops.add((SvgStop)new SvgStop(color, offset));
        }
        if ("linearGradient".equals(el.getTagName())) {
            SvgLinearGradient ret = new SvgLinearGradient();
            ret.x1 = x1;
            ret.y1 = y1;
            ret.x2 = x2;
            ret.y2 = y2;
            ret.spreadMethod = spreadMethod;
            ret.gradientTransform = gradientTransform;
            ret.gradientUnits = gradientUnits;
            ret.stops = this.fixStops(stops);
            ret.interpolation = interpolation;
            return ret;
        }
        if ("radialGradient".equals(el.getTagName())) {
            SvgRadialGradient ret = new SvgRadialGradient();
            ret.cx = cx;
            ret.cy = cy;
            ret.fx = fx;
            ret.fy = fy;
            ret.r = r;
            ret.spreadMethod = spreadMethod;
            ret.gradientTransform = gradientTransform;
            ret.gradientUnits = gradientUnits;
            ret.stops = this.fixStops(stops);
            ret.interpolation = interpolation;
            return ret;
        }
        return null;
    }

    private List<SvgStop> fixStops(List<SvgStop> stops) {
        if (stops.isEmpty()) {
            stops.add(new SvgStop(SvgTransparentFill.INSTANCE.toColor(), 0.0));
            stops.add(new SvgStop(SvgTransparentFill.INSTANCE.toColor(), 1.0));
        } else if (stops.size() == 1) {
            SvgStop stop0 = stops.get(0);
            stop0.offset = 0.0;
            stops.add(new SvgStop(stop0.color, 1.0));
        }
        double offset = 0.0;
        for (SvgStop stop : stops) {
            if (stop.offset < offset) {
                stop.offset = offset;
            }
            if (stop.offset > 1.0) {
                stop.offset = 1.0;
            }
            offset = stop.offset;
        }
        if (Math.abs(offset - 1.0) > 0.001) {
            stops.add(new SvgStop(stops.get((int)(stops.size() - 1)).color, 1.0));
        }
        return stops;
    }

    private SvgFill parseFill(Map<String, Element> idMap, String fillStr) {
        SvgColor result;
        if (fillStr == null) {
            return null;
        }
        if (fillStr.equals("none")) {
            return SvgTransparentFill.INSTANCE;
        }
        Pattern idPat = Pattern.compile("url\\(#([^)]+)\\).*");
        Matcher mPat = idPat.matcher(fillStr);
        if (mPat.matches()) {
            String elementId = mPat.group(1);
            Element e = idMap.get(elementId);
            if (e != null) {
                String tagName = e.getTagName();
                if ("linearGradient".equals(tagName)) {
                    return this.parseGradient(idMap, e);
                }
                if ("radialGradient".equals(tagName)) {
                    return this.parseGradient(idMap, e);
                }
                if ("pattern".equals(tagName)) {
                    String attr;
                    Element element = null;
                    NodeList childNodes = e.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        if (!(childNodes.item(i) instanceof Element)) continue;
                        if (element != null) {
                            element = null;
                            break;
                        }
                        element = (Element)childNodes.item(i);
                    }
                    if (element != null && "image".equals(element.getTagName()) && (attr = element.getAttribute("xlink:href").trim()).startsWith("data:image/") && attr.contains("base64,")) {
                        String base64 = attr.substring(attr.indexOf("base64,") + 7);
                        byte[] data = Helper.base64StringToByteArray(base64);
                        try {
                            ImageTag imageTag = new ShapeImporter().addImage(this.importer.shapeTag, data, 0);
                            SvgBitmapFill bitmapFill = new SvgBitmapFill();
                            bitmapFill.characterId = imageTag.characterID;
                            if (e.hasAttribute("patternTransform")) {
                                bitmapFill.patternTransform = e.getAttribute("patternTransform");
                            }
                            return bitmapFill;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(SvgStyle.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                this.importer.showWarning("fillNotSupported", "Unknown fill style. Random color assigned.");
                return new SvgColor(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
            }
            fillStr = fillStr.substring(elementId.length() + 6).trim();
        }
        if ((result = SvgColor.parse(fillStr)) == null) {
            this.importer.showWarning("fillNotSupported", "Unknown fill style. Random color assigned.");
            return new SvgColor(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
        }
        return result;
    }

    private Object getStyleValue(SvgStyle style, String name, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            switch (name) {
                case "color": {
                    Color color = SvgColor.parse(value).toColor();
                    if (color != null) {
                        return color;
                    }
                    break;
                }
                case "fill": {
                    if ("currentColor".equals(value)) {
                        return new SvgColor(style.getColor());
                    }
                    SvgFill fill = this.parseFill(this.idMap, value);
                    if (fill != null) {
                        return fill;
                    }
                    break;
                }
                case "fill-opacity": {
                    double opacity = Double.parseDouble(value);
                    return opacity;
                }
                case "stroke": {
                    if ("currentColor".equals(value)) {
                        return new SvgColor(style.getColor());
                    }
                    SvgFill stroke = this.parseFill(this.idMap, value);
                    if (stroke != null) {
                        return stroke;
                    }
                    break;
                }
                case "stroke-width": {
                    double strokeWidth = Double.parseDouble(value);
                    return strokeWidth;
                }
                case "stroke-opacity": {
                    double opacity = Double.parseDouble(value);
                    return opacity;
                }
                case "stroke-linecap": {
                    switch (value) {
                        case "butt": {
                            return SvgLineCap.BUTT;
                        }
                        case "round": {
                            return SvgLineCap.ROUND;
                        }
                        case "square": {
                            return SvgLineCap.SQUARE;
                        }
                    }
                    break;
                }
                case "stroke-linejoin": {
                    switch (value) {
                        case "miter": {
                            return SvgLineJoin.MITER;
                        }
                        case "round": {
                            return SvgLineJoin.ROUND;
                        }
                        case "bevel": {
                            return SvgLineJoin.BEVEL;
                        }
                    }
                    break;
                }
                case "stroke-miterlimit": {
                    double strokeMiterLimit = Double.parseDouble(value);
                    return strokeMiterLimit;
                }
                case "opacity": {
                    double opacity = Double.parseDouble(value);
                    return opacity;
                }
                case "stop-color": {
                    if ("currentColor".equals(value)) {
                        return style.getColor();
                    }
                    return SvgColor.parse(value).toColor();
                }
                case "stop-opacity": {
                    double stopOpacity = Double.parseDouble(value);
                    return stopOpacity;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }
}

