/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg;

public class SvgPathReader {
    private final String str;
    private int pos;

    public SvgPathReader(String str) {
        this.str = str;
    }

    public boolean hasNext() {
        return this.pos < this.str.length();
    }

    public char peek() {
        return this.str.charAt(this.pos);
    }

    public char readChar() {
        char ch = this.str.charAt(this.pos);
        ++this.pos;
        return ch;
    }

    public char readCommand() {
        if (!this.hasNext()) {
            return '\u0000';
        }
        this.readWhiteSpaces();
        char ch = this.peek();
        char command = '\u0000';
        if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
            command = ch;
            ++this.pos;
            this.readSeparators();
        }
        return command;
    }

    private void digitSequence() {
        char ch;
        while (this.hasNext() && (ch = this.str.charAt(this.pos)) >= '0' && ch <= '9') {
            ++this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() {
        int startPos = this.pos;
        this.readWhiteSpaces();
        char ch = this.str.charAt(this.pos);
        if (ch == '-') {
            ++this.pos;
        }
        this.digitSequence();
        if (this.hasNext() && (ch = this.str.charAt(this.pos)) == '.') {
            ++this.pos;
            this.digitSequence();
        }
        if (this.hasNext() && (ch = this.str.charAt(this.pos)) == 'e') {
            ++this.pos;
            ch = this.str.charAt(this.pos);
            if (ch == '-') {
                ++this.pos;
            }
            this.digitSequence();
        }
        boolean ok = false;
        try {
            double result = Double.parseDouble(this.str.substring(startPos, this.pos));
            this.readSeparators();
            ok = true;
            double d = result;
            return d;
        }
        finally {
            if (!ok) {
                this.pos = startPos;
            }
        }
    }

    private void readWhiteSpaces() {
        while (this.hasNext()) {
            char ch = this.peek();
            if (ch != ' ' && ch != '\r' && ch != '\n') {
                return;
            }
            this.readChar();
        }
    }

    private void readSeparators() {
        while (this.hasNext()) {
            char ch = this.peek();
            if (ch != ' ' && ch != ',' && ch != '\r' && ch != '\n') {
                return;
            }
            this.readChar();
        }
    }
}

