/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCVersion;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.Decimal;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagTypeInfo;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.types.ALPHABITMAPDATA;
import com.jpexs.decompiler.flash.types.ALPHACOLORMAPDATA;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.BITMAPDATA;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CLIPEVENTFLAGS;
import com.jpexs.decompiler.flash.types.COLORMAPDATA;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFOCALGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADRECORD;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.PIX15;
import com.jpexs.decompiler.flash.types.PIX24;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.SOUNDENVELOPE;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.ZONEDATA;
import com.jpexs.decompiler.flash.types.ZONERECORD;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.decompiler.flash.types.gfx.ContourType;
import com.jpexs.decompiler.flash.types.gfx.EdgeType;
import com.jpexs.decompiler.flash.types.gfx.FONTINFO;
import com.jpexs.decompiler.flash.types.gfx.FontType;
import com.jpexs.decompiler.flash.types.gfx.GLYPHIDX;
import com.jpexs.decompiler.flash.types.gfx.GlyphInfoType;
import com.jpexs.decompiler.flash.types.gfx.GlyphType;
import com.jpexs.decompiler.flash.types.gfx.KerningPairType;
import com.jpexs.decompiler.flash.types.gfx.TEXGLYPH;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.HashArrayList;
import com.jpexs.helpers.ReflectionTools;
import com.jpexs.helpers.utf8.Utf8InputStreamReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SwfXmlImporter {
    private static final Logger logger;
    private static final Map<String, Class> swfTags;
    private static final Map<String, Class> swfObjects;
    private static final Map<String, Class> swfObjectsParam;

    private boolean isList(Class cls) {
        return cls != null && (cls.isArray() || List.class.isAssignableFrom(cls));
    }

    public void importSwf(SWF swf, InputStream in) throws IOException {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        try {
            try (Utf8InputStreamReader reader = new Utf8InputStreamReader(new BufferedInputStream(in));){
                XMLStreamReader xmlReader = xmlFactory.createXMLStreamReader(reader);
                xmlReader.nextTag();
                xmlReader.require(1, null, "swf");
                this.processElement(xmlReader, swf, swf, null);
            }
            swf.clearAllCache();
            this.setSwfAndTimelined(swf);
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void setSwfAndTimelined(SWF swf) {
        for (Tag t : swf.getTags()) {
            t.setSwf(swf);
            t.setTimelined(swf);
            if (!(t instanceof DefineSpriteTag)) continue;
            DefineSpriteTag s = (DefineSpriteTag)t;
            for (Tag st : s.getTags()) {
                st.setSwf(swf);
                st.setTimelined(s);
            }
        }
    }

    public Object importObject(String xml, Class requiredType, SWF swf) throws IOException {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = xmlFactory.createXMLStreamReader(new StringReader(xml));
            return this.processObject(reader, requiredType, swf, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | XMLStreamException ex) {
            Logger.getLogger(SwfXmlImporter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private Field getField(Class cls, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = cls.getField(name);
        }
        catch (NoSuchFieldException ex) {
            field = cls.getDeclaredField(name);
            field.setAccessible(true);
        }
        return field;
    }

    private static void setFieldValue(Field field, Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        field.set(obj, value);
    }

    private void processElement(XMLStreamReader reader, Object obj, SWF swf, Tag tag) throws XMLStreamException {
        if (!reader.isStartElement()) {
            reader.nextTag();
            reader.require(1, null, null);
        }
        Class<?> cls = obj.getClass();
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            attributes.put(name, value);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            String name = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (name.equals("tagId") && "UnknownTag".equals(attributes.get("type"))) continue;
            if (name.equals("charset") && "SWF".equals(attributes.get("type"))) {
                ((SWF)obj).setCharset(val);
                continue;
            }
            if (name.equals("reserved1") && "FileAttributesTag".equals(attributes.get("type"))) {
                name = "reservedA";
            }
            if (name.equals("reserved2") && "FileAttributesTag".equals(attributes.get("type"))) {
                name = "swfRelativeUrls";
            }
            if (name.equals("reserved3") && "FileAttributesTag".equals(attributes.get("type"))) {
                name = "reservedB";
            }
            if (name.equals("type")) continue;
            try {
                Field field = this.getField(cls, name);
                SwfXmlImporter.setFieldValue(field, obj, this.getAs(field.getType(), val));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        reader.nextTag();
        while (reader.isStartElement()) {
            String name = reader.getLocalName();
            try {
                Field field = this.getField(cls, name);
                Class<?> childCls = field.getType();
                if (this.isList(childCls)) {
                    ArrayList list = HashArrayList.class.isAssignableFrom(childCls) ? new HashArrayList() : new ArrayList();
                    Class<?> reqType = childCls.isArray() ? childCls.getComponentType() : ReflectionTools.getFieldSubType(obj, field);
                    reader.nextTag();
                    while (reader.isStartElement()) {
                        Object childObj = this.processObject(reader, reqType, swf, tag);
                        list.add(childObj);
                        reader.nextTag();
                    }
                    Object value = list;
                    if (childCls.isArray()) {
                        value = Array.newInstance(childCls.getComponentType(), list.size());
                        for (int j = 0; j < list.size(); ++j) {
                            Array.set(value, j, list.get(j));
                        }
                    }
                    SwfXmlImporter.setFieldValue(field, obj, value);
                } else {
                    Object childObj = this.processObject(reader, null, swf, tag);
                    SwfXmlImporter.setFieldValue(field, obj, childObj);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, "Error while getting val from class " + cls + " field: " + name, ex);
            }
            reader.nextTag();
        }
        if (reader.getEventType() != 2) {
            reader.nextTag();
            reader.require(2, null, null);
        }
    }

    private Object processObject(XMLStreamReader reader, Class requiredType, SWF swf, Tag tag) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InstantiationException, InvocationTargetException, XMLStreamException {
        Object ret;
        if (!reader.isStartElement()) {
            reader.nextTag();
            reader.require(1, null, null);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            attributes.put(name, value);
        }
        String type = (String)attributes.get("type");
        String tagTypeIdStr = (String)attributes.get("tagId");
        int tagTypeId = -1;
        try {
            tagTypeId = Integer.parseInt(tagTypeIdStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("String".equals(type)) {
            ret = reader.getElementText();
        } else if (type != null && !type.isEmpty()) {
            Object childObj = this.createObject(type, tagTypeId, swf, tag);
            if (childObj instanceof Tag) {
                tag = (Tag)childObj;
            }
            this.processElement(reader, childObj, swf, tag);
            ret = childObj;
        } else {
            String isNullAttr = (String)attributes.get("isNull");
            ret = Boolean.parseBoolean(isNullAttr) ? null : this.getAs(requiredType, reader.getElementText());
        }
        if (reader.getEventType() != 2) {
            reader.nextTag();
            reader.require(2, null, null);
        }
        return ret;
    }

    private Object createObject(String type, int tagTypeId, SWF swf, Tag tag) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if ("UnknownTag".equals(type)) {
            return new UnknownTag(swf, tagTypeId);
        }
        Class cls = swfTags.get(type);
        if (cls != null) {
            return cls.getConstructor(SWF.class).newInstance(swf);
        }
        cls = swfObjects.get(type);
        if (cls != null) {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        cls = swfObjectsParam.get(type);
        if (cls != null) {
            for (Constructor<?> constructor : cls.getConstructors()) {
                Class<?> parameterType;
                if (constructor.getParameterCount() != 1 || !(parameterType = constructor.getParameterTypes()[0]).isAssignableFrom(tag.getClass())) continue;
                return constructor.newInstance(tag);
            }
        }
        System.err.println("Type not found: " + type);
        return null;
    }

    private Object getAs(Class cls, String stringValue) throws IllegalArgumentException, IllegalAccessException {
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.parseByte(stringValue);
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.parseShort(stringValue);
        }
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.parseInt(stringValue);
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.parseLong(stringValue);
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(stringValue));
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.parseDouble(stringValue);
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.parseBoolean(stringValue);
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.valueOf(stringValue.charAt(0));
        }
        if (cls == String.class) {
            return stringValue;
        }
        if (cls == ByteArrayRange.class) {
            ByteArrayRange range = new ByteArrayRange(stringValue);
            return range;
        }
        if (cls == byte[].class) {
            ByteArrayRange range = new ByteArrayRange(stringValue);
            return range.getArray();
        }
        if (cls.isEnum()) {
            return Enum.valueOf(cls, stringValue);
        }
        throw new RuntimeException("Unsupported object type: " + cls.getSimpleName() + ".");
    }

    static {
        Class[] knownObjectsParam;
        Class[] knownObjects;
        logger = Logger.getLogger(SwfXmlImporter.class.getName());
        HashMap<String, Class> tags = new HashMap<String, Class>();
        Map<Integer, TagTypeInfo> knownTags = Tag.getKnownClasses();
        for (Integer key : knownTags.keySet()) {
            Class[] cls = knownTags.get(key).getCls();
            if (!ReflectionTools.canInstantiate((Class)cls)) {
                System.err.println("Can't instantiate: " + cls.getName());
            }
            tags.put(cls.getSimpleName(), (Class)cls);
        }
        swfTags = tags;
        HashMap<String, Class> objects = new HashMap<String, Class>();
        for (Class cls2 : knownObjects = new Class[]{ALPHABITMAPDATA.class, ALPHACOLORMAPDATA.class, ARGB.class, BITMAPDATA.class, BUTTONCONDACTION.class, BUTTONRECORD.class, CLIPACTIONRECORD.class, CLIPACTIONS.class, CLIPEVENTFLAGS.class, COLORMAPDATA.class, ColorTransform.class, CXFORM.class, CXFORMWITHALPHA.class, FILLSTYLE.class, FILLSTYLEARRAY.class, FOCALGRADIENT.class, GLYPHENTRY.class, GRADIENT.class, GRADRECORD.class, KERNINGRECORD.class, LANGCODE.class, LINESTYLE.class, LINESTYLE2.class, LINESTYLEARRAY.class, MATRIX.class, MORPHFILLSTYLE.class, MORPHFILLSTYLEARRAY.class, MORPHFOCALGRADIENT.class, MORPHGRADIENT.class, MORPHGRADRECORD.class, MORPHLINESTYLE.class, MORPHLINESTYLE2.class, MORPHLINESTYLEARRAY.class, PIX15.class, PIX24.class, RECT.class, RGB.class, RGBA.class, SHAPE.class, SHAPEWITHSTYLE.class, SOUNDENVELOPE.class, SOUNDINFO.class, TEXTRECORD.class, ZONEDATA.class, ZONERECORD.class, CurvedEdgeRecord.class, EndShapeRecord.class, StraightEdgeRecord.class, StyleChangeRecord.class, BEVELFILTER.class, BLURFILTER.class, COLORMATRIXFILTER.class, CONVOLUTIONFILTER.class, DROPSHADOWFILTER.class, GLOWFILTER.class, GRADIENTBEVELFILTER.class, GRADIENTGLOWFILTER.class, AVM2ConstantPool.class, Decimal.class, Namespace.class, NamespaceSet.class, Multiname.class, MethodInfo.class, MetadataInfo.class, ValueKind.class, InstanceInfo.class, Traits.class, TraitClass.class, TraitFunction.class, TraitMethodGetterSetter.class, TraitSlotConst.class, ClassInfo.class, ScriptInfo.class, MethodBody.class, ABCException.class, ABCVersion.class, Amf3Value.class, ContourType.class, EdgeType.class, FONTINFO.class, FontType.class, GLYPHIDX.class, GlyphInfoType.class, GlyphType.class, KerningPairType.class, TEXGLYPH.class}) {
            if (!ReflectionTools.canInstantiateDefaultConstructor(cls2)) {
                System.err.println("Can't instantiate: " + cls2.getName());
            }
            objects.put(cls2.getSimpleName(), cls2);
        }
        swfObjects = objects;
        HashMap<String, Class> objectsParam = new HashMap<String, Class>();
        for (Class cls2 : knownObjectsParam = new Class[]{ABC.class}) {
            if (!ReflectionTools.canInstantiate(cls2)) {
                System.err.println("Can't instantiate: " + cls2.getName());
            }
            objectsParam.put(cls2.getSimpleName(), cls2);
        }
        swfObjectsParam = objectsParam;
    }
}

