/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.importers.ShapeImporter;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.SoundImportException;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.UnsupportedSamplingRateException;
import com.jpexs.decompiler.flash.types.sound.MP3FRAME;
import com.jpexs.decompiler.flash.types.sound.MP3SOUNDDATA;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundImporter {
    /*
     * Unable to fully structure code
     */
    public boolean importDefineSound(DefineSoundTag soundTag, InputStream is, int newSoundFormat) throws SoundImportException {
        newSoundRate = -1;
        newSoundSize = false;
        newSoundType = false;
        newSoundSampleCount = -1L;
        switch (newSoundFormat) {
            case 3: {
                try {
                    audioIs = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
                    var11_11 = null;
                    fmt = audioIs.getFormat();
                    newSoundType = fmt.getChannels() == 2;
                    newSoundSize = fmt.getSampleSizeInBits() == 16;
                    newSoundSampleCount = audioIs.getFrameLength();
                    newSoundData = Helper.readStream(audioIs);
                    newSoundRate = Math.round(fmt.getSampleRate());
                    switch (newSoundRate) {
                        case 5512: {
                            newSoundRate = 0;
                            break;
                        }
                        case 11025: {
                            newSoundRate = 1;
                            break;
                        }
                        case 22050: {
                            newSoundRate = 2;
                            break;
                        }
                        case 44100: {
                            newSoundRate = 3;
                            break;
                        }
                        default: {
                            throw new UnsupportedSamplingRateException(newSoundRate, new int[]{5512, 11025, 22050, 44100});
                        }
                    }
                    if (audioIs == null) break;
                    if (var11_11 == null) ** GOTO lbl40
                    try {
                        audioIs.close();
                    }
                    catch (Throwable fmt) {
                        var11_11.addSuppressed(fmt);
                    }
                    break;
lbl40:
                    // 1 sources

                    audioIs.close();
                    ** break;
                    catch (Throwable fmt) {
                        try {
                            var11_11 = fmt;
                            throw fmt;
                        }
                        catch (Throwable var13_18) {
                            if (audioIs != null) {
                                if (var11_11 != null) {
                                    try {
                                        audioIs.close();
                                    }
                                    catch (Throwable var14_20) {
                                        var11_11.addSuppressed(var14_20);
                                    }
                                } else {
                                    audioIs.close();
                                }
                            }
                            throw var13_18;
lbl57:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException | UnsupportedAudioFileException ex) {
                    return false;
                }
            }
            case 2: {
                bis = new BufferedInputStream(is);
                this.loadID3v2(bis);
                mp3data = Helper.readStream(bis);
                ID3_V1_LENTGH = 128;
                ID3_V1_EXT_LENGTH = 227;
                if (mp3data.length > 128 && mp3data[mp3data.length - 128] == 84 && mp3data[mp3data.length - 128 + 1] == 65 && mp3data[mp3data.length - 128 + 2] == 71 && (mp3data = Arrays.copyOf(mp3data, mp3data.length - 128)).length > 227 && mp3data[mp3data.length - 227] == 84 && mp3data[mp3data.length - 227 + 1] == 65 && mp3data[mp3data.length - 227 + 2] == 71 && mp3data[mp3data.length - 227 + 3] == 43) {
                    mp3data = Arrays.copyOf(mp3data, mp3data.length - 227);
                }
                try {
                    snd = new MP3SOUNDDATA(new SWFInputStream(soundTag.getSwf(), mp3data), true);
                    if (!snd.frames.isEmpty()) {
                        fr = snd.frames.get(0);
                        newSoundRate = fr.getSamplingRate();
                        switch (newSoundRate) {
                            case 11025: {
                                newSoundRate = 1;
                                break;
                            }
                            case 22050: {
                                newSoundRate = 2;
                                break;
                            }
                            case 44100: {
                                newSoundRate = 3;
                                break;
                            }
                            default: {
                                throw new UnsupportedSamplingRateException(newSoundRate, new int[]{11025, 22050, 44100});
                            }
                        }
                        newSoundSize = true;
                        newSoundType = fr.isStereo();
                        len = snd.sampleCount();
                        if (fr.isStereo()) {
                            len /= 2;
                        }
                        newSoundSampleCount = len;
                    }
                    baos = new ByteArrayOutputStream();
                    sos = new SWFOutputStream(baos, 10, null);
                    sos.writeSI16(0);
                    sos.write(mp3data);
                    newSoundData = baos.toByteArray();
                    break;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        if (newSoundData != null) {
            soundTag.setSoundSize(newSoundSize);
            soundTag.setSoundRate(newSoundRate);
            soundTag.setSoundSampleCount(newSoundSampleCount);
            soundTag.soundData = new ByteArrayRange(newSoundData);
            soundTag.setSoundType(newSoundType);
            soundTag.setSoundCompression(newSoundFormat);
            soundTag.setModified(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadID3v2(InputStream in) {
        int size = -1;
        try {
            in.mark(10);
            size = this.readID3v2Header(in);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
        try {
            if (size > 0) {
                byte[] rawid3v2 = new byte[size];
                in.read(rawid3v2, 0, rawid3v2.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readID3v2Header(InputStream in) throws IOException {
        byte[] id3header = new byte[4];
        int size = -10;
        in.read(id3header, 0, 3);
        if (id3header[0] == 73 && id3header[1] == 68 && id3header[2] == 51) {
            in.read(id3header, 0, 3);
            byte majorVersion = id3header[0];
            byte revision = id3header[1];
            in.read(id3header, 0, 4);
            size = (id3header[0] << 21) + (id3header[1] << 14) + (id3header[2] << 7) + id3header[3];
        }
        return size + 10;
    }

    /*
     * Unable to fully structure code
     */
    public boolean importSoundStream(SoundStreamHeadTypeTag streamHead, InputStream is, int newSoundFormat) throws UnsupportedSamplingRateException {
        mp3Frames = null;
        newSoundRate = -1;
        newSoundSize = false;
        newSoundType = false;
        newSoundSampleCount = -1L;
        uncompressedSoundData = null;
        bytesPerSwfFrame = -1;
        swf = streamHead.getSwf();
        sampleLen = 0;
        soundRateHz = 0;
        switch (newSoundFormat) {
            case 3: {
                try {
                    audioIs = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
                    var16_16 = null;
                    fmt = audioIs.getFormat();
                    newSoundType = fmt.getChannels() == 2;
                    newSoundSize = fmt.getSampleSizeInBits() == 16;
                    uncompressedSoundData = Helper.readStream(audioIs);
                    sampleLen = (newSoundType != false ? 2 : 1) * (newSoundSize != false ? 2 : 1);
                    soundRateHz = Math.round(fmt.getSampleRate());
                    newSoundSampleCount = (int)Math.ceil((float)soundRateHz / swf.frameRate);
                    bytesPerSwfFrame = (int)Math.ceil((float)soundRateHz / swf.frameRate) * sampleLen;
                    switch (soundRateHz) {
                        case 5512: {
                            newSoundRate = 0;
                            break;
                        }
                        case 11025: {
                            newSoundRate = 1;
                            break;
                        }
                        case 22050: {
                            newSoundRate = 2;
                            break;
                        }
                        case 44100: {
                            newSoundRate = 3;
                            break;
                        }
                        default: {
                            throw new UnsupportedSamplingRateException(newSoundRate, new int[]{5512, 11025, 22050, 44100});
                        }
                    }
                    if (audioIs == null) break;
                    if (var16_16 == null) ** GOTO lbl48
                    try {
                        audioIs.close();
                    }
                    catch (Throwable fmt) {
                        var16_16.addSuppressed(fmt);
                    }
                    break;
lbl48:
                    // 1 sources

                    audioIs.close();
                    ** break;
                    catch (Throwable fmt) {
                        try {
                            var16_16 = fmt;
                            throw fmt;
                        }
                        catch (Throwable var18_22) {
                            if (audioIs != null) {
                                if (var16_16 != null) {
                                    try {
                                        audioIs.close();
                                    }
                                    catch (Throwable var19_25) {
                                        var16_16.addSuppressed(var19_25);
                                    }
                                } else {
                                    audioIs.close();
                                }
                            }
                            throw var18_22;
lbl65:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException | UnsupportedAudioFileException ex) {
                    return false;
                }
            }
            case 2: {
                bis = new BufferedInputStream(is);
                this.loadID3v2(bis);
                mp3data = Helper.readStream(bis);
                ID3_V1_LENTGH = 128;
                ID3_V1_EXT_LENGTH = 227;
                if (mp3data.length > 128 && mp3data[mp3data.length - 128] == 84 && mp3data[mp3data.length - 128 + 1] == 65 && mp3data[mp3data.length - 128 + 2] == 71 && (mp3data = Arrays.copyOf(mp3data, mp3data.length - 128)).length > 227 && mp3data[mp3data.length - 227] == 84 && mp3data[mp3data.length - 227 + 1] == 65 && mp3data[mp3data.length - 227 + 2] == 71 && mp3data[mp3data.length - 227 + 3] == 43) {
                    mp3data = Arrays.copyOf(mp3data, mp3data.length - 227);
                }
                try {
                    snd = new MP3SOUNDDATA(new SWFInputStream(swf, mp3data), true);
                    if (!snd.frames.isEmpty()) {
                        fr = snd.frames.get(0);
                        soundRateHz = fr.getSamplingRate();
                        switch (soundRateHz) {
                            case 11025: {
                                newSoundRate = 1;
                                break;
                            }
                            case 22050: {
                                newSoundRate = 2;
                                break;
                            }
                            case 44100: {
                                newSoundRate = 3;
                                break;
                            }
                            default: {
                                throw new UnsupportedSamplingRateException(newSoundRate, new int[]{11025, 22050, 44100});
                            }
                        }
                        newSoundSize = true;
                        newSoundType = fr.isStereo();
                        newSoundSampleCount = (int)Math.ceil((float)soundRateHz / swf.frameRate);
                    }
                    mp3Frames = snd.frames;
                    break;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        bais = uncompressedSoundData == null ? null : new ByteArrayInputStream(uncompressedSoundData);
        existingBlocks = streamHead.getBlocks();
        startFrame = 0;
        timelined = streamHead.getTimelined();
        if (!existingBlocks.isEmpty()) {
            tags = timelined.getTags();
            fr = tags.iterator();
            while (fr.hasNext()) {
                t = (Tag)fr.next();
                if (t instanceof ShowFrameTag) {
                    ++startFrame;
                }
                if (!(t instanceof SoundStreamBlockTag)) continue;
                break;
            }
        }
        for (SoundStreamBlockTag block : existingBlocks) {
            timelined.removeTag(block);
        }
        blocks = new ArrayList<SoundStreamBlockTag>();
        if (bais != null) {
            dais = new DataInputStream(bais);
            pos = 0L;
            frame = 0;
            lastNumSamplesLong = 0L;
            try {
                while (dais.available() > 0) {
                    timeAfterFrame = (float)(frame + 1) / swf.frameRate;
                    numSamplesAfterFrame = (float)((frame + 1) * soundRateHz) / swf.frameRate;
                    numSamplesAfterFrameLong = (long)Math.ceil(numSamplesAfterFrame);
                    deltaNumSamples = numSamplesAfterFrameLong - lastNumSamplesLong;
                    lastNumSamplesLong = numSamplesAfterFrameLong;
                    if (deltaNumSamples > 0L) {
                        buf = new byte[(int)deltaNumSamples * sampleLen];
                        dais.readFully(buf);
                        block = new SoundStreamBlockTag(swf);
                        block.streamSoundData = new ByteArrayRange(buf);
                        blocks.add(block);
                    } else {
                        block = new SoundStreamBlockTag(swf);
                        block.streamSoundData = new ByteArrayRange(new byte[0]);
                        blocks.add(block);
                    }
                    ++frame;
                }
            }
            catch (IOException timeAfterFrame) {
                // empty catch block
            }
        }
        if (mp3Frames != null) {
            frame = 0;
            mp3FrameNum = 0;
            lastNumSamplesLong = 0L;
            while (mp3FrameNum < mp3Frames.size()) {
                timeAfterFrame = (float)(frame + 1) / swf.frameRate;
                numSamplesAfterFrame = (float)((frame + 1) * soundRateHz) / swf.frameRate;
                numSamplesBeforeFrameLong = Math.round((float)(frame * soundRateHz) / swf.frameRate);
                seekSamples = (int)(lastNumSamplesLong - numSamplesBeforeFrameLong);
                block = new SoundStreamBlockTag(swf);
                blockMp3Frames = new ArrayList<MP3FRAME>();
                blockSamples = 0;
                while ((float)lastNumSamplesLong < numSamplesAfterFrame && mp3FrameNum < mp3Frames.size()) {
                    mp3Frame = mp3Frames.get(mp3FrameNum);
                    lastNumSamplesLong += (long)mp3Frame.getSampleCount();
                    blockSamples += mp3Frame.getSampleCount();
                    blockMp3Frames.add(mp3Frame);
                    ++mp3FrameNum;
                }
                baos = new ByteArrayOutputStream();
                sos = new SWFOutputStream(baos, 10, null);
                try {
                    sos.writeUI16(blockSamples);
                    sos.writeSI16(seekSamples);
                    for (MP3FRAME mp3Frame : blockMp3Frames) {
                        sos.write(mp3Frame.getBytes());
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(SoundStreamHeadTypeTag.class.getName()).log(Level.SEVERE, null, ex);
                }
                block.streamSoundData = new ByteArrayRange(baos.toByteArray());
                blocks.add(block);
                ++frame;
            }
        }
        tags = timelined.getTags();
        frame = -1;
        for (i = 0; i < tags.size(); ++i) {
            t = tags.get(i);
            if (!(t instanceof ShowFrameTag) || ++frame < startFrame || blocks.isEmpty()) continue;
            block = (SoundStreamBlockTag)blocks.remove(0);
            block.setTimelined(timelined);
            timelined.addTag(i, block);
            tags = timelined.getTags();
            ++i;
        }
        framesBefore = timelined.getFrameCount();
        while (!blocks.isEmpty()) {
            block = (SoundStreamBlockTag)blocks.remove(0);
            block.setTimelined(timelined);
            timelined.addTag(block);
            sft = new ShowFrameTag(swf);
            sft.setTimelined(timelined);
            timelined.addTag(sft);
            ++framesBefore;
        }
        timelined.setFrameCount(framesBefore);
        streamHead.setSoundCompression(newSoundFormat);
        streamHead.setSoundSampleCount((int)newSoundSampleCount);
        streamHead.setSoundSize(newSoundSize);
        streamHead.setSoundType(newSoundType);
        streamHead.setSoundRate(newSoundRate);
        streamHead.setModified(true);
        timelined.resetTimeline();
        swf.resetTimeline();
        return true;
    }

    public boolean importSound(SoundTag soundTag, InputStream is, int newSoundFormat) throws SoundImportException {
        if (soundTag instanceof DefineSoundTag) {
            return this.importDefineSound((DefineSoundTag)soundTag, is, newSoundFormat);
        }
        if (soundTag instanceof SoundStreamHeadTypeTag) {
            return this.importSoundStream((SoundStreamHeadTypeTag)soundTag, is, newSoundFormat);
        }
        return false;
    }

    public int bulkImport(File soundDir, SWF swf, boolean printOut) {
        Map<Integer, CharacterTag> characters = swf.getCharacters();
        int soundCount = 0;
        final List<String> extensions = Arrays.asList("mp3", "wav");
        File[] allFiles = soundDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                for (String ext : extensions) {
                    if (!nameLower.endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        ArrayList<Tag> soundTags = new ArrayList<Tag>();
        Iterator<Serializable> iterator = characters.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            CharacterTag tag = characters.get(n);
            if (tag instanceof DefineSoundTag) {
                soundTags.add((DefineSoundTag)tag);
            }
            if (!(tag instanceof DefineSpriteTag)) continue;
            DefineSpriteTag sprite = (DefineSpriteTag)tag;
            for (Tag subTag : sprite.getTags()) {
                if (!(subTag instanceof SoundStreamHeadTypeTag)) continue;
                soundTags.add((SoundStreamHeadTypeTag)subTag);
            }
        }
        for (Tag tag : swf.getTags()) {
            if (!(tag instanceof SoundStreamHeadTypeTag)) continue;
            soundTags.add((SoundStreamHeadTypeTag)tag);
        }
        for (SoundTag soundTag : soundTags) {
            int characterId = soundTag.getCharacterId();
            ArrayList<File> existingFilesForSoundTag = new ArrayList<File>();
            for (File f : allFiles) {
                if (!f.getName().startsWith("" + characterId + ".") && !f.getName().startsWith("" + characterId + "_")) continue;
                existingFilesForSoundTag.add(f);
            }
            existingFilesForSoundTag.sort(new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    String ext1 = o1.getName().substring(o1.getName().lastIndexOf(".") + 1);
                    String ext2 = o2.getName().substring(o2.getName().lastIndexOf(".") + 1);
                    int ret = extensions.indexOf(ext1) - extensions.indexOf(ext2);
                    if (ret == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return ret;
                }
            });
            if (existingFilesForSoundTag.isEmpty()) continue;
            if (existingFilesForSoundTag.size() > 1) {
                Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Multiple matching files for sound tag {0} exists, {1} selected", new Object[]{characterId, ((File)existingFilesForSoundTag.get(0)).getName()});
            }
            File sourceFile = (File)existingFilesForSoundTag.get(0);
            try {
                if (printOut) {
                    System.out.println("Importing character " + characterId + " from file " + sourceFile.getName());
                }
                int soundFormat = 3;
                if (sourceFile.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
                    soundFormat = 2;
                }
                try (FileInputStream fis = new FileInputStream(sourceFile);){
                    this.importSound(soundTag, fis, soundFormat);
                    ++soundCount;
                }
            }
            catch (SoundImportException | IOException ex) {
                Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Cannot import sound " + characterId + " from file " + sourceFile.getName(), ex);
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
        return soundCount;
    }
}

