/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.importers.svg.SvgImporter;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG4Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLosslessTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.helpers.Helper;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShapeImporter {
    public Tag importImage(ShapeTag st, byte[] newData) throws IOException {
        return this.importImage(st, newData, 0, true);
    }

    public Tag importImage(ShapeTag st, byte[] newData, int tagType, boolean fill) throws IOException {
        SHAPEWITHSTYLE shapes;
        ImageTag imageTag = this.addImage(st, newData, tagType);
        st.setModified(true);
        RECT rect = st.getRect();
        if (!fill) {
            Dimension dimension = imageTag.getImageDimension();
            rect.Xmax = rect.Xmin + (int)(20.0 * dimension.getWidth());
            rect.Ymax = rect.Ymin + (int)(20.0 * dimension.getHeight());
        }
        st.shapes = shapes = imageTag.getShape(rect, fill, st.getShapeNum());
        return st;
    }

    public ImageTag addImage(Tag st, byte[] newData, int tagType) throws IOException {
        ImageTag imageTag;
        SWF swf = st.getSwf();
        if (newData[0] == 66 && newData[1] == 77) {
            BufferedImage b = ImageHelper.read(newData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageHelper.write(b, ImageFormat.PNG, baos);
            newData = baos.toByteArray();
        }
        if (tagType == 0) {
            tagType = ImageTag.getImageFormat(newData) == ImageFormat.JPEG ? 21 : 36;
        }
        switch (tagType) {
            case 21: {
                imageTag = new DefineBitsJPEG2Tag(swf, null, swf.getNextCharacterId(), newData);
                break;
            }
            case 35: {
                imageTag = new DefineBitsJPEG3Tag(swf, null, swf.getNextCharacterId(), newData);
                break;
            }
            case 90: {
                imageTag = new DefineBitsJPEG4Tag(swf, null, swf.getNextCharacterId(), newData);
                break;
            }
            case 20: {
                DefineBitsLosslessTag losslessTag = new DefineBitsLosslessTag(swf);
                losslessTag.setImage(newData);
                imageTag = losslessTag;
                break;
            }
            case 36: {
                DefineBitsLossless2Tag lossless2Tag = new DefineBitsLossless2Tag(swf);
                lossless2Tag.setImage(newData);
                imageTag = lossless2Tag;
                break;
            }
            default: {
                throw new Error("Unsupported image type tag.");
            }
        }
        SWF.addTagBefore(imageTag, st);
        swf.updateCharacters();
        return imageTag;
    }

    public static int getShapeTagType(String format) {
        int res = 0;
        switch (format) {
            case "shape": {
                res = 2;
                break;
            }
            case "shape2": {
                res = 22;
                break;
            }
            case "shape3": {
                res = 32;
                break;
            }
            case "shape4": {
                res = 83;
            }
        }
        return res;
    }

    public int bulkImport(File shapesDir, SWF swf, boolean noFill, boolean printOut) {
        SvgImporter svgImporter = new SvgImporter();
        Map<Integer, CharacterTag> characters = swf.getCharacters();
        int shapeCount = 0;
        final List<String> extensions = Arrays.asList("svg", "png", "jpg", "jpeg", "gif", "bmp");
        File[] allFiles = shapesDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                for (String ext : extensions) {
                    if (!nameLower.endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        for (int characterId : characters.keySet()) {
            CharacterTag tag = characters.get(characterId);
            if (!(tag instanceof ShapeTag)) continue;
            ShapeTag shapeTag = (ShapeTag)tag;
            ArrayList<File> existingFilesForShapeTag = new ArrayList<File>();
            for (File f : allFiles) {
                if (!f.getName().startsWith("" + characterId + ".") && !f.getName().startsWith("" + characterId + "_")) continue;
                existingFilesForShapeTag.add(f);
            }
            existingFilesForShapeTag.sort(new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    String ext1 = o1.getName().substring(o1.getName().lastIndexOf(".") + 1);
                    String ext2 = o2.getName().substring(o2.getName().lastIndexOf(".") + 1);
                    int ret = extensions.indexOf(ext1) - extensions.indexOf(ext2);
                    if (ret == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return ret;
                }
            });
            if (existingFilesForShapeTag.isEmpty()) continue;
            if (existingFilesForShapeTag.size() > 1) {
                Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Multiple matching files for shape tag {0} exists, {1} selected", new Object[]{characterId, ((File)existingFilesForShapeTag.get(0)).getName()});
            }
            File sourceFile = (File)existingFilesForShapeTag.get(0);
            try {
                if (printOut) {
                    System.out.println("Importing character " + characterId + " from file " + sourceFile.getName());
                }
                if (sourceFile.getAbsolutePath().toLowerCase().endsWith(".svg")) {
                    svgImporter.importSvg(shapeTag, Helper.readTextFile(sourceFile.getAbsolutePath()), !noFill);
                } else {
                    this.importImage(shapeTag, Helper.readFile(sourceFile.getAbsolutePath()), 0, !noFill);
                }
                ++shapeCount;
            }
            catch (IOException ex) {
                Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Cannot import shape " + characterId + " from file " + sourceFile.getName(), ex);
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
        return shapeCount;
    }
}

