/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.conversion;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.iggy.IggyCharAdvances;
import com.jpexs.decompiler.flash.iggy.IggyCharIndices;
import com.jpexs.decompiler.flash.iggy.IggyCharKerning;
import com.jpexs.decompiler.flash.iggy.IggyCharOffset;
import com.jpexs.decompiler.flash.iggy.IggyFont;
import com.jpexs.decompiler.flash.iggy.IggyShape;
import com.jpexs.decompiler.flash.iggy.IggySwf;
import com.jpexs.decompiler.flash.iggy.IggyText;
import com.jpexs.decompiler.flash.iggy.conversion.SwfShapeToIggyConvertor;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.SHAPE;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class SwfToIggyConvertor {
    private static float normalizeLengths(int val) {
        return (float)val / 1024.0f;
    }

    public static void updateIggy(IggySwf iggySwf, SWF swf) throws IOException {
        ArrayList<DefineFont2Tag> fontTags = new ArrayList<DefineFont2Tag>();
        ArrayList<DefineEditTextTag> textTags = new ArrayList<DefineEditTextTag>();
        ArrayList<DoABC2Tag> abcTags = new ArrayList<DoABC2Tag>();
        for (Tag t : swf.getTags()) {
            if (t instanceof DefineFont2Tag) {
                fontTags.add((DefineFont2Tag)t);
            }
            if (t instanceof DefineEditTextTag) {
                textTags.add((DefineEditTextTag)t);
            }
            if (!(t instanceof DoABC2Tag)) continue;
            abcTags.add((DoABC2Tag)t);
        }
        if (abcTags.size() > 1) {
            throw new IOException("Cannot save more than one ABC tag");
        }
        int fontCount = iggySwf.getFonts().size();
        if (fontCount != fontTags.size()) {
            throw new IOException("Font count is different from original iggy file");
        }
        for (int i = 0; i < fontCount; ++i) {
            IggyFont iggyFont = iggySwf.getFonts().get(i);
            DefineFont2Tag fontTag = (DefineFont2Tag)fontTags.get(i);
            SwfToIggyConvertor.updateIggyFont(iggyFont, fontTag);
        }
        int textCount = iggySwf.getTexts().size();
        if (textCount != textTags.size()) {
            throw new IOException("Text count is different from original iggy file");
        }
        for (int i = 0; i < textCount; ++i) {
            IggyText iggyText = iggySwf.getTexts().get(i);
            DefineEditTextTag textTag = (DefineEditTextTag)textTags.get(i);
            SwfToIggyConvertor.updateIggyText(iggyText, textTag);
        }
        if (!abcTags.isEmpty()) {
            DoABC2Tag abcTag = (DoABC2Tag)abcTags.get(0);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] abcTagData = abcTag.getData();
            byte[] declData = Arrays.copyOfRange(abcTagData, 8, abcTagData.length);
            iggySwf.getDeclStrings().setData(declData);
        }
    }

    public static void updateIggyText(IggyText iggyText, DefineEditTextTag textTag) {
        iggyText.setInitialText(textTag.initialText);
    }

    public static void updateIggyFont(IggyFont iggyFont, DefineFont2Tag fontTag) {
        ArrayList<IggyCharOffset> charOffsets = new ArrayList<IggyCharOffset>();
        ArrayList<IggyShape> glyphs = new ArrayList<IggyShape>();
        for (SHAPE sHAPE : fontTag.glyphShapeTable) {
            glyphs.add(SwfShapeToIggyConvertor.convertShape(1, sHAPE));
        }
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int code : fontTag.codeTable) {
            chars.add(Character.valueOf((char)code));
        }
        IggyCharIndices iggyCharIndices = new IggyCharIndices(chars);
        ArrayList<Float> scales = new ArrayList<Float>();
        for (int adv : fontTag.fontAdvanceTable) {
            scales.add(Float.valueOf(SwfToIggyConvertor.normalizeLengths(adv)));
        }
        IggyCharAdvances charScales = new IggyCharAdvances(scales);
        ArrayList<Character> charA = new ArrayList<Character>();
        ArrayList<Character> charB = new ArrayList<Character>();
        ArrayList<Short> kernOffs = new ArrayList<Short>();
        for (KERNINGRECORD rec : fontTag.fontKerningTable) {
            charA.add(Character.valueOf((char)rec.fontKerningCode1));
            charB.add(Character.valueOf((char)rec.fontKerningCode2));
            kernOffs.add((short)rec.fontKerningAdjustment);
        }
        IggyCharKerning charKernings = new IggyCharKerning(charA, charB, kernOffs);
        for (int i = 0; i < fontTag.getCharacterCount(); ++i) {
            charOffsets.add(new IggyCharOffset(1, 0, 80, 19));
        }
        iggyFont.setCharCount(fontTag.getCharacterCount());
        iggyFont.setCharCount2(fontTag.getCharacterCount());
        iggyFont.setAscent(fontTag.getAscent());
        iggyFont.setDescent(fontTag.getDescent());
        iggyFont.setLeading(fontTag.getLeading());
        iggyFont.setName(fontTag.getFontName());
        iggyFont.setCharOffsets(charOffsets);
        iggyFont.setGlyphs(glyphs);
        iggyFont.setCodePoints(iggyCharIndices);
        iggyFont.setCharScales(charScales);
        iggyFont.setCharKernings(charKernings);
    }

    public static IggyFont createIggyFont(DefineFont2Tag fontTag) {
        byte[] zeroone = new byte[28];
        zeroone[12] = 1;
        long flags = 65795L;
        float[] unk_float = new float[]{-0.6484375f, -1.116211f, 1.116211f, 0.6679688f, 0.0f};
        int xscale = 80;
        int yscale = 28;
        float ssr1 = 0.9f;
        float ssr2 = 0.3f;
        long what_2 = 33188160L;
        long what_3 = 33600216L;
        byte[] zeroes48a = new byte[48];
        byte[] zeroes48b = new byte[48];
        float sss1 = 1.1728859f;
        float sss2 = 1.1728706f;
        float sss3 = 1.1728821f;
        float sss4 = 1.1729145f;
        ArrayList<IggyCharOffset> charOffsets = new ArrayList<IggyCharOffset>();
        ArrayList<IggyShape> glyphs = new ArrayList<IggyShape>();
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int code : fontTag.codeTable) {
            chars.add(Character.valueOf((char)code));
        }
        IggyCharIndices codePoints = new IggyCharIndices(chars);
        ArrayList<Float> scales = new ArrayList<Float>();
        for (int adv : fontTag.fontAdvanceTable) {
            scales.add(Float.valueOf(adv));
        }
        IggyCharAdvances charScales = new IggyCharAdvances(scales);
        ArrayList<Character> charA = new ArrayList<Character>();
        ArrayList<Character> charB = new ArrayList<Character>();
        ArrayList<Short> kernOffs = new ArrayList<Short>();
        for (KERNINGRECORD rec : fontTag.fontKerningTable) {
            charA.add(Character.valueOf((char)rec.fontKerningCode1));
            charB.add(Character.valueOf((char)rec.fontKerningCode2));
            kernOffs.add((short)rec.fontKerningAdjustment);
        }
        IggyCharKerning charKernings = new IggyCharKerning(charA, charB, kernOffs);
        IggyFont iggyFont = new IggyFont(65302, 0, zeroone, fontTag.getCharacterCount(), fontTag.getAscent(), fontTag.getDescent(), fontTag.getLeading(), flags, fontTag.fontKerningTable.size(), unk_float, 0L, what_2, 0L, 1L, xscale, yscale, 0L, ssr1, ssr2, fontTag.getCharacterCount(), 0L, what_3, zeroes48a, zeroes48b, sss1, 1L, sss2, 1L, sss3, 1L, sss4, 1L, fontTag.getFontName(), charOffsets, glyphs, codePoints, charScales, charKernings);
        return iggyFont;
    }
}

