/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.conversion;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.iggy.IggyCharAdvances;
import com.jpexs.decompiler.flash.iggy.IggyCharKerning;
import com.jpexs.decompiler.flash.iggy.IggyDeclStrings;
import com.jpexs.decompiler.flash.iggy.IggyFile;
import com.jpexs.decompiler.flash.iggy.IggyFont;
import com.jpexs.decompiler.flash.iggy.IggyShape;
import com.jpexs.decompiler.flash.iggy.IggySwf;
import com.jpexs.decompiler.flash.iggy.IggyText;
import com.jpexs.decompiler.flash.iggy.conversion.IggyShapeToSwfConvertor;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.helpers.ByteArrayRange;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class IggyToSwfConvertor {
    public static void exportAllSwfsToDir(IggyFile file, File outputDir) throws IOException {
        IggyToSwfConvertor.exportSwfToDir(file, outputDir);
    }

    public static void exportSwfToDir(IggyFile file, File outputDir) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(new File(outputDir, file.getSwfName()));){
            IggyToSwfConvertor.exportSwf(file, fos);
        }
    }

    public static void exportSwfToFile(IggyFile file, File outputFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            IggyToSwfConvertor.exportSwf(file, fos);
        }
    }

    public static void exportSwf(IggyFile file, OutputStream output) throws IOException {
        SWF swf = IggyToSwfConvertor.getSwf(file);
        swf.saveTo(output);
    }

    private static int makeLengthsEm(double val) {
        return (int)(val * 1024.0);
    }

    private static int makeLengthsTwip(double val) {
        return (int)(val * 20.0);
    }

    public static SWF getSwf(IggyFile file) {
        SWF swf = new SWF();
        swf.compression = SWFCompression.NONE;
        swf.frameCount = 1;
        swf.frameRate = file.getSwfFrameRate();
        swf.gfx = false;
        swf.displayRect = new RECT(IggyToSwfConvertor.makeLengthsTwip(file.getSwfXMin()), IggyToSwfConvertor.makeLengthsTwip(file.getSwfXMax()), IggyToSwfConvertor.makeLengthsTwip(file.getSwfYMin()), IggyToSwfConvertor.makeLengthsTwip(file.getSwfYMax()));
        swf.version = 10;
        FileAttributesTag fat = new FileAttributesTag(swf);
        fat.actionScript3 = true;
        fat.hasMetadata = false;
        fat.useNetwork = false;
        swf.addTag(fat);
        IggySwf iggySwf = file.getSwf();
        int currentCharId = 0;
        HashMap<Integer, Integer> fontIndex2CharId = new HashMap<Integer, Integer>();
        for (int fontIndex = 0; fontIndex < iggySwf.getFonts().size(); ++fontIndex) {
            IggyFont iggyFont = iggySwf.getFonts().get(fontIndex);
            DefineFont2Tag fontTag = new DefineFont2Tag(swf);
            fontIndex2CharId.put(fontIndex, ++currentCharId);
            fontTag.fontID = currentCharId;
            fontTag.fontKerningTable = new ArrayList<KERNINGRECORD>();
            IggyCharKerning ker = iggyFont.getCharKernings();
            if (ker != null) {
                int i = 0;
                while ((long)i < ker.getKernCount()) {
                    char kerningCode1 = ker.getCharsA().get(i).charValue();
                    char kerningCode2 = ker.getCharsA().get(i).charValue();
                    short kerningOffset = ker.getKerningOffsets().get(i);
                    fontTag.fontKerningTable.add(new KERNINGRECORD(kerningCode1, (int)kerningCode2, kerningOffset));
                    ++i;
                }
            }
            fontTag.fontFlagsWideCodes = true;
            fontTag.fontFlagsWideOffsets = true;
            fontTag.fontAscent = iggyFont.getAscent();
            fontTag.fontDescent = iggyFont.getDescent();
            fontTag.fontLeading = iggyFont.getLeading();
            fontTag.codeTable = new ArrayList<Integer>();
            fontTag.fontName = iggyFont.getName();
            fontTag.glyphShapeTable = new ArrayList<SHAPE>();
            fontTag.fontBoundsTable = new ArrayList<RECT>();
            fontTag.fontAdvanceTable = new ArrayList<Integer>();
            fontTag.fontFlagsHasLayout = true;
            IggyCharAdvances advanceValues = iggyFont.getCharAdvances();
            int i = 0;
            while ((long)i < iggyFont.getCharacterCount()) {
                SHAPE shp;
                char code = iggyFont.getCharIndices().getChars().get(i).charValue();
                fontTag.codeTable.add(Integer.valueOf(code));
                IggyShape glyph = iggyFont.getChars().get(i);
                if (glyph != null) {
                    shp = IggyShapeToSwfConvertor.convertCharToShape(glyph);
                    fontTag.fontBoundsTable.add(shp.getBounds(1));
                } else {
                    shp = new SHAPE();
                    shp.shapeRecords = new ArrayList<SHAPERECORD>();
                    shp.shapeRecords.add(new EndShapeRecord());
                    fontTag.fontBoundsTable.add(new RECT());
                }
                fontTag.glyphShapeTable.add(shp);
                fontTag.fontAdvanceTable.add(IggyToSwfConvertor.makeLengthsEm(advanceValues.getScales().get(i).floatValue()));
                ++i;
            }
            fontTag.setModified(true);
            swf.addTag(fontTag);
        }
        HashMap<Integer, Integer> textIndex2CharId = new HashMap<Integer, Integer>();
        for (int textIndex = 0; textIndex < iggySwf.getTexts().size(); ++textIndex) {
            IggyText iggyText = iggySwf.getTexts().get(textIndex);
            DefineEditTextTag textTag = new DefineEditTextTag(swf);
            textIndex2CharId.put(textIndex, ++currentCharId);
            textTag.characterID = currentCharId;
            textTag.hasText = true;
            textTag.initialText = iggyText.getInitialText();
            textTag.html = true;
            textTag.noSelect = true;
            textTag.wasStatic = true;
            textTag.hasFont = false;
            textTag.hasFontClass = false;
            textTag.hasMaxLength = false;
            textTag.readOnly = true;
            textTag.bounds = new RECT(IggyToSwfConvertor.makeLengthsTwip(iggyText.getPar1()), IggyToSwfConvertor.makeLengthsTwip(iggyText.getPar3()), IggyToSwfConvertor.makeLengthsTwip(iggyText.getPar2()), IggyToSwfConvertor.makeLengthsTwip(iggyText.getPar4()));
            textTag.setModified(true);
            swf.addTag(textTag);
        }
        IggyDeclStrings declStrings = iggySwf.getDeclStrings();
        if (declStrings != null) {
            byte[] abcData = declStrings.getData();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(new byte[]{1, 0, 0, 0, 0, 16, 0, 46});
                baos.write(abcData);
            }
            catch (IOException advanceValues) {
                // empty catch block
            }
            byte[] fullAbcTagData = baos.toByteArray();
            try {
                DoABC2Tag nabc = new DoABC2Tag(new SWFInputStream(swf, fullAbcTagData), new ByteArrayRange(fullAbcTagData));
                nabc.setModified(true);
                swf.addTag(nabc);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        swf.addTag(new EndTag(swf));
        swf.setModified(true);
        return swf;
    }

    public static void main(String[] args) {
        File outDir;
        File file;
        if (args.length < 2 || args[0].isEmpty() || args[1].isEmpty()) {
            System.err.println("Invalid arguments");
            System.err.println("Usage: iggy-extract.bat file.iggy d:/outdir/");
            System.exit(1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.err.println("FAIL: Input file: " + file.getAbsolutePath() + " does not exist.");
            System.exit(1);
        }
        if (!(outDir = new File(args[1])).exists() && !outDir.mkdirs()) {
            System.err.println("FAIL: Cannot create output directory");
            System.exit(1);
        }
        try {
            System.out.print("(1/2) Loading file " + args[0] + "...");
            IggyFile iggyFile = new IggyFile(new File(args[0]));
            System.out.println("OK");
            System.out.print("(2/2) Exporting SWF files to " + args[1] + "...");
            IggyToSwfConvertor.exportAllSwfsToDir(iggyFile, new File(args[1]));
            System.out.println("OK");
            System.out.println("All finished sucessfully.");
            System.exit(0);
        }
        catch (IOException ex) {
            System.out.println("FAIL");
            System.err.println("Error while converting: " + ex.getMessage());
            System.exit(1);
        }
    }
}

