/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ImportAssets2Tag;
import com.jpexs.decompiler.flash.tags.ImportAssetsTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalGradient;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage2;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalStreamSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineGradientMap;
import com.jpexs.decompiler.flash.tags.gfx.DefineSubImage;
import com.jpexs.decompiler.flash.tags.gfx.ExporterInfo;
import com.jpexs.decompiler.flash.tags.gfx.FontTextureInfo;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.gfx.FontType;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GfxConvertor {
    public DefineFont2Tag convertDefineCompactedFont(DefineCompactedFont compactedFont) {
        DefineFont2Tag ret = new DefineFont2Tag(compactedFont.getSwf());
        ret.fontID = compactedFont.getFontId();
        ret.fontFlagsBold = compactedFont.isBold();
        ret.fontFlagsItalic = compactedFont.isItalic();
        ret.fontFlagsWideOffsets = true;
        ret.fontFlagsWideCodes = true;
        ret.fontFlagsHasLayout = true;
        ret.fontAscent = compactedFont.resize(compactedFont.getAscent());
        ret.fontDescent = compactedFont.resize(compactedFont.getDescent());
        ret.fontLeading = compactedFont.resize(compactedFont.getLeading());
        ret.fontAdvanceTable = new ArrayList<Integer>();
        ret.fontBoundsTable = new ArrayList<RECT>();
        ret.codeTable = new ArrayList<Integer>();
        ret.glyphShapeTable = new ArrayList<SHAPE>();
        List<SHAPE> shp = compactedFont.getGlyphShapeTable();
        for (int g = 0; g < shp.size(); ++g) {
            ret.fontAdvanceTable.add((int)compactedFont.getGlyphAdvance(g));
            ret.codeTable.add(Integer.valueOf(compactedFont.glyphToChar(g)));
            SHAPE shpX = compactedFont.resizeShape(shp.get(g));
            ret.glyphShapeTable.add(shpX);
            ret.fontBoundsTable.add(compactedFont.getGlyphBounds(g));
        }
        ret.fontName = compactedFont.getFontNameIntag();
        ret.languageCode = new LANGCODE(1);
        ret.fontKerningTable = new ArrayList<KERNINGRECORD>();
        FontType ft = compactedFont.fonts.get(0);
        for (int i = 0; i < ft.kerning.size(); ++i) {
            KERNINGRECORD kr = new KERNINGRECORD();
            kr.fontKerningAdjustment = compactedFont.resize(ft.kerning.get((int)i).advance);
            kr.fontKerningCode1 = ft.kerning.get((int)i).char1;
            kr.fontKerningCode2 = ft.kerning.get((int)i).char2;
            ret.fontKerningTable.add(kr);
        }
        return ret;
    }

    public DefineBitsLossless2Tag convertDefineSubImage(DefineSubImage defineSubImage) {
        DefineBitsLossless2Tag ret = new DefineBitsLossless2Tag(defineSubImage.getSwf());
        ret.characterID = defineSubImage.characterID;
        ret.bitmapWidth = defineSubImage.getImageDimension().width;
        ret.bitmapHeight = defineSubImage.getImageDimension().height;
        ret.bitmapFormat = 5;
        try {
            ret.setImage(Helper.readStream(defineSubImage.getImageData()));
        }
        catch (IOException ex) {
            Logger.getLogger(GfxConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    public DefineBitsLossless2Tag convertDefineExternalImage(DefineExternalImage defineExternalImage) {
        DefineBitsLossless2Tag ret = new DefineBitsLossless2Tag(defineExternalImage.getSwf());
        ret.characterID = defineExternalImage.characterID;
        ret.bitmapWidth = defineExternalImage.getImageDimension().width;
        ret.bitmapHeight = defineExternalImage.getImageDimension().height;
        ret.bitmapFormat = 5;
        try {
            ret.setImage(Helper.readStream(defineExternalImage.getImageData()));
        }
        catch (IOException ex) {
            Logger.getLogger(GfxConvertor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    public DefineSoundTag convertDefineExternalSound(DefineExternalSound defineExternalSound) {
        DefineSoundTag ret = new DefineSoundTag(defineExternalSound.getSwf());
        ret.soundId = defineExternalSound.characterId;
        ret.soundFormat = defineExternalSound.getSoundFormatId();
        ret.soundRate = defineExternalSound.getSoundRate();
        ret.soundSampleCount = defineExternalSound.getTotalSoundSampleCount();
        ret.soundSize = defineExternalSound.getSoundSize();
        ret.soundType = defineExternalSound.getSoundType();
        ret.soundData = new ByteArrayRange(defineExternalSound.getRawSoundData().get(0).getRangeData());
        return ret;
    }

    public List<Tag> convertDefineExternalStreamSound(DefineExternalStreamSound defineExternalStreamSound) {
        ArrayList<Tag> ret = new ArrayList<Tag>();
        return ret;
    }

    public DefineSpriteTag convertDefineSprite(DefineSpriteTag defineSprite) {
        DefineSpriteTag ret = new DefineSpriteTag(defineSprite.getSwf());
        ret.frameCount = defineSprite.frameCount;
        ret.hasEndTag = defineSprite.hasEndTag;
        ret.spriteId = defineSprite.spriteId;
        this.converTags(defineSprite, ret);
        return ret;
    }

    public List<Tag> converTags(Timelined source, Timelined target) {
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Tag t : source.getTags()) {
            List<Tag> convertedTags = this.convertTag(t);
            for (Tag ct : convertedTags) {
                target.addTag(ct);
            }
        }
        return ret;
    }

    public List<Tag> convertTag(Tag tag) {
        ArrayList<Tag> ret = new ArrayList<Tag>();
        if (tag instanceof DefineCompactedFont) {
            ret.add(this.convertDefineCompactedFont((DefineCompactedFont)tag));
            return ret;
        }
        if (tag instanceof DefineExternalGradient) {
            return ret;
        }
        if (tag instanceof DefineExternalImage) {
            ret.add(this.convertDefineExternalImage((DefineExternalImage)tag));
            return ret;
        }
        if (tag instanceof DefineExternalImage2) {
            return ret;
        }
        if (tag instanceof DefineExternalSound) {
            ret.add(this.convertDefineExternalSound((DefineExternalSound)tag));
            return ret;
        }
        if (tag instanceof DefineExternalStreamSound) {
            return this.convertDefineExternalStreamSound((DefineExternalStreamSound)tag);
        }
        if (tag instanceof DefineGradientMap) {
            return ret;
        }
        if (tag instanceof DefineSubImage) {
            ret.add(this.convertDefineSubImage((DefineSubImage)tag));
            return ret;
        }
        if (tag instanceof ExporterInfo) {
            return ret;
        }
        if (tag instanceof FontTextureInfo) {
            return ret;
        }
        if (tag instanceof ImportAssetsTag) {
            return ret;
        }
        if (tag instanceof ImportAssets2Tag) {
            return ret;
        }
        if (tag instanceof DefineSpriteTag) {
            ret.add(this.convertDefineSprite((DefineSpriteTag)tag));
            return ret;
        }
        ret.add(tag);
        return ret;
    }

    public SWF convertSwf(SWF gfxSwf) {
        if (!gfxSwf.gfx) {
            return gfxSwf;
        }
        SWF ret = new SWF();
        ret.displayRect = gfxSwf.displayRect;
        ret.frameRate = gfxSwf.frameRate;
        ret.compression = gfxSwf.compression;
        ret.frameCount = gfxSwf.frameCount;
        ret.gfx = false;
        ret.hasEndTag = gfxSwf.hasEndTag;
        this.converTags(gfxSwf, ret);
        return ret;
    }
}

