/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.flexsdk;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.AS3ScriptExporter;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.exporters.swf.SwfToSwcExporter;
import com.jpexs.decompiler.flash.flexsdk.MxmlcException;
import com.jpexs.decompiler.flash.flexsdk.MxmlcRunner;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceExceptionItem;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MxmlcAs3ScriptReplacer
extends MxmlcRunner
implements As3ScriptReplacerInterface {
    private ScriptPack initedPack;
    private File tempDir;
    private File pkgDir;
    private File swcFile;

    public MxmlcAs3ScriptReplacer(String flexSdkPath) {
        super(flexSdkPath);
    }

    private synchronized boolean isInited(ScriptPack pack) {
        return this.tempDir != null && this.initedPack == pack;
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    MxmlcAs3ScriptReplacer.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    private SWF recompileSWF(SWF swf) throws IOException, InterruptedException {
        ByteArrayOutputStream swfOrigBaos = new ByteArrayOutputStream();
        swf.saveTo(swfOrigBaos);
        return new SWF((InputStream)new ByteArrayInputStream(swfOrigBaos.toByteArray()), (boolean)Configuration.parallelSpeedUp.get(), false);
    }

    private boolean isParentDeleted(ABC abc, List<ABC> allAbcs, DottedChain className) {
        int class_index = abc.findClassByName(className);
        if (class_index == -1) {
            for (ABC a : allAbcs) {
                class_index = abc.findClassByName(className);
                if (class_index == -1) continue;
                abc = a;
                break;
            }
            if (class_index == -1) {
                return false;
            }
        }
        InstanceInfo ii = abc.instance_info.get(class_index);
        if (ii.deleted) {
            return true;
        }
        if (ii.super_index != 0 && this.isParentDeleted(abc, allAbcs, abc.constants.getMultiname(ii.super_index).getNameWithNamespace(abc.constants, false))) {
            return true;
        }
        for (int iface : ii.interfaces) {
            if (!this.isParentDeleted(abc, allAbcs, abc.constants.getMultiname(iface).getNameWithNamespace(abc.constants, false))) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void replaceScript(ScriptPack pack, String text) throws As3ScriptReplaceException, IOException, InterruptedException {
        if (!pack.isSimple) {
            throw new IOException("Cannot compile such file");
        }
        if (!this.isInited(pack)) {
            this.initReplacement(pack);
        }
        File scriptFileToCompile = new File(this.pkgDir, pack.getClassPath().className + ".as");
        Helper.writeFile(scriptFileToCompile.getAbsolutePath(), new byte[][]{text.getBytes("UTF-8")});
        File compiledSwfFile = new File(this.pkgDir, "out.swf");
        try {
            this.mxmlc("-strict=false", "-include-inheritance-dependencies-only", "-warnings=false", "-library-path", this.swcFile.getAbsolutePath(), "-source-path", this.tempDir.getAbsolutePath(), "-output", compiledSwfFile.getAbsolutePath(), "-debug=true", scriptFileToCompile.getAbsolutePath());
        }
        catch (MxmlcException ex1) {
            Pattern errPattern = Pattern.compile("^" + Pattern.quote(this.tempDir.getAbsolutePath()) + "(?<file>.*)\\((?<line>[0-9]+)\\): col: (?<col>[0-9]+) (?<message>.*)$");
            String err = ex1.getMxmlcErrorOutput();
            String[] errLines = err.split("\r?\n");
            ArrayList<As3ScriptReplaceExceptionItem> errorItems = new ArrayList<As3ScriptReplaceExceptionItem>();
            for (int i = 0; i < errLines.length; ++i) {
                String line = errLines[i].trim();
                Matcher m = errPattern.matcher(line);
                if (!m.matches()) continue;
                String errFile = m.group("file");
                int errLine = Integer.parseInt(m.group("line"));
                int errCol = Integer.parseInt(m.group("col"));
                String errMsg = m.group("message");
                errorItems.add(new As3ScriptReplaceExceptionItem(errFile, errMsg, errLine, errCol));
            }
            throw new As3ScriptReplaceException(errorItems);
        }
        try (FileInputStream fis = new FileInputStream(compiledSwfFile);){
            int i;
            SWF newSWF = new SWF((InputStream)fis, false, false);
            List<ABCContainerTag> newTags = newSWF.getAbcList();
            int oldScriptIndex = pack.scriptIndex;
            int oldClassIndex = -1;
            ScriptInfo oldScriptInfo = pack.abc.script_info.get(pack.scriptIndex);
            for (Trait t : oldScriptInfo.traits.traits) {
                if (!(t instanceof TraitClass)) continue;
                int traitClassIndex = ((TraitClass)t).class_info;
                if (oldClassIndex != -1 && traitClassIndex >= oldClassIndex) continue;
                oldClassIndex = traitClassIndex;
            }
            if (pack.isSimple) {
                oldScriptInfo.delete(pack.abc, true);
            }
            pack.abc.pack();
            ABCContainerTag newTagsLast = newTags.get(newTags.size() - 1);
            ABC newLastAbc = newTagsLast.getABC();
            HashMap<Integer, Integer> classesMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> scriptsMap = new HashMap<Integer, Integer>();
            pack.abc.mergeABC(newLastAbc, new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>(), classesMap, new HashMap<Integer, Integer>(), scriptsMap);
            ArrayList addedScriptIndices = new ArrayList(scriptsMap.values());
            Collections.sort(addedScriptIndices);
            ArrayList<ScriptInfo> addedScripts = new ArrayList<ScriptInfo>();
            for (i = addedScriptIndices.size() - 1; i >= 0; --i) {
                int newScriptIndex = (Integer)addedScriptIndices.get(i);
                addedScripts.add(0, pack.abc.script_info.remove(newScriptIndex));
            }
            for (i = 0; i < addedScripts.size(); ++i) {
                pack.abc.script_info.add(oldScriptIndex + i, (ScriptInfo)addedScripts.get(i));
            }
            if (oldClassIndex > -1) {
                ArrayList addedClassIndices = new ArrayList(classesMap.values());
                Collections.sort(addedClassIndices);
                int totalClassCount = pack.abc.class_info.size();
                HashMap<Integer, Integer> classesRemap = new HashMap<Integer, Integer>();
                for (int i2 = 0; i2 < addedClassIndices.size(); ++i2) {
                    classesRemap.put((Integer)addedClassIndices.get(i2), oldClassIndex + i2);
                }
                int mappingStart = oldClassIndex;
                block16: for (int i3 = oldClassIndex; i3 < totalClassCount; ++i3) {
                    if (classesRemap.containsKey(i3)) continue;
                    for (int j = mappingStart; j < totalClassCount; ++j) {
                        if (classesRemap.containsValue(j)) continue;
                        classesRemap.put(i3, j);
                        mappingStart = j + 1;
                        continue block16;
                    }
                }
                pack.abc.reorganizeClasses(classesRemap);
            }
            ((Tag)((Object)pack.abc.parentTag)).setModified(true);
            this.deinitReplacement(pack);
        }
    }

    @Override
    public boolean isAvailable() {
        String flexLocation = Configuration.flexSdkLocation.get();
        return !flexLocation.isEmpty() && new File(MxmlcRunner.getMxmlcPath(flexLocation)).exists();
    }

    @Override
    public synchronized void initReplacement(ScriptPack pack) {
        if (this.tempDir != null) {
            this.deinitReplacement(pack);
        }
        try {
            this.pkgDir = this.tempDir = Files.createTempDirectory("ffdec-mxmlc-replace", new FileAttribute[0]).toFile();
            for (String pkgPart : pack.getClassPath().packageStr.toList()) {
                if (pkgPart.isEmpty()) continue;
                this.pkgDir = new File(this.pkgDir, pkgPart);
            }
            this.pkgDir.mkdirs();
            this.swcFile = new File(this.pkgDir, "out.swc");
            Openable openable = pack.getOpenable();
            SWF swf = openable instanceof SWF ? (SWF)openable : ((ABC)openable).getSwf();
            SWF swfCopy = this.recompileSWF(swf);
            ArrayList<ABC> modAbcs = new ArrayList<ABC>();
            List<ScriptPack> copyPacks = swfCopy.getAS3Packs();
            for (ScriptPack scriptPack : copyPacks) {
                if (!scriptPack.getClassPath().equals(pack.getClassPath())) continue;
                scriptPack.abc.script_info.get(scriptPack.scriptIndex).delete(scriptPack.abc, true);
                ((Tag)((Object)scriptPack.abc.parentTag)).setModified(true);
                modAbcs.add(scriptPack.abc);
                break;
            }
            ArrayList<ScriptPack> removedPacks = new ArrayList<ScriptPack>();
            for (ScriptPack scriptPack : copyPacks) {
                DottedChain dc = scriptPack.getPathPackage().add(scriptPack.getPathScriptName(), "");
                if (!this.isParentDeleted(scriptPack.abc, scriptPack.allABCs, dc)) continue;
                scriptPack.abc.script_info.get(scriptPack.scriptIndex).delete(scriptPack.abc, true);
                modAbcs.add(scriptPack.abc);
                removedPacks.add(scriptPack);
            }
            AS3ScriptExporter aS3ScriptExporter = new AS3ScriptExporter();
            aS3ScriptExporter.exportActionScript3(swfCopy, null, this.tempDir.getAbsolutePath(), removedPacks, new ScriptExportSettings(ScriptExportMode.AS_METHOD_STUBS, false, false), false, null);
            for (ABC a : modAbcs) {
                a.pack();
            }
            SwfToSwcExporter swfToSwcExporter = new SwfToSwcExporter();
            swfToSwcExporter.exportSwf(swfCopy, this.swcFile, true);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initedPack = pack;
    }

    @Override
    public synchronized void deinitReplacement(ScriptPack pack) {
        if (this.tempDir != null && this.tempDir.exists()) {
            MxmlcAs3ScriptReplacer.deleteFolder(this.tempDir);
        }
        this.tempDir = null;
    }
}

