/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.swf;

import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.helpers.InternalClass;
import com.jpexs.decompiler.flash.helpers.LazyObject;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Multiline;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import com.jpexs.helpers.XmlPrettyFormat;
import com.jpexs.helpers.utf8.Utf8OutputStreamWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SwfXmlExporter {
    private static final Logger logger = Logger.getLogger(SwfXmlExporter.class.getName());
    private final Map<Class, List<Field>> cachedFields = new HashMap<Class, List<Field>>();

    public List<File> exportXml(SWF swf, File outFile) throws IOException {
        try {
            File tmp = File.createTempFile("FFDEC", "XML");
            try (Utf8OutputStreamWriter writer = new Utf8OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(tmp)));){
                XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
                xmlWriter.writeStartDocument();
                xmlWriter.writeComment("WARNING: The structure of this XML is not final. In later versions of FFDec it can be changed.");
                xmlWriter.writeComment(ApplicationInfo.applicationVerName);
                this.exportXml(swf, xmlWriter);
                xmlWriter.writeEndDocument();
                xmlWriter.flush();
                xmlWriter.close();
            }
            if (!new XmlPrettyFormat().prettyFormat(tmp, outFile, 2, true)) {
                logger.log(Level.SEVERE, "Cannot prettyformat SVG");
            }
            tmp.delete();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(outFile);
        return ret;
    }

    public void exportXml(SWF swf, XMLStreamWriter writer) throws IOException, XMLStreamException {
        this.generateXml(writer, "swf", swf, false, false);
    }

    public List<Field> getSwfFieldsCached(Class cls) {
        List<Field> result = this.cachedFields.get(cls);
        if (result == null) {
            result = ReflectionTools.getSwfFields(cls);
            result.removeIf(f -> Modifier.isStatic(f.getModifiers()) || f.getAnnotation(Internal.class) != null);
            result.sort((o1, o2) -> {
                boolean a2;
                boolean a1 = this.canBeAttribute(o1.getType());
                if (a1 == (a2 = this.canBeAttribute(o2.getType())) && a1) {
                    return o1.getName().compareTo(o2.getName());
                }
                return a1 ? -1 : (a2 ? 1 : 0);
            });
            this.cachedFields.put(cls, result);
        }
        return result;
    }

    private boolean isPrimitive(Class cls) {
        return cls != null && !cls.equals(Void.class) && (cls.isPrimitive() || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == Boolean.class || cls == Character.class || cls == String.class);
    }

    private boolean canBeAttribute(Class cls) {
        return cls != null && (this.isPrimitive(cls) || cls.equals(byte[].class) || ByteArrayRange.class.isAssignableFrom(cls) || cls.isEnum());
    }

    private boolean isList(Class cls) {
        return cls != null && (cls.isArray() || List.class.isAssignableFrom(cls));
    }

    private void generateXml(XMLStreamWriter writer, String name, Object obj, boolean isListItem, boolean needsCData) throws XMLStreamException {
        Class<?> cls;
        Class<?> clazz = cls = obj != null ? obj.getClass() : null;
        if (obj != null && needsCData && cls == String.class) {
            writer.writeStartElement(name);
            writer.writeAttribute("type", "String");
            writer.writeCData((String)obj);
            writer.writeEndElement();
        } else if (obj != null && this.isPrimitive(cls)) {
            Object[] value = obj;
            if (value instanceof String) {
                value = Helper.removeInvalidXMLCharacters((String)value);
            }
            if (isListItem) {
                writer.writeStartElement(name);
                writer.writeCharacters(value.toString());
                writer.writeEndElement();
            } else {
                writer.writeAttribute(name, value.toString());
            }
        } else if (cls != null && obj != null && cls.isEnum()) {
            writer.writeAttribute(name, obj.toString());
        } else if (obj instanceof ByteArrayRange) {
            ByteArrayRange range = (ByteArrayRange)obj;
            byte[] data = range.getRangeData();
            writer.writeAttribute(name, Helper.byteArrayToHex(data));
        } else if (obj instanceof byte[]) {
            byte[] data = (byte[])obj;
            writer.writeAttribute(name, Helper.byteArrayToHex(data));
        } else if (this.isList(cls)) {
            Object[] value = obj;
            if (List.class.isAssignableFrom(cls)) {
                value = ((List)value).toArray();
            }
            writer.writeStartElement(name);
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                this.generateXml(writer, "item", Array.get(value, i), true, false);
            }
            writer.writeEndElement();
        } else if (obj != null) {
            if (obj instanceof LazyObject) {
                ((LazyObject)obj).load();
            }
            Class<?> clazz2 = obj.getClass();
            List<Field> fields = this.getSwfFieldsCached(clazz2);
            if (obj instanceof InternalClass) {
                clazz2 = clazz2.getSuperclass();
            }
            writer.writeStartElement(name);
            writer.writeAttribute("type", clazz2.getSimpleName());
            if (obj instanceof UnknownTag) {
                writer.writeAttribute("tagId", String.valueOf(((Tag)obj).getId()));
            }
            if (obj instanceof SWF) {
                writer.writeAttribute("charset", ((SWF)obj).getCharset());
            }
            for (Field f : fields) {
                Multiline multilineA = f.getAnnotation(Multiline.class);
                try {
                    f.setAccessible(true);
                    this.generateXml(writer, f.getName(), f.get(obj), false, multilineA != null);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            writer.writeEndElement();
        } else if (isListItem) {
            writer.writeStartElement(name);
            writer.writeAttribute("isNull", Boolean.TRUE.toString());
            writer.writeEndElement();
        }
    }
}

