/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExporterBase;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import java.awt.BasicStroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class PathExporter
extends ShapeExporterBase {
    private final List<GeneralPath> paths = new ArrayList<GeneralPath>();
    private final List<GeneralPath> strokes = new ArrayList<GeneralPath>();
    private double thickness = 0.0;
    private boolean aliasedFill = false;
    private GeneralPath path = new GeneralPath(0);

    public static List<GeneralPath> export(int shapeNum, SWF swf, SHAPE shape) {
        return PathExporter.export(shapeNum, swf, shape, new ArrayList<GeneralPath>());
    }

    public static List<GeneralPath> export(int shapeNum, SWF swf, SHAPE shape, List<GeneralPath> strokes) {
        PathExporter exporter = new PathExporter(shapeNum, swf, shape, null);
        exporter.export();
        strokes.addAll(exporter.strokes);
        return exporter.paths;
    }

    protected PathExporter(int shapeNum, SWF swf, SHAPE shape, ColorTransform colorTransform) {
        super(shapeNum, swf, shape, colorTransform);
    }

    @Override
    public void export() {
        super.export();
    }

    @Override
    public void beginShape() {
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
        this.aliasedFill = false;
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines(boolean close) {
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color) {
        this.finalizePath();
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.finalizePath();
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        this.finalizePath();
    }

    @Override
    public void endFill() {
        this.finalizePath();
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
        this.thickness = thickness;
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
    }

    @Override
    public void lineBitmapStyle(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
    }

    @Override
    public void moveTo(double x, double y) {
        this.path.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        this.path.lineTo(x, y);
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
        this.path.quadTo(controlX, controlY, anchorX, anchorY);
    }

    protected void finalizePath() {
        if (this.thickness == 0.0) {
            this.strokes.add(new GeneralPath());
        } else {
            this.strokes.add(new GeneralPath(new BasicStroke((float)this.thickness).createStrokedShape(this.path)));
        }
        this.paths.add(this.path);
        this.path = new GeneralPath(0);
    }

    @Override
    public void beginAliasedFills() {
        this.aliasedFill = true;
    }
}

