/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.ImageTagBufferedImage;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.exporters.shape.MiterClipBasicStroke;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExporterBase;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.helpers.SerializableImage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BitmapExporter
extends ShapeExporterBase {
    private static final java.awt.Point POINT_NEG16384_0 = new java.awt.Point(-16384, 0);
    private static final java.awt.Point POINT_16384_0 = new java.awt.Point(16384, 0);
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private SerializableImage image;
    private Graphics2D graphics;
    private final Color defaultColor;
    private final SWF swf;
    private final GeneralPath path = new GeneralPath(0);
    private Shape aliasedShape;
    private Paint fillPaint;
    private boolean fillRepeat;
    private boolean fillSmooth;
    private AffineTransform fillTransform;
    private Paint linePaint;
    private AffineTransform lineTransform;
    private Color lineColor;
    private Stroke lineStroke;
    private Stroke defaultStroke;
    private Matrix strokeTransformation;
    private double thicknessScale;
    private double thicknessScaleX;
    private double thicknessScaleY;
    private double unzoom;
    private static boolean linearGradientColorWarnignShown = false;
    private boolean scaleStrokes;
    private boolean aliasedFill = false;

    @Override
    public void beginAliasedFills() {
        this.aliasedFill = true;
    }

    public static void export(int shapeNum, SWF swf, SHAPE shape, Color defaultColor, SerializableImage image, double unzoom, Matrix transformation, Matrix strokeTransformation, ColorTransform colorTransform, boolean scaleStrokes, boolean canUseSmoothing) {
        BitmapExporter exporter = new BitmapExporter(shapeNum, swf, shape, defaultColor, colorTransform);
        exporter.setCanUseSmoothing(canUseSmoothing);
        exporter.exportTo(shapeNum, image, unzoom, transformation, strokeTransformation, scaleStrokes);
    }

    private BitmapExporter(int shapeNum, SWF swf, SHAPE shape, Color defaultColor, ColorTransform colorTransform) {
        super(shapeNum, swf, shape, colorTransform);
        this.swf = swf;
        this.defaultColor = defaultColor;
    }

    private void exportTo(int shapeNum, SerializableImage image, double unzoom, Matrix transformation, Matrix strokeTransformation, boolean scaleStrokes) {
        this.image = image;
        this.scaleStrokes = scaleStrokes;
        ExportRectangle bounds = new ExportRectangle(this.shape.getBounds(shapeNum));
        this.strokeTransformation = strokeTransformation;
        this.calculateThicknessScale(bounds, transformation);
        this.graphics = (Graphics2D)image.getGraphics();
        AffineTransform at = transformation.toTransform();
        at.preConcatenate(AffineTransform.getScaleInstance(0.05, 0.05));
        this.graphics.setTransform(at);
        this.defaultStroke = this.graphics.getStroke();
        this.unzoom = unzoom;
        super.export();
    }

    private void calculateThicknessScale(ExportRectangle bounds, Matrix transformation) {
        Point p00 = this.strokeTransformation.transform(0.0, 0.0);
        Point p11 = this.strokeTransformation.transform(1.0, 1.0);
        this.thicknessScale = p00.distanceTo(p11) / Math.sqrt(2.0);
        this.thicknessScaleX = Math.abs(p11.x - p00.x);
        this.thicknessScaleY = Math.abs(p11.y - p00.y);
    }

    public SerializableImage getImage() {
        return this.image;
    }

    @Override
    public void beginShape() {
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
        this.aliasedFill = false;
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines(boolean close) {
        if (close) {
            this.path.closePath();
        }
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color) {
        this.finalizePath();
        this.fillPaint = color == null ? this.defaultColor : color.toColor();
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.finalizePath();
        MultipleGradientPaint.ColorSpaceType cstype = MultipleGradientPaint.ColorSpaceType.SRGB;
        if (interpolationMethod == 1) {
            cstype = MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        }
        switch (type) {
            case 16: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                if (colorsArr.length >= 2) {
                    this.fillPaint = new LinearGradientPaint(POINT_NEG16384_0, POINT_16384_0, ratiosArr, colorsArr, cm, cstype, IDENTITY_TRANSFORM);
                } else {
                    if (!linearGradientColorWarnignShown) {
                        Logger.getLogger(BitmapExporter.class.getName()).log(Level.WARNING, "Linear gradient fill should have at least 2 gradient records.");
                        linearGradientColorWarnignShown = true;
                    }
                    this.fillPaint = colorsArr.length == 1 ? colorsArr[0] : null;
                }
                this.fillTransform = matrix.toTransform();
                break;
            }
            case 18: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.fillPaint = new RadialGradientPaint(new java.awt.Point(0, 0), 16384.0f, new java.awt.Point(0, 0), ratiosArr, colorsArr, cm, cstype, new AffineTransform());
                this.fillTransform = matrix.toTransform();
                break;
            }
            case 19: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.fillPaint = new RadialGradientPaint(new java.awt.Point(0, 0), 16384.0f, new java.awt.Point((int)(focalPointRatio * 16384.0f), 0), ratiosArr, colorsArr, cm, cstype, AffineTransform.getTranslateInstance(0.0, 0.0));
                this.fillTransform = matrix.toTransform();
            }
        }
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        SerializableImage img;
        this.finalizePath();
        ImageTag imageTag = this.swf.getImage(bitmapId);
        if (imageTag != null && (img = imageTag.getImageCached()) != null) {
            if (colorTransform != null) {
                img = colorTransform.apply(img);
            }
            BufferedImage bufImg = img.getBufferedImage();
            if (colorTransform == null) {
                bufImg = new ImageTagBufferedImage(imageTag, bufImg);
            }
            this.fillPaint = new TexturePaint(bufImg, new Rectangle(img.getWidth(), img.getHeight()));
            this.fillTransform = matrix.toTransform();
            this.fillRepeat = repeat;
            this.fillSmooth = smooth;
            return;
        }
        this.fillPaint = SWF.ERROR_COLOR;
        this.fillTransform = matrix.toTransform();
    }

    @Override
    public void endFill() {
        this.finalizePath();
        this.fillPaint = null;
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
        this.linePaint = null;
        this.lineTransform = null;
        this.lineColor = color == null ? null : color.toColor();
        int capStyle = 1;
        switch (startCaps) {
            case 1: {
                capStyle = 0;
                break;
            }
            case 0: {
                capStyle = 1;
                break;
            }
            case 2: {
                capStyle = 2;
            }
        }
        int joinStyle = 1;
        switch (joints) {
            case 1: {
                joinStyle = 2;
                break;
            }
            case 2: {
                joinStyle = 0;
                break;
            }
            case 0: {
                joinStyle = 1;
            }
        }
        if (this.scaleStrokes) {
            switch (scaleMode) {
                case "VERTICAL": {
                    thickness *= this.thicknessScaleY;
                    break;
                }
                case "HORIZONTAL": {
                    thickness *= this.thicknessScaleX;
                    break;
                }
                case "NORMAL": {
                    thickness *= this.thicknessScale;
                    break;
                }
            }
        }
        if (thickness * this.unzoom < 20.0) {
            thickness = 20.0 / this.unzoom;
        }
        if (joinStyle == 0) {
            this.lineStroke = new BasicStroke((float)thickness, capStyle, joinStyle, miterLimit);
            if (Configuration.allowMiterClipLinestyle.get().booleanValue()) {
                this.lineStroke = new MiterClipBasicStroke((BasicStroke)this.lineStroke);
            }
        } else {
            this.lineStroke = new BasicStroke((float)thickness, capStyle, joinStyle);
        }
        try {
            AffineTransform t = (AffineTransform)this.strokeTransformation.toTransform().clone();
            this.lineStroke = new TransformedStroke(this.lineStroke, t);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        MultipleGradientPaint.ColorSpaceType cstype = MultipleGradientPaint.ColorSpaceType.SRGB;
        if (interpolationMethod == 1) {
            cstype = MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        }
        switch (type) {
            case 16: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.linePaint = new LinearGradientPaint(POINT_NEG16384_0, POINT_16384_0, ratiosArr, colorsArr, cm, cstype, IDENTITY_TRANSFORM);
                this.lineTransform = matrix.toTransform();
                break;
            }
            case 18: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                switch (spreadMethod) {
                    case 0: {
                        cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                        break;
                    }
                    case 1: {
                        cm = MultipleGradientPaint.CycleMethod.REFLECT;
                        break;
                    }
                    case 2: {
                        cm = MultipleGradientPaint.CycleMethod.REPEAT;
                    }
                }
                this.linePaint = new RadialGradientPaint(new java.awt.Point(0, 0), 16384.0f, ratiosArr, colorsArr, cm);
                this.lineTransform = matrix.toTransform();
                break;
            }
            case 19: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.linePaint = new RadialGradientPaint(new java.awt.Point(0, 0), 16384.0f, new java.awt.Point((int)(focalPointRatio * 16384.0f), 0), ratiosArr, colorsArr, cm, cstype, AffineTransform.getTranslateInstance(0.0, 0.0));
                this.lineTransform = matrix.toTransform();
            }
        }
    }

    @Override
    public void lineBitmapStyle(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        SerializableImage img;
        ImageTag imageTag = this.swf.getImage(bitmapId);
        if (imageTag != null && (img = imageTag.getImageCached()) != null) {
            if (colorTransform != null) {
                img = colorTransform.apply(img);
            }
            this.linePaint = new TexturePaint(img.getBufferedImage(), new Rectangle(img.getWidth(), img.getHeight()));
            this.lineTransform = matrix.toTransform();
            return;
        }
        this.linePaint = SWF.ERROR_COLOR;
        this.lineTransform = matrix.toTransform();
    }

    @Override
    public void moveTo(double x, double y) {
        this.path.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        this.path.lineTo(x, y);
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
        this.path.quadTo(controlX, controlY, anchorX, anchorY);
    }

    protected void finalizePath() {
        double minY;
        double minX;
        double det;
        double shy;
        double shx;
        double scy;
        double scx2;
        Matrix inverse;
        Shape prevClip;
        AffineTransform oldAf;
        if (this.fillPaint != null) {
            Shape shp = this.path;
            if (this.aliasedFill) {
                this.aliasedShape = new BasicStroke((float)(20.0 / this.unzoom / 2.0), 1, 1).createStrokedShape(shp);
                return;
            }
            if (this.aliasedShape != null) {
                Area a = new Area(shp);
                a.add(new Area(this.aliasedShape));
                shp = a;
            }
            this.graphics.setComposite(AlphaComposite.SrcOver);
            if (this.fillPaint instanceof MultipleGradientPaint) {
                oldAf = this.graphics.getTransform();
                prevClip = this.graphics.getClip();
                this.graphics.clip(shp);
                inverse = null;
                try {
                    scx2 = this.fillTransform.getScaleX();
                    scy = this.fillTransform.getScaleY();
                    shx = this.fillTransform.getShearX();
                    shy = this.fillTransform.getShearY();
                    det = scx2 * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.fillTransform.setToTranslation(this.fillTransform.getTranslateX(), this.fillTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.fillTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx2) {
                    // empty catch block
                }
                this.fillTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.fillTransform);
                this.graphics.setPaint(this.fillPaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(shp.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(prevClip);
            } else if (this.fillPaint instanceof TexturePaint) {
                ExportRectangle rect;
                oldAf = this.graphics.getTransform();
                prevClip = this.graphics.getClip();
                this.graphics.clip(shp);
                inverse = null;
                try {
                    double scx3 = this.fillTransform.getScaleX();
                    scy = this.fillTransform.getScaleY();
                    shx = this.fillTransform.getShearX();
                    shy = this.fillTransform.getShearY();
                    det = scx3 * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.fillTransform.setToTranslation(this.fillTransform.getTranslateX(), this.fillTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.fillTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx3) {
                    // empty catch block
                }
                this.fillTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.fillTransform);
                this.graphics.setPaint(this.fillPaint);
                Object interpolationBefore = this.graphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                if (this.fillSmooth) {
                    this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                } else {
                    this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                }
                if (this.fillRepeat) {
                    if (inverse != null) {
                        rect = inverse.transform(new ExportRectangle(shp.getBounds2D()));
                        double minX2 = rect.xMin;
                        double minY2 = rect.yMin;
                        this.graphics.fill(new Rectangle((int)minX2, (int)minY2, (int)(rect.xMax - minX2), (int)(rect.yMax - minY2)));
                    }
                } else if (inverse != null) {
                    rect = inverse.transform(new ExportRectangle(shp.getBounds2D()));
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), (int)rect.xMin, 0, 0, ((TexturePaint)this.fillPaint).getImage().getHeight(), 0, 0, 1, ((TexturePaint)this.fillPaint).getImage().getHeight(), null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), (int)rect.xMin, (int)rect.yMin, 0, 0, 0, 0, 1, 1, null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), 0, (int)rect.yMin, ((TexturePaint)this.fillPaint).getImage().getWidth(), 0, 0, 0, ((TexturePaint)this.fillPaint).getImage().getWidth(), 1, null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), ((TexturePaint)this.fillPaint).getImage().getWidth(), (int)rect.yMin, (int)rect.xMax, 0, ((TexturePaint)this.fillPaint).getImage().getWidth() - 1, 0, ((TexturePaint)this.fillPaint).getImage().getWidth(), 1, null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), ((TexturePaint)this.fillPaint).getImage().getWidth(), 0, (int)rect.xMax, ((TexturePaint)this.fillPaint).getImage().getHeight(), ((TexturePaint)this.fillPaint).getImage().getWidth() - 1, 0, ((TexturePaint)this.fillPaint).getImage().getWidth(), ((TexturePaint)this.fillPaint).getImage().getHeight(), null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), ((TexturePaint)this.fillPaint).getImage().getWidth(), ((TexturePaint)this.fillPaint).getImage().getHeight(), (int)rect.xMax, (int)rect.yMax, ((TexturePaint)this.fillPaint).getImage().getWidth() - 1, ((TexturePaint)this.fillPaint).getImage().getHeight() - 1, ((TexturePaint)this.fillPaint).getImage().getWidth(), ((TexturePaint)this.fillPaint).getImage().getHeight(), null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), 0, ((TexturePaint)this.fillPaint).getImage().getHeight(), ((TexturePaint)this.fillPaint).getImage().getWidth(), (int)rect.yMax, 0, ((TexturePaint)this.fillPaint).getImage().getHeight() - 1, ((TexturePaint)this.fillPaint).getImage().getWidth(), ((TexturePaint)this.fillPaint).getImage().getHeight(), null);
                    this.graphics.drawImage(((TexturePaint)this.fillPaint).getImage(), (int)rect.xMin, ((TexturePaint)this.fillPaint).getImage().getHeight(), 0, (int)rect.yMax, 0, ((TexturePaint)this.fillPaint).getImage().getHeight() - 1, 1, ((TexturePaint)this.fillPaint).getImage().getHeight(), null);
                    this.graphics.drawImage((Image)((TexturePaint)this.fillPaint).getImage(), 0, 0, null);
                }
                this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationBefore);
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(prevClip);
            } else {
                this.graphics.setPaint(this.fillPaint);
                this.graphics.fill(shp);
            }
        }
        if (this.linePaint != null && this.lineStroke != null) {
            Shape strokedShape = this.lineStroke.createStrokedShape(this.path);
            this.graphics.setComposite(AlphaComposite.SrcOver);
            if (this.linePaint instanceof MultipleGradientPaint) {
                oldAf = this.graphics.getTransform();
                prevClip = this.graphics.getClip();
                this.graphics.clip(strokedShape);
                inverse = null;
                try {
                    scx2 = this.lineTransform.getScaleX();
                    scy = this.lineTransform.getScaleY();
                    shx = this.lineTransform.getShearX();
                    shy = this.lineTransform.getShearY();
                    det = scx2 * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.lineTransform.setToTranslation(this.lineTransform.getTranslateX(), this.lineTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.lineTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx4) {
                    // empty catch block
                }
                this.lineTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.lineTransform);
                this.graphics.setPaint(this.linePaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(strokedShape.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(prevClip);
            } else if (this.linePaint instanceof TexturePaint) {
                oldAf = this.graphics.getTransform();
                prevClip = this.graphics.getClip();
                this.graphics.clip(strokedShape);
                inverse = null;
                try {
                    scx2 = this.lineTransform.getScaleX();
                    scy = this.lineTransform.getScaleY();
                    shx = this.lineTransform.getShearX();
                    shy = this.lineTransform.getShearY();
                    det = scx2 * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.lineTransform.setToTranslation(this.lineTransform.getTranslateX(), this.lineTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.lineTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx5) {
                    // empty catch block
                }
                this.lineTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.lineTransform);
                this.graphics.setPaint(this.linePaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(strokedShape.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(prevClip);
            } else {
                this.graphics.setPaint(this.linePaint);
                this.graphics.fill(strokedShape);
            }
        } else if (this.lineColor != null) {
            this.graphics.setColor(this.lineColor);
            this.graphics.setStroke(this.lineStroke == null ? this.defaultStroke : this.lineStroke);
            this.graphics.draw(this.path);
        }
        this.path.reset();
        this.lineStroke = null;
        this.lineColor = null;
        this.fillPaint = null;
    }

    private class TransformedStroke
    implements Stroke {
        private static final long serialVersionUID = 1L;
        private final AffineTransform transform;
        private final AffineTransform inverse;
        private final Stroke stroke;

        public TransformedStroke(Stroke base, AffineTransform at) throws NoninvertibleTransformException {
            this.transform = new AffineTransform(at);
            this.inverse = this.transform.createInverse();
            this.stroke = base;
        }

        @Override
        public Shape createStrokedShape(Shape s) {
            Shape sTrans = this.transform.createTransformedShape(s);
            Shape sTransStroked = this.stroke.createStrokedShape(sTrans);
            Shape sStroked = this.inverse.createTransformedShape(sTransStroked);
            return sStroked;
        }
    }
}

