/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.RunnableIOExResult;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

public class ExportPackTask
implements Callable<File> {
    ScriptPack pack;
    File file;
    ScriptExportSettings exportSettings;
    ClassPath path;
    int index;
    int count;
    boolean parallel;
    AbortRetryIgnoreHandler handler;
    long startTime;
    long stopTime;
    EventListener eventListener;
    AbcIndexing abcIndex;

    public ExportPackTask(AbcIndexing abcIndex, AbortRetryIgnoreHandler handler, int index, int count, ClassPath path, ScriptPack pack, File file, ScriptExportSettings exportSettings, boolean parallel, EventListener evl) {
        this.pack = pack;
        this.file = file;
        this.exportSettings = exportSettings;
        this.path = path;
        this.index = index;
        this.count = count;
        this.parallel = parallel;
        this.handler = handler;
        this.eventListener = evl;
        this.abcIndex = abcIndex;
    }

    @Override
    public File call() throws IOException, InterruptedException {
        RunnableIOExResult<File> rio = new RunnableIOExResult<File>(){

            @Override
            public void run() throws IOException, InterruptedException {
                ExportPackTask.this.startTime = System.currentTimeMillis();
                this.result = ExportPackTask.this.pack.export(ExportPackTask.this.abcIndex, ExportPackTask.this.file, ExportPackTask.this.exportSettings, ExportPackTask.this.parallel);
                ExportPackTask.this.stopTime = System.currentTimeMillis();
            }
        };
        if (this.eventListener != null) {
            this.eventListener.handleExportingEvent("script", this.index, this.count, this.path);
        }
        new RetryTask(rio, this.handler).run();
        if (this.eventListener != null) {
            long time = this.stopTime - this.startTime;
            this.eventListener.handleExportedEvent("script", this.index, this.count, this.path + ", " + Helper.formatTimeSec(time));
        }
        return (File)rio.result;
    }
}

