/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Deobfuscation;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.AlchemyTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetOuterScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.InitVectorAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyType;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.TypeItem;
import java.util.ArrayList;
import java.util.List;

public class DependencyParser {
    public static void parseDependenciesFromNS(AbcIndexing abcIndex, String ignoredCustom, ABC abc, List<Dependency> dependencies, int namespace_index, DottedChain ignorePackage, String name, DependencyType dependencyType) {
        String nsVal;
        DottedChain nsimport;
        Namespace ns = abc.constants.getNamespace(namespace_index);
        if (name.isEmpty()) {
            name = "*";
        }
        DottedChain newimport = ns.getName(abc.constants);
        if ((ns.kind == 8 || ns.kind == 23) && (nsimport = abcIndex.nsValueToName(nsVal = ns.getName(abc.constants).toRawString())) != null) {
            if (nsimport.equals(AVM2Deobfuscation.BUILTIN)) {
                return;
            }
            if (!nsimport.isEmpty()) {
                Dependency depNs = new Dependency(nsimport, DependencyType.NAMESPACE);
                if (!(ignorePackage != null && nsimport.getWithoutLast().equals(ignorePackage) || dependencies.contains(depNs))) {
                    dependencies.add(depNs);
                }
                if (ignoredCustom != null && nsVal.equals(ignoredCustom)) {
                    return;
                }
                return;
            }
        }
        if (ns.kind != 22) {
            return;
        }
        Dependency dep = new Dependency(newimport = newimport.addWithSuffix(name), dependencyType);
        if (!dependencies.contains(dep)) {
            DottedChain pkg = newimport.getWithoutLast();
            if (pkg.equals(InitVectorAVM2Item.VECTOR_PACKAGE)) {
                return;
            }
            if (!pkg.equals(ignorePackage)) {
                dependencies.add(dep);
            }
        }
    }

    public static void parseDependenciesFromMultiname(AbcIndexing abcIndex, String ignoredCustom, ABC abc, List<Dependency> dependencies, Multiname m, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, DependencyType dependencyType) {
        if (m != null) {
            if (m.kind == 29) {
                if (m.qname_index != 0) {
                    DependencyParser.parseDependenciesFromMultiname(abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(m.qname_index), ignorePackage, fullyQualifiedNames, dependencyType);
                }
                int[] nArray = m.params;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (i2 == 0) continue;
                    DependencyParser.parseDependenciesFromMultiname(abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(i2), ignorePackage, fullyQualifiedNames, dependencyType);
                }
                return;
            }
            Namespace ns = m.getNamespace(abc.constants);
            String name = m.getName(abc.constants, fullyQualifiedNames, true, true);
            NamespaceSet nss = m.getNamespaceSet(abc.constants);
            if (ns != null) {
                DependencyParser.parseDependenciesFromNS(abcIndex, ignoredCustom, abc, dependencies, m.namespace_index, ignorePackage, name, dependencyType);
            }
            if (nss != null) {
                for (int n : nss.namespaces) {
                    DependencyParser.parseDependenciesFromNS(abcIndex, ignoredCustom, abc, dependencies, n, ignorePackage, nss.namespaces.length > 1 ? "" : name, dependencyType);
                }
            }
        }
    }

    public static void parseDependenciesFromMethodInfo(AbcIndexing abcIndex, Trait trait, int scriptIndex, int classIndex, boolean isStatic, String ignoredCustom, ABC abc, int method_index, List<Dependency> dependencies, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, List<Integer> visitedMethods) throws InterruptedException {
        if (method_index < 0 || method_index >= abc.method_info.size()) {
            return;
        }
        visitedMethods.add(method_index);
        if (abc.method_info.get((int)method_index).ret_type != 0) {
            DependencyParser.parseDependenciesFromMultiname(abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(abc.method_info.get((int)method_index).ret_type), ignorePackage, fullyQualifiedNames, DependencyType.SIGNATURE);
        }
        for (int t : abc.method_info.get((int)method_index).param_types) {
            if (t == 0) continue;
            DependencyParser.parseDependenciesFromMultiname(abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(t), ignorePackage, fullyQualifiedNames, DependencyType.SIGNATURE);
        }
        MethodBody body = abc.findBody(method_index);
        if (body != null && body.convertException == null) {
            body = body.convertMethodBodyCanUseLast(Configuration.autoDeobfuscate.get(), "", isStatic, scriptIndex, classIndex, abc, trait);
            body.traits.getDependencies(abcIndex, scriptIndex, classIndex, isStatic, ignoredCustom, abc, dependencies, ignorePackage, fullyQualifiedNames);
            for (ABCException ex : body.exceptions) {
                DependencyParser.parseDependenciesFromMultiname(abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(ex.type_index), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION);
            }
            for (AVM2Instruction ins : body.getCode().code) {
                DottedChain nimport;
                Dependency depExp;
                if (ins.definition instanceof AlchemyTypeIns && !dependencies.contains(depExp = new Dependency(nimport = AlchemyTypeIns.ALCHEMY_PACKAGE.addWithSuffix(ins.definition.instructionName), DependencyType.EXPRESSION))) {
                    dependencies.add(depExp);
                }
                if (ins.definition instanceof NewFunctionIns && ins.operands[0] != method_index && !visitedMethods.contains(ins.operands[0])) {
                    DependencyParser.parseDependenciesFromMethodInfo(abcIndex, trait, scriptIndex, classIndex, isStatic, ignoredCustom, abc, ins.operands[0], dependencies, ignorePackage, fullyQualifiedNames, visitedMethods);
                }
                if (classIndex > -1 && ins.definition instanceof GetOuterScopeIns && ins.operands[0] > 0) {
                    DottedChain type = abc.instance_info.get(classIndex).getName(abc.constants).getNameWithNamespace(abc.constants, true);
                    AbcIndexing.ClassIndex cls = abcIndex.findClass(new TypeItem(type), abc, scriptIndex);
                    ArrayList<AbcIndexing.ClassIndex> clsList = new ArrayList<AbcIndexing.ClassIndex>();
                    cls = cls.parent;
                    while (cls != null) {
                        clsList.add(0, cls);
                        cls = cls.parent;
                    }
                    if (ins.operands[0] < 1 + clsList.size()) {
                        AbcIndexing.ClassIndex cls2 = (AbcIndexing.ClassIndex)clsList.get(ins.operands[0] - 1);
                        DottedChain nimport2 = cls2.abc.instance_info.get(cls2.index).getName(cls2.abc.constants).getNameWithNamespace(cls2.abc.constants, true);
                        Dependency depExp2 = new Dependency(nimport2, DependencyType.EXPRESSION);
                        if (!dependencies.contains(depExp2)) {
                            dependencies.add(depExp2);
                        }
                    }
                }
                for (int k = 0; k < ins.definition.operands.length; ++k) {
                    int m;
                    if (ins.definition.operands[k] != 257 || (m = ins.operands[k]) >= abc.constants.getMultinameCount()) continue;
                    DependencyParser.parseDependenciesFromMultiname(abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(m), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION);
                }
            }
        }
    }
}

