/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.morphshape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.morphshape.DefaultSVGMorphShapeExporter;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import org.w3c.dom.Element;

public class SVGMorphShapeExporter
extends DefaultSVGMorphShapeExporter {
    protected Element path;
    protected int id;
    protected int lastPatternId;
    private final Color defaultColor;
    private final SWF swf;
    private final SVGExporter exporter;

    public SVGMorphShapeExporter(int morphShapeNum, SWF swf, SHAPE shape, SHAPE endShape, int id, SVGExporter exporter, Color defaultColor, ColorTransform colorTransform, double zoom) {
        super(morphShapeNum, shape, endShape, colorTransform, zoom);
        this.swf = swf;
        this.id = id;
        this.defaultColor = defaultColor;
        this.exporter = exporter;
    }

    @Override
    public void beginFill(RGB color, RGB colorEnd) {
        if (color == null) {
            color = new RGB(this.defaultColor == null ? Color.black : this.defaultColor);
        }
        if (colorEnd == null) {
            colorEnd = new RGB(this.defaultColor == null ? Color.black : this.defaultColor);
        }
        this.finalizePath();
        this.path.setAttribute("stroke", "none");
        this.path.setAttribute("fill", color.toHexRGB());
        this.path.setAttribute("fill-rule", "evenodd");
        this.path.appendChild(this.createAnimateElement("fill", color.toHexRGB(), colorEnd.toHexRGB()));
        if (color instanceof RGBA) {
            RGBA colorA = (RGBA)color;
            if (colorA.alpha != 255) {
                this.path.setAttribute("fill-opacity", Float.toString(colorA.getAlphaFloat()));
            }
            RGBA colorAEnd = (RGBA)colorEnd;
            this.path.appendChild(this.createAnimateElement("fill-opacity", Float.valueOf(colorA.getAlphaFloat()), Float.valueOf(colorAEnd.getAlphaFloat())));
        }
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio, float focalPointRatioEnd) {
        this.finalizePath();
        Element gradient = type == 16 ? this.exporter.createElement("linearGradient") : this.exporter.createElement("radialGradient");
        this.populateGradientElement(gradient, type, gradientRecords, gradientRecordsEnd, matrix, matrixEnd, spreadMethod, interpolationMethod, focalPointRatio);
        int id = this.exporter.gradients.indexOf(gradient);
        if (id < 0) {
            id = this.exporter.gradients.size();
            this.exporter.gradients.add(gradient);
        }
        gradient.setAttribute("id", "gradient" + id);
        this.path.setAttribute("stroke", "none");
        this.path.setAttribute("fill", "url(#gradient" + id + ")");
        this.path.setAttribute("fill-rule", "evenodd");
        this.exporter.addToDefs(gradient);
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, Matrix matrixEnd, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        SerializableImage img;
        this.finalizePath();
        ImageTag image = this.swf.getImage(bitmapId);
        if (image != null && (img = image.getImageCached()) != null) {
            if (colorTransform != null) {
                colorTransform.apply(img);
            }
            int width = img.getWidth();
            int height = img.getHeight();
            ++this.lastPatternId;
            String patternId = "PatternID_" + this.id + "_" + this.lastPatternId;
            ImageFormat format = image.getImageFormat();
            byte[] imageData = Helper.readStream(image.getConvertedImageData());
            String base64ImgData = Helper.byteArrayToBase64String(imageData);
            this.path.setAttribute("style", "fill:url(#" + patternId + ")");
            Element pattern = this.exporter.createElement("pattern");
            pattern.setAttribute("id", patternId);
            pattern.setAttribute("patternUnits", "userSpaceOnUse");
            pattern.setAttribute("overflow", "visible");
            pattern.setAttribute("width", "" + width);
            pattern.setAttribute("height", "" + height);
            pattern.setAttribute("viewBox", "0 0 " + width + " " + height);
            if (matrix != null) {
                matrix = matrix.clone();
                matrix.rotateSkew0 *= this.zoom / 20.0;
                matrix.rotateSkew1 *= this.zoom / 20.0;
                matrix.scaleX *= this.zoom / 20.0;
                matrix.scaleY *= this.zoom / 20.0;
                matrixEnd = matrixEnd.clone();
                matrixEnd.rotateSkew0 *= this.zoom / 20.0;
                matrixEnd.rotateSkew1 *= this.zoom / 20.0;
                matrixEnd.scaleX *= this.zoom / 20.0;
                matrixEnd.scaleY *= this.zoom / 20.0;
                this.addMatrixAnimation(pattern, "patternTransform", matrix, matrixEnd);
            }
            Element imageElement = this.exporter.createElement("image");
            imageElement.setAttribute("width", "" + width);
            imageElement.setAttribute("height", "" + height);
            imageElement.setAttribute("xlink:href", "data:image/" + (Object)((Object)format) + ";base64," + base64ImgData);
            pattern.appendChild(imageElement);
            this.exporter.addToGroup(pattern);
        }
    }

    @Override
    public void lineStyle(double thickness, double thicknessEnd, RGB color, RGB colorEnd, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
        thickness *= this.zoom / 20.0;
        thicknessEnd *= this.zoom / 20.0;
        this.path.setAttribute("fill", "none");
        if (color != null) {
            this.path.setAttribute("stroke", color.toHexRGB());
            this.path.appendChild(this.createAnimateElement("stroke", color.toHexRGB(), colorEnd.toHexRGB()));
        }
        this.path.setAttribute("stroke-width", Double.toString(thickness == 0.0 ? 1.0 : thickness));
        this.path.appendChild(this.createAnimateElement("stroke-width", thickness, thicknessEnd));
        if (color instanceof RGBA) {
            RGBA colorA = (RGBA)color;
            if (colorA.alpha != 255) {
                this.path.setAttribute("stroke-opacity", Float.toString(colorA.getAlphaFloat()));
            }
            RGBA colorAEnd = (RGBA)colorEnd;
            this.path.appendChild(this.createAnimateElement("fill-opacity", Float.valueOf(colorA.getAlphaFloat()), Float.valueOf(colorAEnd.getAlphaFloat())));
        }
        switch (startCaps) {
            case 1: {
                this.path.setAttribute("stroke-linecap", "butt");
                break;
            }
            case 2: {
                this.path.setAttribute("stroke-linecap", "square");
                break;
            }
            default: {
                this.path.setAttribute("stroke-linecap", "round");
            }
        }
        switch (joints) {
            case 1: {
                this.path.setAttribute("stroke-linejoin", "bevel");
                break;
            }
            case 0: {
                this.path.setAttribute("stroke-linejoin", "round");
                break;
            }
            default: {
                this.path.setAttribute("stroke-linejoin", "miter");
                if (!(miterLimit >= 1.0f) || miterLimit == 4.0f) break;
                this.path.setAttribute("stroke-miterlimit", Double.toString(miterLimit));
            }
        }
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio, float focalPointRatioEnd) {
        this.path.removeAttribute("stroke-opacity");
        Element gradient = type == 16 ? this.exporter.createElement("linearGradient") : this.exporter.createElement("radialGradient");
        this.populateGradientElement(gradient, type, gradientRecords, gradientRecordsEnd, matrix, matrixEnd, spreadMethod, interpolationMethod, focalPointRatio);
        int id = this.exporter.gradients.indexOf(gradient);
        if (id < 0) {
            id = this.exporter.gradients.size();
            this.exporter.gradients.add(gradient);
        }
        gradient.setAttribute("id", "gradient" + id);
        this.path.setAttribute("stroke", "url(#gradient" + id + ")");
        this.path.setAttribute("fill", "none");
        this.exporter.addToDefs(gradient);
    }

    private Element createAnimateElement(String attributeName, Object startValue, Object endValue) {
        Element animate = this.exporter.createElement("animate");
        animate.setAttribute("dur", "2s");
        animate.setAttribute("repeatCount", "indefinite");
        animate.setAttribute("attributeName", attributeName);
        animate.setAttribute("values", startValue + ";" + endValue);
        return animate;
    }

    @Override
    protected void finalizePath() {
        if (this.path != null && this.pathData != null && this.pathData.length() > 0) {
            this.path.setAttribute("d", this.pathData.toString().trim());
            this.path.appendChild(this.createAnimateElement("d", this.pathData.toString().trim(), this.pathDataEnd.toString().trim()));
            this.exporter.addToGroup(this.path);
        }
        this.path = this.exporter.createElement("path");
        super.finalizePath();
    }

    private void addMatrixAnimation(Element element, String attribute, Matrix matrix, Matrix matrixEnd) {
        int animationLength = 2;
        String animationLengthStr = "2s";
        element.setAttribute(attribute, matrix.getSvgTransformationString(20.0 / this.zoom, 1.0));
        double translateX = this.roundPixels400(matrix.translateX * this.zoom / 20.0);
        double translateY = this.roundPixels400(matrix.translateY * this.zoom / 20.0);
        double a = matrix.scaleX;
        double b = matrix.rotateSkew0;
        double c = matrix.rotateSkew1;
        double d = matrix.scaleY;
        double r = Math.sqrt(a * a + b * b);
        double det = a * d - b * c;
        double rotate = this.roundPixels400(Math.signum(b) * Math.acos(a / r) * 180.0 / Math.PI);
        double scaleX = this.roundPixels400(r);
        double scaleY = this.roundPixels400(det / r);
        double skewX = this.roundPixels400(Math.atan((a * c + b * d) / (r * r)) * 180.0 / Math.PI);
        double translateXEnd = this.roundPixels400(matrixEnd.translateX * this.zoom / 20.0);
        double translateYEnd = this.roundPixels400(matrixEnd.translateY * this.zoom / 20.0);
        a = matrixEnd.scaleX;
        b = matrixEnd.rotateSkew0;
        c = matrixEnd.rotateSkew1;
        d = matrixEnd.scaleY;
        double rEnd = Math.sqrt(a * a + b * b);
        double detEnd = a * d - b * c;
        double rotateEnd = this.roundPixels400(Math.signum(b) * Math.acos(a / rEnd) * 180.0 / Math.PI);
        double scaleXEnd = this.roundPixels400(rEnd);
        double scaleYEnd = this.roundPixels400(detEnd / rEnd);
        double skewXEnd = this.roundPixels400(Math.atan((a * c + b * d) / (rEnd * rEnd)) * 180.0 / Math.PI);
        Element animateClear = this.exporter.createElement("animateTransform");
        animateClear.setAttribute("dur", "2s");
        animateClear.setAttribute("repeatCount", "indefinite");
        animateClear.setAttribute("attributeName", attribute);
        animateClear.setAttribute("type", "scale");
        animateClear.setAttribute("additive", "replace");
        animateClear.setAttribute("from", "1");
        animateClear.setAttribute("to", "1");
        Element animateTranslate = this.exporter.createElement("animateTransform");
        animateTranslate.setAttribute("dur", "2s");
        animateTranslate.setAttribute("repeatCount", "indefinite");
        animateTranslate.setAttribute("attributeName", attribute);
        animateTranslate.setAttribute("type", "translate");
        animateTranslate.setAttribute("additive", "sum");
        animateTranslate.setAttribute("from", translateX + " " + translateY);
        animateTranslate.setAttribute("to", translateXEnd + " " + translateYEnd);
        Element animateRotate = this.exporter.createElement("animateTransform");
        animateRotate.setAttribute("dur", "2s");
        animateRotate.setAttribute("repeatCount", "indefinite");
        animateRotate.setAttribute("attributeName", attribute);
        animateRotate.setAttribute("type", "rotate");
        animateRotate.setAttribute("additive", "sum");
        animateRotate.setAttribute("from", Double.toString(rotate));
        animateRotate.setAttribute("to", Double.toString(rotateEnd));
        Element animateScale = this.exporter.createElement("animateTransform");
        animateScale.setAttribute("dur", "2s");
        animateScale.setAttribute("repeatCount", "indefinite");
        animateScale.setAttribute("attributeName", attribute);
        animateScale.setAttribute("type", "scale");
        animateScale.setAttribute("additive", "sum");
        animateScale.setAttribute("from", scaleX + " " + scaleY);
        animateScale.setAttribute("to", scaleXEnd + " " + scaleYEnd);
        Element animateSkewX = this.exporter.createElement("animateTransform");
        animateSkewX.setAttribute("dur", "2s");
        animateSkewX.setAttribute("repeatCount", "indefinite");
        animateSkewX.setAttribute("attributeName", attribute);
        animateSkewX.setAttribute("type", "skewX");
        animateSkewX.setAttribute("additive", "sum");
        animateSkewX.setAttribute("from", Double.toString(skewX));
        animateSkewX.setAttribute("to", Double.toString(skewXEnd));
        element.appendChild(animateClear);
        element.appendChild(animateTranslate);
        element.appendChild(animateRotate);
        element.appendChild(animateScale);
        element.appendChild(animateSkewX);
    }

    protected void populateGradientElement(Element gradient, int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        gradient.setAttribute("gradientUnits", "userSpaceOnUse");
        if (type == 16) {
            gradient.setAttribute("x1", "-819.2");
            gradient.setAttribute("x2", "819.2");
        } else {
            gradient.setAttribute("r", "819.2");
            gradient.setAttribute("cx", "0");
            gradient.setAttribute("cy", "0");
            if (focalPointRatio != 0.0f) {
                gradient.setAttribute("fx", Double.toString(819.2 * (double)focalPointRatio));
                gradient.setAttribute("fy", "0");
            }
        }
        switch (spreadMethod) {
            case 0: {
                gradient.setAttribute("spreadMethod", "pad");
                break;
            }
            case 1: {
                gradient.setAttribute("spreadMethod", "reflect");
                break;
            }
            case 2: {
                gradient.setAttribute("spreadMethod", "repeat");
            }
        }
        if (interpolationMethod == 1) {
            gradient.setAttribute("color-interpolation", "linearRGB");
        }
        if (matrix != null) {
            this.addMatrixAnimation(gradient, "gradientTransform", matrix, matrixEnd);
        }
        for (int i = 0; i < gradientRecords.length; ++i) {
            GRADRECORD record = gradientRecords[i];
            GRADRECORD recordEnd = gradientRecordsEnd[i];
            Element gradientEntry = this.exporter.createElement("stop");
            gradientEntry.setAttribute("offset", Double.toString((double)record.ratio / 255.0));
            gradientEntry.appendChild(this.createAnimateElement("offset", (double)record.ratio / 255.0, (double)recordEnd.ratio / 255.0));
            RGB color = record.color;
            RGB colorEnd = recordEnd.color;
            gradientEntry.setAttribute("stop-color", color.toHexRGB());
            gradientEntry.appendChild(this.createAnimateElement("stop-color", color.toHexRGB(), colorEnd.toHexRGB()));
            if (color instanceof RGBA) {
                RGBA colorA = (RGBA)color;
                if (colorA.alpha != 255) {
                    gradientEntry.setAttribute("stop-opacity", Float.toString(colorA.getAlphaFloat()));
                }
                RGBA colorAEnd = (RGBA)colorEnd;
                gradientEntry.appendChild(this.createAnimateElement("stop-opacity", Float.valueOf(colorA.getAlphaFloat()), Float.valueOf(colorAEnd.getAlphaFloat())));
            }
            gradient.appendChild(gradientEntry);
        }
    }

    protected double roundPixels400(double pixels) {
        return (double)Math.round(pixels * 10000.0) / 10000.0;
    }
}

