/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.morphshape;

import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.morphshape.MorphShapeExporterBase;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;

public abstract class DefaultSVGMorphShapeExporter
extends MorphShapeExporterBase {
    protected static final String DRAW_COMMAND_L = "L";
    protected static final String DRAW_COMMAND_Q = "Q";
    protected String currentDrawCommand = "";
    protected StringBuilder pathData;
    protected StringBuilder pathDataEnd;
    protected double zoom;

    public DefaultSVGMorphShapeExporter(int morphShapeNum, SHAPE shape, SHAPE endShape, ColorTransform colorTransform, double zoom) {
        super(morphShapeNum, shape, endShape, colorTransform);
        this.zoom = zoom;
    }

    @Override
    public void beginShape() {
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines() {
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color, RGB colorEnd) {
        this.finalizePath();
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio, float focalPointRatioEnd) {
        this.finalizePath();
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, Matrix matrixEnd, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        this.finalizePath();
    }

    @Override
    public void endFill() {
        this.finalizePath();
    }

    @Override
    public void lineStyle(double thickness, double thicknessEnd, RGB color, RGB colorEnd, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio, float focalPointRatioEnd) {
    }

    @Override
    public void moveTo(double x, double y, double x2, double y2) {
        this.currentDrawCommand = "";
        this.pathData.append("M").append(this.roundPixels20(x * this.zoom / 20.0)).append(" ").append(this.roundPixels20(y * this.zoom / 20.0)).append(" ");
        this.pathDataEnd.append("M").append(this.roundPixels20(x2 * this.zoom / 20.0)).append(" ").append(this.roundPixels20(y2 * this.zoom / 20.0)).append(" ");
    }

    @Override
    public void lineTo(double x, double y, double x2, double y2) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_L)) {
            this.currentDrawCommand = DRAW_COMMAND_L;
            this.pathData.append(DRAW_COMMAND_L);
            this.pathDataEnd.append(DRAW_COMMAND_L);
        }
        this.pathData.append(this.roundPixels20(x * this.zoom / 20.0)).append(" ").append(this.roundPixels20(y * this.zoom / 20.0)).append(" ");
        this.pathDataEnd.append(this.roundPixels20(x2 * this.zoom / 20.0)).append(" ").append(this.roundPixels20(y2 * this.zoom / 20.0)).append(" ");
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY, double controlX2, double controlY2, double anchorX2, double anchorY2) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_Q)) {
            this.currentDrawCommand = DRAW_COMMAND_Q;
            this.pathData.append(DRAW_COMMAND_Q);
            this.pathDataEnd.append(DRAW_COMMAND_Q);
        }
        this.pathData.append(this.roundPixels20(controlX * this.zoom / 20.0)).append(" ").append(this.roundPixels20(controlY * this.zoom / 20.0)).append(" ").append(this.roundPixels20(anchorX * this.zoom / 20.0)).append(" ").append(this.roundPixels20(anchorY * this.zoom / 20.0)).append(" ");
        this.pathDataEnd.append(this.roundPixels20(controlX2 * this.zoom / 20.0)).append(" ").append(this.roundPixels20(controlY2 * this.zoom / 20.0)).append(" ").append(this.roundPixels20(anchorX2 * this.zoom / 20.0)).append(" ").append(this.roundPixels20(anchorY2 * this.zoom / 20.0)).append(" ");
    }

    protected void finalizePath() {
        this.pathData = new StringBuilder();
        this.pathDataEnd = new StringBuilder();
        this.currentDrawCommand = "";
    }

    protected double roundPixels20(double pixels) {
        return (double)Math.round(pixels * 100.0) / 100.0;
    }
}

