/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.exporters.modes.MovieExportMode;
import com.jpexs.decompiler.flash.exporters.settings.MovieExportSettings;
import com.jpexs.decompiler.flash.flv.FLVOutputStream;
import com.jpexs.decompiler.flash.flv.FLVTAG;
import com.jpexs.decompiler.flash.flv.SCRIPTDATA;
import com.jpexs.decompiler.flash.flv.VIDEODATA;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MovieExporter {
    public List<File> exportMovies(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, MovieExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (Thread.currentThread().isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof DefineVideoStreamTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof DefineVideoStreamTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("movie", currentIndex, count, t.getName());
            }
            DefineVideoStreamTag videoStream = (DefineVideoStreamTag)t;
            File file = new File(outdir + File.separator + Helper.makeFileName(videoStream.getCharacterExportFileName() + ".flv"));
            new RetryTask(() -> {
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                    ((OutputStream)fos).write(this.exportMovie(videoStream, settings.mode));
                }
            }, handler).run();
            if (Thread.currentThread().isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("movie", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }

    public byte[] exportMovie(DefineVideoStreamTag videoStream, MovieExportMode mode) throws IOException {
        return this.exportMovie(videoStream, mode, false);
    }

    public byte[] exportMovie(DefineVideoStreamTag videoStream, MovieExportMode mode, boolean ffdecInternal) throws IOException {
        ByteArrayOutputStream fos;
        SWF swf = videoStream.getSwf();
        HashMap<Integer, VideoFrameTag> frames = new HashMap<Integer, VideoFrameTag>();
        SWF.populateVideoFrames(videoStream.characterID, swf.getTags(), frames);
        if (frames.isEmpty()) {
            return SWFInputStream.BYTE_ARRAY_EMPTY;
        }
        ByteArrayOutputStream tos = fos = new ByteArrayOutputStream();
        FLVOutputStream flv = new FLVOutputStream(tos);
        flv.writeHeader(false, true);
        int numFrames = videoStream.numFrames;
        if (ffdecInternal) {
            numFrames += 2;
        }
        int internalFrameDelaySec = 5;
        flv.writeTag(new FLVTAG(0L, SCRIPTDATA.simpleVideOnMetadata(ffdecInternal ? (double)(numFrames * internalFrameDelaySec) : (double)((float)numFrames / swf.frameRate), videoStream.width, videoStream.height, ffdecInternal ? (double)internalFrameDelaySec : (double)swf.frameRate, videoStream.codecID)));
        int horizontalAdjustment = 0;
        int verticalAdjustment = 0;
        int[] frameNumArray = Helper.toIntArray(frames.keySet());
        Arrays.sort(frameNumArray);
        FLVTAG lastTag = null;
        int frameNum = 0;
        int internalFrameDelay = internalFrameDelaySec * 1000;
        for (int i = 0; i < frameNumArray.length; ++i) {
            SWFInputStream sis;
            VideoFrameTag tag = (VideoFrameTag)frames.get(frameNumArray[i]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            frameNum = frameNumArray[i];
            int frameType = 1;
            if (videoStream.codecID == 4 || videoStream.codecID == 5) {
                int frameMode;
                sis = new SWFInputStream(swf, tag.videoData.getRangeData());
                if (videoStream.codecID == 5) {
                    sis.readUI24("offsetToAlpha");
                }
                frameType = (frameMode = (int)sis.readUB(1, "frameMode")) == 0 ? 1 : 2;
                sis.readUB(6, "qp");
                int marker = (int)sis.readUB(1, "marker");
                if (frameMode == 0) {
                    int version = (int)sis.readUB(5, "version");
                    int version2 = (int)sis.readUB(2, "version2");
                    sis.readUB(1, "interlace");
                    if (marker == 1 || version2 == 0) {
                        sis.readUI16("offset");
                    }
                    int dim_y = sis.readUI8("dim_y");
                    int dim_x = sis.readUI8("dim_x");
                    sis.readUI8("render_y");
                    sis.readUI8("render_x");
                    horizontalAdjustment = (int)((double)dim_x * Math.ceil((double)videoStream.width / (double)dim_x)) - videoStream.width;
                    verticalAdjustment = (int)((double)dim_y * Math.ceil((double)videoStream.height / (double)dim_y)) - videoStream.height;
                }
                SWFOutputStream sos = new SWFOutputStream(baos, swf.version, swf.getCharset());
                sos.writeUB(4, horizontalAdjustment);
                sos.writeUB(4, verticalAdjustment);
            }
            if (videoStream.codecID == 2) {
                sis = new SWFInputStream(swf, tag.videoData.getRangeData());
                sis.readUB(17, "pictureStartCode");
                sis.readUB(5, "version");
                sis.readUB(8, "temporalReference");
                int pictureSize = (int)sis.readUB(3, "pictureSize");
                if (pictureSize == 0) {
                    sis.readUB(8, "customWidth");
                    sis.readUB(8, "customHeight");
                }
                if (pictureSize == 1) {
                    sis.readUB(16, "customWidth");
                    sis.readUB(16, "customHeight");
                }
                int pictureType = (int)sis.readUB(2, "pictureType");
                switch (pictureType) {
                    case 0: {
                        frameType = 1;
                        break;
                    }
                    case 1: {
                        frameType = 2;
                        break;
                    }
                    case 2: {
                        frameType = 3;
                    }
                }
            }
            baos.write(tag.videoData.getRangeData());
            lastTag = new FLVTAG((long)Math.floor(ffdecInternal ? (double)(frameNum * internalFrameDelay) : (double)frameNum * 1000.0 / (double)swf.frameRate), new VIDEODATA(frameType, videoStream.codecID, baos.toByteArray()));
            flv.writeTag(lastTag);
        }
        if (ffdecInternal && lastTag != null) {
            lastTag.timeStamp = frameNum * internalFrameDelay + 2 * internalFrameDelay;
            flv.writeTag(lastTag);
        }
        return fos.toByteArray();
    }
}

