/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.exporters.modes.ImageExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ImageExportSettings;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.HasSeparateAlphaChannel;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageExporter {
    public List<File> exportImages(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, ImageExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (Thread.currentThread().isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof ImageTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            HasSeparateAlphaChannel hsac;
            ImageFormat fileFormat;
            if (!(t instanceof ImageTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("image", currentIndex, count, t.getName());
            }
            ImageTag imageTag = (ImageTag)t;
            ImageFormat originalFormat = fileFormat = imageTag.getOriginalImageFormat();
            boolean hasSeparateAlpha = false;
            if (imageTag instanceof HasSeparateAlphaChannel) {
                HasSeparateAlphaChannel hsac2 = (HasSeparateAlphaChannel)((Object)imageTag);
                hasSeparateAlpha = hsac2.hasAlphaChannel();
            }
            if (settings.mode == ImageExportMode.PNG_GIF_JPEG && hasSeparateAlpha) {
                fileFormat = ImageFormat.PNG;
            }
            if (settings.mode == ImageExportMode.PNG) {
                fileFormat = ImageFormat.PNG;
            }
            if (settings.mode == ImageExportMode.JPEG) {
                fileFormat = ImageFormat.JPEG;
            }
            if (settings.mode == ImageExportMode.BMP) {
                fileFormat = ImageFormat.BMP;
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(imageTag.getCharacterExportFileName() + "." + ImageHelper.getImageFormatString(fileFormat)));
            ImageFormat ffileFormat = fileFormat;
            new RetryTask(() -> {
                if (ffileFormat == originalFormat) {
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                        ((OutputStream)fos).write(Helper.readStream(imageTag.getImageData()));
                    }
                } else if (ffileFormat == ImageFormat.BMP) {
                    BMPFile.saveBitmap(imageTag.getImageCached().getBufferedImage(), file);
                } else {
                    ImageHelper.write(imageTag.getImageCached().getBufferedImage(), ffileFormat, file);
                }
            }, handler).run();
            File alphaBinFile = new File(outdir + File.separator + Helper.makeFileName(imageTag.getCharacterExportFileName() + ".alpha.bin"));
            File alphaPngFile = new File(outdir + File.separator + Helper.makeFileName(imageTag.getCharacterExportFileName() + ".alpha.png"));
            if (imageTag instanceof HasSeparateAlphaChannel && settings.mode == ImageExportMode.PNG_GIF_JPEG_ALPHA && (hsac = (HasSeparateAlphaChannel)((Object)imageTag)).hasAlphaChannel()) {
                new RetryTask(() -> {
                    byte[] alphaChannel = hsac.getImageAlpha();
                    Dimension dim = imageTag.getImageDimension();
                    BufferedImage img = new BufferedImage(dim.width, dim.height, 2);
                    int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < pixels.length; ++i) {
                        int v;
                        int a = alphaChannel[i] & 0xFF;
                        int r = v = 0;
                        int g = v;
                        int b = v;
                        pixels[i] = a << 24 | b << 16 | g << 8 | r;
                    }
                    ImageIO.write((RenderedImage)img, "PNG", alphaPngFile);
                }, handler).run();
            }
            ret.add(file);
            if (Thread.currentThread().isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("image", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }
}

