/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf7;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionScriptFunction;
import com.jpexs.decompiler.flash.action.ActionScriptObject;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@SWFVersion(from=7)
public class ActionDefineFunction2
extends Action
implements GraphSourceItemContainer {
    public String functionName;
    public String replacedFunctionName;
    public List<String> paramNames = new ArrayList<String>();
    public List<String> replacedParamNames;
    public List<Integer> paramRegisters = new ArrayList<Integer>();
    public boolean preloadParentFlag;
    public boolean preloadRootFlag;
    public boolean suppressSuperFlag;
    public boolean preloadSuperFlag;
    public boolean suppressArgumentsFlag;
    public boolean preloadArgumentsFlag;
    public boolean suppressThisFlag;
    public boolean preloadThisFlag;
    @Reserved
    public int reserved;
    public boolean preloadGlobalFlag;
    public int registerCount;
    public int codeSize;
    private int version;
    public List<String> constantPool;

    @Override
    public boolean execute(LocalDataArea lda) {
        ActionScriptFunction f = new ActionScriptFunction(this.fileOffset, this.codeSize, this.functionName, this.paramNames, this.getRegNames());
        lda.push(f);
        lda.functions.add(f);
        ((ActionScriptObject)lda.target).setMember(this.functionName, f);
        return true;
    }

    public ActionDefineFunction2(String functionName, boolean preloadParentFlag, boolean preloadRootFlag, boolean suppressSuperFlag, boolean preloadSuperFlag, boolean suppressArgumentsFlag, boolean preloadArgumentsFlag, boolean suppressThisFlag, boolean preloadThisFlag, boolean preloadGlobalFlag, int registerCount, int codeSize, int version, List<String> paramNames, List<Integer> paramRegisters, String charset) {
        super(142, 0, charset);
        this.functionName = functionName;
        this.preloadParentFlag = preloadParentFlag;
        this.preloadRootFlag = preloadRootFlag;
        this.suppressSuperFlag = suppressSuperFlag;
        this.preloadSuperFlag = preloadSuperFlag;
        this.suppressArgumentsFlag = suppressArgumentsFlag;
        this.preloadArgumentsFlag = preloadArgumentsFlag;
        this.suppressThisFlag = suppressThisFlag;
        this.preloadThisFlag = preloadThisFlag;
        this.preloadGlobalFlag = preloadGlobalFlag;
        this.registerCount = registerCount;
        this.codeSize = codeSize;
        this.version = version;
        this.paramNames = paramNames;
        this.paramRegisters = paramRegisters;
    }

    public ActionDefineFunction2(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(142, actionLength, sis.getCharset());
        this.version = version;
        this.functionName = sis.readString("functionName");
        int numParams = sis.readUI16("numParams");
        this.registerCount = sis.readUI8("registerCount");
        this.preloadParentFlag = sis.readUB(1, "preloadParentFlag") == 1L;
        this.preloadRootFlag = sis.readUB(1, "preloadRootFlag") == 1L;
        this.suppressSuperFlag = sis.readUB(1, "suppressSuperFlag") == 1L;
        this.preloadSuperFlag = sis.readUB(1, "preloadSuperFlag") == 1L;
        this.suppressArgumentsFlag = sis.readUB(1, "suppressArgumentsFlag") == 1L;
        this.preloadArgumentsFlag = sis.readUB(1, "preloadArgumentsFlag") == 1L;
        this.suppressThisFlag = sis.readUB(1, "suppressThisFlag") == 1L;
        this.preloadThisFlag = sis.readUB(1, "preloadThisFlag") == 1L;
        this.reserved = (int)sis.readUB(7, "reserved");
        this.preloadGlobalFlag = sis.readUB(1, "preloadGlobalFlag") == 1L;
        for (int i = 0; i < numParams; ++i) {
            this.paramRegisters.add(sis.readUI8("paramRegister"));
            this.paramNames.add(sis.readString("paramName"));
        }
        this.codeSize = sis.readUI16("codeSize");
    }

    public ActionDefineFunction2(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(142, -1, charset);
        this.functionName = this.lexString(lexer);
        int numParams = (int)this.lexLong(lexer);
        this.registerCount = (int)this.lexLong(lexer);
        this.preloadParentFlag = this.lexBoolean(lexer);
        this.preloadRootFlag = this.lexBoolean(lexer);
        this.suppressSuperFlag = this.lexBoolean(lexer);
        this.preloadSuperFlag = this.lexBoolean(lexer);
        this.suppressArgumentsFlag = this.lexBoolean(lexer);
        this.preloadArgumentsFlag = this.lexBoolean(lexer);
        this.suppressThisFlag = this.lexBoolean(lexer);
        this.preloadThisFlag = this.lexBoolean(lexer);
        this.preloadGlobalFlag = this.lexBoolean(lexer);
        for (int i = 0; i < numParams; ++i) {
            this.paramRegisters.add((int)this.lexLong(lexer));
            this.paramNames.add(this.lexString(lexer));
        }
        this.lexBlockOpen(lexer);
    }

    @Override
    public long getHeaderSize() {
        return this.getBytesLength();
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeString(this.functionName);
        sos.writeUI16(this.paramNames.size());
        sos.writeUI8(this.registerCount);
        sos.writeUB(1, this.preloadParentFlag ? 1L : 0L);
        sos.writeUB(1, this.preloadRootFlag ? 1L : 0L);
        sos.writeUB(1, this.suppressSuperFlag ? 1L : 0L);
        sos.writeUB(1, this.preloadSuperFlag ? 1L : 0L);
        sos.writeUB(1, this.suppressArgumentsFlag ? 1L : 0L);
        sos.writeUB(1, this.preloadArgumentsFlag ? 1L : 0L);
        sos.writeUB(1, this.suppressThisFlag ? 1L : 0L);
        sos.writeUB(1, this.preloadThisFlag ? 1L : 0L);
        sos.writeUB(7, this.reserved);
        sos.writeUB(1, this.preloadGlobalFlag ? 1L : 0L);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            sos.writeUI8(this.paramRegisters.get(i));
            sos.writeString(this.paramNames.get(i));
        }
        sos.writeUI16(this.codeSize);
    }

    @Override
    protected int getContentBytesLength() {
        int res = Utf8Helper.getBytesLength(this.functionName) + 8;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            res += Utf8Helper.getBytesLength(this.paramNames.get(i)) + 2;
        }
        return res;
    }

    @Override
    public GraphTextWriter getASMSourceReplaced(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode, GraphTextWriter writer) {
        List<String> oldParamNames = this.paramNames;
        if (this.replacedParamNames != null) {
            this.paramNames = this.replacedParamNames;
        }
        String oldFunctionName = this.functionName;
        if (this.replacedFunctionName != null) {
            this.functionName = this.replacedFunctionName;
        }
        String ret = this.getASMSource(container, knownAddreses, exportMode);
        this.paramNames = oldParamNames;
        this.functionName = oldFunctionName;
        writer.appendNoHilight(ret);
        return writer;
    }

    @Override
    public String getASMSource(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode) {
        StringBuilder paramStr = new StringBuilder();
        for (int i = 0; i < this.paramNames.size(); ++i) {
            paramStr.append(this.paramRegisters.get(i)).append(" \"").append(Helper.escapeActionScriptString(this.paramNames.get(i))).append("\" ");
        }
        return ("DefineFunction2 \"" + Helper.escapeActionScriptString(this.functionName) + "\" " + this.paramRegisters.size() + " " + this.registerCount + " " + this.preloadParentFlag + " " + this.preloadRootFlag + " " + this.suppressSuperFlag + " " + this.preloadSuperFlag + " " + this.suppressArgumentsFlag + " " + this.preloadArgumentsFlag + " " + this.suppressThisFlag + " " + this.preloadThisFlag + " " + this.preloadGlobalFlag).trim() + " " + paramStr + " {" + (this.codeSize == 0 ? "\r\n}" : "");
    }

    @Override
    public String toString() {
        return "DefineFunction2";
    }

    public int getFirstRegister() {
        int pos = 1;
        if (this.preloadThisFlag) {
            ++pos;
        }
        if (this.preloadArgumentsFlag) {
            ++pos;
        }
        if (this.preloadSuperFlag) {
            ++pos;
        }
        if (this.preloadRootFlag) {
            ++pos;
        }
        if (this.preloadParentFlag) {
            ++pos;
        }
        if (this.preloadGlobalFlag) {
            ++pos;
        }
        return pos;
    }

    @Override
    public void translate(SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
    }

    @Override
    public HashMap<Integer, String> getRegNames() {
        HashMap<Integer, String> funcRegNames = new HashMap<Integer, String>();
        for (int f = 0; f < this.paramNames.size(); ++f) {
            int reg = this.paramRegisters.get(f);
            if (reg == 0) continue;
            funcRegNames.put(reg, this.paramNames.get(f));
        }
        int pos = 1;
        if (this.preloadThisFlag) {
            funcRegNames.put(pos, "this");
            ++pos;
        }
        if (this.preloadArgumentsFlag) {
            funcRegNames.put(pos, "arguments");
            ++pos;
        }
        if (this.preloadSuperFlag) {
            funcRegNames.put(pos, "super");
            ++pos;
        }
        if (this.preloadRootFlag) {
            funcRegNames.put(pos, "_root");
            ++pos;
        }
        if (this.preloadParentFlag) {
            funcRegNames.put(pos, "_parent");
            ++pos;
        }
        if (this.preloadGlobalFlag) {
            funcRegNames.put(pos, "_global");
            ++pos;
        }
        return funcRegNames;
    }

    @Override
    public void translateContainer(List<List<GraphTargetItem>> content, GraphSourceItem lineStartItem, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions) {
        ArrayList<FunctionActionItem> funcList = new ArrayList<FunctionActionItem>();
        for (String key : functions.keySet()) {
            GraphTargetItem val = functions.get(key);
            if (!(val instanceof FunctionActionItem)) continue;
            funcList.add((FunctionActionItem)val);
        }
        FunctionActionItem fti = new FunctionActionItem(this, lineStartItem, this.functionName, this.paramNames, this.getRegNames(), content.get(0), this.constantPool, this.getFirstRegister(), new ArrayList<VariableActionItem>(), funcList, false);
        functions.put(this.functionName, fti);
        stack.push(fti);
    }

    @Override
    public List<Long> getContainerSizes() {
        ArrayList<Long> ret = new ArrayList<Long>();
        ret.add(Long.valueOf(this.codeSize));
        return ret;
    }

    @Override
    public void setContainerSize(int index, long size) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be 0.");
        }
        this.codeSize = (int)size;
    }

    @Override
    public boolean parseDivision(long size, FlasmLexer lexer) {
        this.codeSize = (int)(size - this.getHeaderSize());
        return false;
    }

    @Override
    public String getASMSourceBetween(int pos) {
        return "";
    }

    @Override
    public String getName() {
        return "function";
    }
}

