/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf5;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionScriptFunction;
import com.jpexs.decompiler.flash.action.ActionScriptObject;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@SWFVersion(from=5)
public class ActionDefineFunction
extends Action
implements GraphSourceItemContainer {
    public String functionName;
    public String replacedFunctionName;
    public List<String> paramNames = new ArrayList<String>();
    public List<String> replacedParamNames;
    public int codeSize;
    private int version;
    public List<String> constantPool;

    @Override
    public boolean execute(LocalDataArea lda) {
        ActionScriptFunction f = new ActionScriptFunction(this.fileOffset, this.codeSize, this.functionName, this.paramNames, this.getRegNames());
        lda.push(f);
        lda.functions.add(f);
        ((ActionScriptObject)lda.target).setMember(this.functionName, f);
        return true;
    }

    public ActionDefineFunction(String functionName, List<String> paramNames, int codeSize, int version, String charset) {
        super(155, 0, charset);
        this.functionName = functionName;
        this.codeSize = codeSize;
        this.version = version;
        this.paramNames = paramNames;
    }

    public ActionDefineFunction(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(155, actionLength, sis.getCharset());
        this.version = version;
        this.functionName = sis.readString("functionName");
        int numParams = sis.readUI16("numParams");
        for (int i = 0; i < numParams; ++i) {
            this.paramNames.add(sis.readString("paramName"));
        }
        this.codeSize = sis.readUI16("codeSize");
    }

    public ActionDefineFunction(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(155, -1, charset);
        this.functionName = this.lexString(lexer);
        int numParams = (int)this.lexLong(lexer);
        for (int i = 0; i < numParams; ++i) {
            this.paramNames.add(this.lexString(lexer));
        }
        this.lexBlockOpen(lexer);
    }

    @Override
    public long getHeaderSize() {
        return this.getBytesLength();
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeString(this.functionName);
        sos.writeUI16(this.paramNames.size());
        for (String s : this.paramNames) {
            sos.writeString(s);
        }
        sos.writeUI16(this.codeSize);
    }

    @Override
    protected int getContentBytesLength() {
        int res = Utf8Helper.getBytesLength(this.functionName) + 5;
        for (String s : this.paramNames) {
            res += Utf8Helper.getBytesLength(s) + 1;
        }
        return res;
    }

    @Override
    public String getASMSource(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode) {
        StringBuilder paramStr = new StringBuilder();
        for (int i = 0; i < this.paramNames.size(); ++i) {
            paramStr.append("\"").append(Helper.escapeActionScriptString(this.paramNames.get(i))).append("\" ");
        }
        return "DefineFunction \"" + Helper.escapeActionScriptString(this.functionName) + "\" " + this.paramNames.size() + " " + paramStr + " {" + (this.codeSize == 0 ? "\r\n}" : "");
    }

    @Override
    public GraphTextWriter getASMSourceReplaced(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode, GraphTextWriter writer) {
        List<String> oldParamNames = this.paramNames;
        if (this.replacedParamNames != null) {
            this.paramNames = this.replacedParamNames;
        }
        String oldFunctionName = this.functionName;
        if (this.replacedFunctionName != null) {
            this.functionName = this.replacedFunctionName;
        }
        String ret = this.getASMSource(container, knownAddreses, exportMode);
        this.paramNames = oldParamNames;
        this.functionName = oldFunctionName;
        writer.appendNoHilight(ret);
        return writer;
    }

    @Override
    public void translate(SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
    }

    @Override
    public HashMap<Integer, String> getRegNames() {
        return new HashMap<Integer, String>();
    }

    @Override
    public void translateContainer(List<List<GraphTargetItem>> content, GraphSourceItem lineStartItem, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions) {
        ArrayList<FunctionActionItem> funcList = new ArrayList<FunctionActionItem>();
        for (String key : functions.keySet()) {
            GraphTargetItem val = functions.get(key);
            if (!(val instanceof FunctionActionItem)) continue;
            funcList.add((FunctionActionItem)val);
        }
        FunctionActionItem fti = new FunctionActionItem(this, lineStartItem, this.functionName, this.paramNames, this.getRegNames(), content.get(0), this.constantPool, 1, new ArrayList<VariableActionItem>(), funcList, false);
        stack.push(fti);
        functions.put(this.functionName, fti);
    }

    @Override
    public String toString() {
        return "DefineFunction";
    }

    @Override
    public boolean parseDivision(long size, FlasmLexer lexer) {
        this.codeSize = (int)(size - this.getHeaderSize());
        return false;
    }

    @Override
    public List<Long> getContainerSizes() {
        ArrayList<Long> ret = new ArrayList<Long>();
        ret.add(Long.valueOf(this.codeSize));
        return ret;
    }

    @Override
    public void setContainerSize(int index, long size) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be 0.");
        }
        this.codeSize = (int)size;
    }

    @Override
    public String getASMSourceBetween(int pos) {
        return "";
    }

    @Override
    public String getName() {
        return "function";
    }
}

