/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf4;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=4)
public class ActionJump
extends Action {
    private int offset;
    public String identifier;
    public boolean isContinue = false;
    public boolean isBreak = false;

    public int getJumpOffset() {
        return this.offset;
    }

    public final void setJumpOffset(int offset) {
        this.offset = offset;
    }

    public ActionJump(int offset, String charset) {
        super(153, 2, charset);
        this.setJumpOffset(offset);
    }

    public ActionJump(int actionLength, SWFInputStream sis) throws IOException {
        super(153, actionLength, sis.getCharset());
        this.setJumpOffset(sis.readSI16("offset"));
    }

    @Override
    public void getRef(Set<Long> refs) {
        refs.add(this.getTargetAddress());
    }

    public long getTargetAddress() {
        return this.getAddress() + 5L + (long)this.offset;
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeSI16(this.offset);
    }

    @Override
    protected int getContentBytesLength() {
        return 2;
    }

    @Override
    public String getASMSource(ActionList container, Set<Long> knownAddreses, ScriptExportMode exportMode) {
        long address = this.getTargetAddress();
        String ofsStr = Helper.formatAddress(address);
        return "Jump loc" + ofsStr;
    }

    public ActionJump(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(153, 2, charset);
        this.identifier = this.lexIdentifier(lexer);
    }

    @Override
    public String toString() {
        return "Jump " + this.offset;
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        lda.jump = this.getTargetAddress();
        return true;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    @Override
    public List<Integer> getBranches(GraphSource code) {
        List<Integer> ret = super.getBranches(code);
        long targetAddress = this.getTargetAddress();
        int ofs = code.adr2pos(targetAddress);
        if (ofs == -1) {
            int length = this.getBytesLength();
            ofs = code.adr2pos(this.getAddress() + (long)length);
            Logger.getLogger(ActionJump.class.getName()).log(Level.SEVERE, "Invalid jump to ofs{0} from ofs{1}", new Object[]{Helper.formatAddress(targetAddress), Helper.formatAddress(this.getAddress())});
        }
        ret.add(ofs);
        return ret;
    }
}

