/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf3;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.FSCommandActionItem;
import com.jpexs.decompiler.flash.action.model.GetURLActionItem;
import com.jpexs.decompiler.flash.action.model.LoadMovieNumActionItem;
import com.jpexs.decompiler.flash.action.model.UnLoadMovieActionItem;
import com.jpexs.decompiler.flash.action.model.UnLoadMovieNumActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@SWFVersion(from=3)
public class ActionGetURL
extends Action {
    public String urlString;
    public String targetString;

    @Override
    public boolean execute(LocalDataArea lda) {
        lda.stage.getURL(this.urlString, this.targetString);
        return true;
    }

    public ActionGetURL(String urlString, String targetString, String charset) {
        super(131, 0, charset);
        this.urlString = urlString;
        this.targetString = targetString;
    }

    public ActionGetURL(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(131, actionLength, sis.getCharset());
        this.urlString = sis.readString("urlString");
        this.targetString = sis.readString("targetString");
    }

    public ActionGetURL(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(131, 0, charset);
        this.urlString = this.lexString(lexer);
        this.targetString = this.lexString(lexer);
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeString(this.urlString);
        sos.writeString(this.targetString);
    }

    @Override
    protected int getContentBytesLength() {
        return Utf8Helper.getBytesLength(this.urlString) + Utf8Helper.getBytesLength(this.targetString) + 2;
    }

    @Override
    public String toString() {
        return "GetUrl \"" + Helper.escapeActionScriptString(this.urlString) + "\" \"" + Helper.escapeActionScriptString(this.targetString) + "\"";
    }

    @Override
    public void translate(SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
        String fsCommandPrefix = "FSCommand:";
        if (this.urlString.startsWith(fsCommandPrefix) && this.targetString.isEmpty()) {
            String command = this.urlString.substring(fsCommandPrefix.length());
            output.add(new FSCommandActionItem((GraphSourceItem)this, lineStartAction, new DirectValueActionItem(command)));
            return;
        }
        String levelPrefix = "_level";
        if (this.targetString.startsWith(levelPrefix)) {
            try {
                int num = Integer.valueOf(this.targetString.substring(levelPrefix.length()));
                if (this.urlString.isEmpty()) {
                    output.add(new UnLoadMovieNumActionItem((GraphSourceItem)this, lineStartAction, new DirectValueActionItem(num)));
                } else {
                    DirectValueActionItem urlStringDi = new DirectValueActionItem(null, null, 0, this.urlString, new ArrayList<String>());
                    output.add(new LoadMovieNumActionItem(this, lineStartAction, urlStringDi, new DirectValueActionItem(num), 1));
                }
                return;
            }
            catch (NumberFormatException num) {
                // empty catch block
            }
        }
        if (this.urlString.isEmpty()) {
            DirectValueActionItem targetStringDi = new DirectValueActionItem(null, null, 0, this.targetString, new ArrayList<String>());
            output.add(new UnLoadMovieActionItem((GraphSourceItem)this, lineStartAction, targetStringDi));
        } else {
            output.add(new GetURLActionItem((GraphSourceItem)this, lineStartAction, this.urlString, this.targetString));
        }
    }
}

