/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.parser.script;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionGetVariable;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionNot;
import com.jpexs.decompiler.flash.action.swf4.ActionPop;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionSetVariable;
import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionCallFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionCallMethod;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionGetMember;
import com.jpexs.decompiler.flash.action.swf5.ActionNewObject;
import com.jpexs.decompiler.flash.action.swf5.ActionPushDuplicate;
import com.jpexs.decompiler.flash.action.swf5.ActionSetMember;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.action.swf6.ActionStrictEquals;
import com.jpexs.decompiler.flash.action.swf7.ActionExtends;
import com.jpexs.decompiler.flash.action.swf7.ActionImplementsOp;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.DoWhileItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.ForItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;

public class ActionSourceGenerator
implements SourceGenerator {
    private final List<String> constantPool;
    private final int swfVersion;
    private String charset;
    private long uniqLast = 0L;

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, FalseItem item) throws CompilationException {
        return GraphTargetItem.toSourceMerge(localData, this, new ActionPush(Boolean.FALSE, this.charset));
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TrueItem item) throws CompilationException {
        return GraphTargetItem.toSourceMerge(localData, this, new ActionPush(Boolean.TRUE, this.charset));
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, AndItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(this.generateToActionList(localData, item.leftSide));
        ret.add(new ActionPushDuplicate(this.charset));
        ret.add(new ActionNot());
        List<Action> andExpr = this.generateToActionList(localData, item.rightSide);
        andExpr.add(0, new ActionPop());
        int andExprLen = Action.actionsToBytes(andExpr, false, 10).length;
        ret.add(new ActionIf(andExprLen, this.charset));
        ret.addAll(andExpr);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, OrItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(this.generateToActionList(localData, item.leftSide));
        ret.add(new ActionPushDuplicate(this.charset));
        List<Action> orExpr = this.generateToActionList(localData, item.rightSide);
        orExpr.add(0, new ActionPop());
        int orExprLen = Action.actionsToBytes(orExpr, false, 10).length;
        ret.add(new ActionIf(orExprLen, this.charset));
        ret.addAll(orExpr);
        return ret;
    }

    public List<Action> toActionList(List<GraphSourceItem> items) {
        ArrayList<Action> ret = new ArrayList<Action>();
        for (GraphSourceItem s : items) {
            if (!(s instanceof Action)) continue;
            ret.add((Action)s);
        }
        return ret;
    }

    private List<Action> nonempty(List<Action> list) {
        if (list == null) {
            return new ArrayList<Action>();
        }
        return list;
    }

    private List<GraphSourceItem> generateIf(SourceGeneratorLocalData localData, GraphTargetItem expression, List<GraphTargetItem> onTrueCmds, List<GraphTargetItem> onFalseCmds, boolean ternar) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        if (expression instanceof NotItem) {
            ret.addAll(expression.value.toSource(localData, this));
        } else {
            ret.addAll(expression.toSource(localData, this));
            ret.add(new ActionNot());
        }
        List<Action> onFalse = null;
        List<Action> onTrue = ternar ? this.toActionList(onTrueCmds.get(0).toSource(localData, this)) : this.generateToActionList(localData, onTrueCmds);
        if (onFalseCmds != null && !onFalseCmds.isEmpty()) {
            onFalse = ternar ? this.toActionList(onFalseCmds.get(0).toSource(localData, this)) : this.generateToActionList(localData, onFalseCmds);
        }
        byte[] onTrueBytes = Action.actionsToBytes(onTrue, false, 10);
        int onTrueLen = onTrueBytes.length;
        ActionIf ifaif = new ActionIf(0, this.charset);
        ret.add(ifaif);
        ret.addAll(onTrue);
        ifaif.setJumpOffset(onTrueLen);
        ActionJump ajmp = null;
        if (onFalse != null) {
            if (this.nonempty(onTrue).isEmpty() || !(onTrue.get(onTrue.size() - 1) instanceof ActionJump) || !((ActionJump)onTrue.get((int)(onTrue.size() - 1))).isContinue && !((ActionJump)onTrue.get((int)(onTrue.size() - 1))).isBreak) {
                ajmp = new ActionJump(0, this.charset);
                ret.add(ajmp);
                onTrueLen += ajmp.getTotalActionLength();
            }
            ifaif.setJumpOffset(onTrueLen);
            byte[] onFalseBytes = Action.actionsToBytes(onFalse, false, 10);
            int onFalseLen = onFalseBytes.length;
            if (ajmp != null) {
                ajmp.setJumpOffset(onFalseLen);
            }
            ret.addAll(onFalse);
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, IfItem item) throws CompilationException {
        return this.generateIf(localData, item.expression, item.onTrue, item.onFalse, false);
    }

    private void fixLoop(List<Action> code, int breakOffset) {
        this.fixLoop(code, breakOffset, Integer.MAX_VALUE);
    }

    private void fixLoop(List<Action> code, int breakOffset, int continueOffset) {
        int pos = 0;
        for (Action a : code) {
            pos += a.getBytesLength();
            if (!(a instanceof ActionJump)) continue;
            ActionJump aj = (ActionJump)a;
            if (aj.isContinue && continueOffset != Integer.MAX_VALUE) {
                aj.setJumpOffset(-pos + continueOffset);
                aj.isContinue = false;
            }
            if (!aj.isBreak) continue;
            aj.setJumpOffset(-pos + breakOffset);
            aj.isBreak = false;
        }
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TernarOpItem item) throws CompilationException {
        ArrayList<GraphTargetItem> onTrue = new ArrayList<GraphTargetItem>();
        onTrue.add(item.onTrue);
        ArrayList<GraphTargetItem> onFalse = new ArrayList<GraphTargetItem>();
        onFalse.add(item.onFalse);
        return this.generateIf(localData, item.expression, onTrue, onFalse, true);
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, WhileItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ArrayList<Action> whileExpr = new ArrayList<Action>();
        ArrayList<GraphTargetItem> ex = new ArrayList<GraphTargetItem>(item.expression);
        if (!ex.isEmpty()) {
            GraphTargetItem lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            whileExpr.addAll(this.generateToActionList(localData, ex));
            whileExpr.addAll(this.toActionList(lastItem.toSource(localData, this)));
        }
        List<Action> whileBody = this.generateToActionList(localData, item.commands);
        whileExpr.add(new ActionNot());
        ActionIf whileaif = new ActionIf(0, this.charset);
        whileExpr.add(whileaif);
        ActionJump whileajmp = new ActionJump(0, this.charset);
        whileBody.add(whileajmp);
        int whileExprLen = Action.actionsToBytes(whileExpr, false, 10).length;
        int whileBodyLen = Action.actionsToBytes(whileBody, false, 10).length;
        whileajmp.setJumpOffset(-(whileExprLen + whileBodyLen));
        whileaif.setJumpOffset(whileBodyLen);
        ret.addAll(whileExpr);
        this.fixLoop(whileBody, whileBodyLen, -whileExprLen);
        ret.addAll(whileBody);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, DoWhileItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ArrayList<Action> doExpr = new ArrayList<Action>();
        ArrayList<GraphTargetItem> ex = new ArrayList<GraphTargetItem>(item.expression);
        if (!ex.isEmpty()) {
            GraphTargetItem lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            doExpr.addAll(this.generateToActionList(localData, ex));
            doExpr.addAll(this.toActionList(lastItem.toSource(localData, this)));
        }
        List<Action> doBody = this.generateToActionList(localData, item.commands);
        int doBodyLen = Action.actionsToBytes(doBody, false, 10).length;
        int doExprLen = Action.actionsToBytes(doExpr, false, 10).length;
        ret.addAll(doBody);
        ret.addAll(doExpr);
        ActionIf doif = new ActionIf(0, this.charset);
        ret.add(doif);
        int offset = doBodyLen + doExprLen + doif.getTotalActionLength();
        doif.setJumpOffset(-offset);
        this.fixLoop(doBody, offset, doBodyLen);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ForItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        List<Action> forExpr = this.generateToActionList(localData, item.expression);
        List<Action> forBody = this.generateToActionList(localData, item.commands);
        List<Action> forFinalCommands = this.generateToActionList(localData, item.finalCommands);
        forExpr.add(new ActionNot());
        ActionIf foraif = new ActionIf(0, this.charset);
        forExpr.add(foraif);
        ActionJump forajmp = new ActionJump(0, this.charset);
        int forajmpLen = forajmp.getTotalActionLength();
        int forExprLen = Action.actionsToBytes(forExpr, false, 10).length;
        int forBodyLen = Action.actionsToBytes(forBody, false, 10).length;
        int forFinalLen = Action.actionsToBytes(forFinalCommands, false, 10).length;
        forajmp.setJumpOffset(-(forExprLen + forBodyLen + forFinalLen + forajmpLen));
        foraif.setJumpOffset(forBodyLen + forFinalLen + forajmpLen);
        ret.addAll(forExpr);
        ret.addAll(forBody);
        ret.addAll(forFinalCommands);
        ret.add(forajmp);
        this.fixLoop(forBody, forBodyLen + forFinalLen + forajmpLen, forBodyLen);
        return ret;
    }

    public String uniqId() {
        ++this.uniqLast;
        return "" + this.uniqLast;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, SwitchItem item) throws CompilationException {
        void var14_25;
        int n;
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        HashMap<String, Integer> registerVars = this.getRegisterVars(localData);
        int exprReg = 0;
        for (int i = 0; i < 256; ++i) {
            if (registerVars.containsValue(i)) continue;
            registerVars.put("__switch" + this.uniqId(), i);
            exprReg = i;
            break;
        }
        ret.addAll(this.toActionList(item.switchedObject.toSource(localData, this)));
        boolean firstCase = true;
        ArrayList caseIfs = new ArrayList();
        ArrayList<List> caseCmds = new ArrayList<List>();
        ArrayList<Object> caseExprsAll = new ArrayList<Object>();
        int defaultPos = -1;
        for (int m = 0; m < item.caseValues.size(); ++m) {
            ArrayList caseExprs = new ArrayList();
            ArrayList<ActionIf> arrayList = new ArrayList<ActionIf>();
            int n2 = item.valuesMapping.get(m);
            while (m < item.caseValues.size()) {
                int newmapping = item.valuesMapping.get(m);
                if (newmapping != n2) {
                    --m;
                    break;
                }
                if (item.caseValues.get(m) instanceof DefaultItem) {
                    defaultPos = caseIfs.size();
                } else {
                    List<Action> curCaseExpr = this.generateToActionList(localData, item.caseValues.get(m));
                    caseExprs.add(curCaseExpr);
                    if (firstCase) {
                        curCaseExpr.add(0, new ActionStoreRegister(exprReg, this.charset));
                    } else {
                        curCaseExpr.add(0, new ActionPush(new RegisterNumber(exprReg), this.charset));
                    }
                    curCaseExpr.add(new ActionStrictEquals());
                    ActionIf aif = new ActionIf(0, this.charset);
                    arrayList.add(aif);
                    curCaseExpr.add(aif);
                    ret.addAll((Collection<GraphSourceItem>)curCaseExpr);
                }
                firstCase = false;
                ++m;
            }
            caseExprsAll.add(caseExprs);
            caseIfs.add(arrayList);
            List caseCmd = this.generateToActionList(localData, item.caseCommands.get(n2));
            caseCmds.add(caseCmd);
        }
        ActionJump defJump = new ActionJump(0, this.charset);
        ret.add(defJump);
        for (List list : caseCmds) {
            ret.addAll(list);
        }
        ArrayList exprLengths = new ArrayList();
        for (List list : caseExprsAll) {
            ArrayList<Integer> lengths = new ArrayList<Integer>();
            for (List caseExpr : list) {
                lengths.add(Action.actionsToBytes(caseExpr, false, 10).length);
            }
            exprLengths.add(lengths);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (List caseCmd : caseCmds) {
            arrayList.add(Action.actionsToBytes(caseCmd, false, 10).length);
        }
        boolean bl = false;
        while (n < caseIfs.size()) {
            for (int c = 0; c < ((List)caseIfs.get(n)).size(); ++c) {
                int jmpPos = 0;
                for (int j = c + 1; j < ((List)caseIfs.get(n)).size(); ++j) {
                    jmpPos += ((Integer)((List)exprLengths.get(n)).get(j)).intValue();
                }
                for (void k = n + true; k < caseIfs.size(); ++k) {
                    for (int m = 0; m < ((List)caseIfs.get((int)k)).size(); ++m) {
                        jmpPos += ((Integer)((List)exprLengths.get((int)k)).get(m)).intValue();
                    }
                }
                jmpPos += defJump.getTotalActionLength();
                for (int n3 = 0; n3 < n; ++n3) {
                    jmpPos += ((Integer)arrayList.get(n3)).intValue();
                }
                ((ActionIf)((List)caseIfs.get(n)).get(c)).setJumpOffset(jmpPos);
            }
            ++n;
        }
        boolean bl2 = false;
        for (int i = 0; i < caseIfs.size(); ++i) {
            if (defaultPos != -1 && i >= defaultPos) continue;
            var14_25 += ((Integer)arrayList.get(i)).intValue();
        }
        defJump.setJumpOffset((int)var14_25);
        ArrayList<Action> caseCmdsAll = new ArrayList<Action>();
        int breakOffset = 0;
        for (int i = 0; i < caseCmds.size(); ++i) {
            caseCmdsAll.addAll((Collection)caseCmds.get(i));
            breakOffset += ((Integer)arrayList.get(i)).intValue();
        }
        this.fixLoop(caseCmdsAll, breakOffset);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, NotItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(item.getOriginal().toSource(localData, this));
        ret.add(new ActionNot());
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, DuplicateItem item) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new ActionPushDuplicate(this.charset));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, BreakItem item) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionJump abreak = new ActionJump(0, this.charset);
        abreak.isBreak = true;
        ret.add(abreak);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ContinueItem item) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionJump acontinue = new ActionJump(0, this.charset);
        acontinue.isContinue = true;
        ret.add(acontinue);
        return ret;
    }

    private List<Action> generateToActionList(SourceGeneratorLocalData localData, List<GraphTargetItem> commands) throws CompilationException {
        return this.toActionList(this.generate(localData, commands));
    }

    private List<Action> generateToActionList(SourceGeneratorLocalData localData, GraphTargetItem command) throws CompilationException {
        return this.toActionList(command.toSource(localData, this));
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, List<GraphTargetItem> commands) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        for (GraphTargetItem item : commands) {
            ret.addAll(item.toSourceIgnoreReturnValue(localData, this));
        }
        return ret;
    }

    public HashMap<String, Integer> getRegisterVars(SourceGeneratorLocalData localData) {
        return localData.registerVars;
    }

    public void setRegisterVars(SourceGeneratorLocalData localData, HashMap<String, Integer> value) {
        localData.registerVars = value;
    }

    public void setInFunction(SourceGeneratorLocalData localData, int value) {
        localData.inFunction = value;
    }

    public int isInFunction(SourceGeneratorLocalData localData) {
        return localData.inFunction;
    }

    public boolean isInMethod(SourceGeneratorLocalData localData) {
        return localData.inMethod;
    }

    public void setInMethod(SourceGeneratorLocalData localData, boolean value) {
        localData.inMethod = value;
    }

    public int getForInLevel(SourceGeneratorLocalData localData) {
        return localData.forInLevel;
    }

    public void setForInLevel(SourceGeneratorLocalData localData, int value) {
        localData.forInLevel = value;
    }

    public int getTempRegister(SourceGeneratorLocalData localData) {
        HashMap<String, Integer> registerVars = this.getRegisterVars(localData);
        for (int tmpReg = 0; tmpReg < 256; ++tmpReg) {
            if (registerVars.containsValue(tmpReg)) continue;
            registerVars.put("__temp" + tmpReg, tmpReg);
            return tmpReg;
        }
        return 0;
    }

    public void releaseTempRegister(SourceGeneratorLocalData localData, int tmp) {
        HashMap<String, Integer> registerVars = this.getRegisterVars(localData);
        registerVars.remove("__temp" + tmp);
    }

    private String getName(GraphTargetItem item) {
        if (item instanceof VariableActionItem) {
            return ((VariableActionItem)item).getVariableName();
        }
        if (item instanceof DirectValueActionItem) {
            DirectValueActionItem dv = (DirectValueActionItem)item;
            return (String)dv.getResult();
        }
        if (item instanceof GetVariableActionItem) {
            GetVariableActionItem gv = (GetVariableActionItem)item;
            return this.getName(gv.name);
        }
        if (item instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)item;
            return this.getName(mem.memberName);
        }
        return null;
    }

    private List<String> getVarParts(GraphTargetItem item) {
        ArrayList<String> ret = new ArrayList<String>();
        do {
            if (!(item instanceof GetMemberActionItem)) continue;
            GetMemberActionItem mem = (GetMemberActionItem)item;
            ret.add(0, this.getName(mem));
            item = mem.object;
        } while (item instanceof GetMemberActionItem);
        String f = this.getName(item);
        if (f != null) {
            ret.add(0, f);
        }
        return ret;
    }

    private int getVarLength(GraphTargetItem item) {
        int len = 1;
        do {
            if (!(item instanceof GetMemberActionItem)) continue;
            GetMemberActionItem mem = (GetMemberActionItem)item;
            item = mem.object;
            ++len;
        } while (item instanceof GetMemberActionItem);
        return len;
    }

    private GraphTargetItem removeVarLast(GraphTargetItem item, int cnt) {
        item = Helper.deepCopy(item);
        for (int i = 0; i < cnt; ++i) {
            if (!(item instanceof GetMemberActionItem)) continue;
            GetMemberActionItem mem = (GetMemberActionItem)item;
            item = mem.object;
        }
        return item;
    }

    private GraphTargetItem addGlobalPrefix(GraphTargetItem item) {
        GraphTargetItem first = item = Helper.deepCopy(item);
        GetMemberActionItem mem = null;
        do {
            if (!(item instanceof GetMemberActionItem)) continue;
            mem = (GetMemberActionItem)item;
            item = mem.object;
        } while (item instanceof GetMemberActionItem);
        if (item instanceof GetVariableActionItem) {
            GetVariableActionItem v = (GetVariableActionItem)item;
            item = new GetMemberActionItem(null, null, new GetVariableActionItem(null, null, new DirectValueActionItem(null, null, 0, "_global", new ArrayList<String>())), v.name);
            if (mem != null) {
                mem.object = item;
            }
        }
        return first;
    }

    private List<Action> typeToActions(List<String> type, List<Action> value) {
        ArrayList<Action> ret = new ArrayList<Action>();
        if (type.isEmpty()) {
            return ret;
        }
        ret.add(this.pushConst(type.get(0)));
        if (type.size() == 1 && value != null) {
            ret.addAll(value);
            ret.add(new ActionSetVariable());
        } else {
            ret.add(new ActionGetVariable());
        }
        for (int i = 1; i < type.size(); ++i) {
            ret.add(this.pushConst(type.get(i)));
            if (i == type.size() - 1 && value != null) {
                ret.addAll(value);
                ret.add(new ActionSetMember());
                continue;
            }
            ret.add(new ActionGetMember());
        }
        return ret;
    }

    public int getSwfVersion() {
        return this.swfVersion;
    }

    public ActionSourceGenerator(int swfVersion, List<String> constantPool, String charset) {
        this.constantPool = constantPool;
        this.swfVersion = swfVersion;
        this.charset = charset;
    }

    public List<String> getConstantPool() {
        return this.constantPool;
    }

    public DirectValueActionItem pushConstTargetItem(String s) {
        int index = this.constantPool.indexOf(s);
        if (index == -1) {
            this.constantPool.add(s);
            index = this.constantPool.indexOf(s);
        }
        return new DirectValueActionItem(null, null, 0, new ConstantIndex(index), this.constantPool);
    }

    public ActionPush pushConst(String s) {
        int index = this.constantPool.indexOf(s);
        if (index == -1) {
            this.constantPool.add(s);
            index = this.constantPool.indexOf(s);
        }
        return new ActionPush(new ConstantIndex(index), this.charset);
    }

    public List<GraphSourceItem> generateTraits(SourceGeneratorLocalData localData, boolean isInterface, GraphTargetItem name, GraphTargetItem extendsVal, List<GraphTargetItem> implementsStr, List<MyEntry<GraphTargetItem, GraphTargetItem>> traits, List<Boolean> traitsStatic) throws CompilationException {
        List<String> extendsStr = this.getVarParts(extendsVal);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        List<String> nameStr = this.getVarParts(name);
        for (int i = 0; i < nameStr.size() - 1; ++i) {
            ArrayList<Action> notBody = new ArrayList<Action>();
            ArrayList<String> globalClassTypeStr = new ArrayList<String>();
            globalClassTypeStr.add("_global");
            for (int j = 0; j <= i; ++j) {
                globalClassTypeStr.add(nameStr.get(j));
            }
            ArrayList<Action> val = new ArrayList<Action>();
            val.add(new ActionPush(0.0, this.charset));
            val.add(this.pushConst("Object"));
            val.add(new ActionNewObject());
            notBody.addAll(this.typeToActions(globalClassTypeStr, val));
            ret.addAll(this.typeToActions(globalClassTypeStr, null));
            ret.add(new ActionNot());
            ret.add(new ActionNot());
            ret.add(new ActionIf(Action.actionsToBytes(notBody, false, 10).length, this.charset));
            ret.addAll(notBody);
            ret.add(new ActionPop());
        }
        ArrayList<Action> ifbody = new ArrayList<Action>();
        ArrayList<String> globalClassTypeStr = new ArrayList<String>();
        globalClassTypeStr.add("_global");
        globalClassTypeStr.addAll(nameStr);
        String constructorName = nameStr.get(nameStr.size() - 1);
        GraphTargetItem constructor = null;
        int constructorIndex = -1;
        for (int t = 0; t < traits.size(); ++t) {
            MyEntry<GraphTargetItem, GraphTargetItem> en = traits.get(t);
            if (!(en.getValue() instanceof FunctionActionItem) || !constructorName.equals(this.getName(en.getKey()))) continue;
            constructorIndex = t;
            constructor = en.getValue();
            break;
        }
        Object s = null;
        List<Action> constr = new ArrayList<Action>();
        if (constructor == null) {
            ArrayList<Action> val = new ArrayList<Action>();
            val.add(new ActionDefineFunction("", new ArrayList<String>(), 0, 10, this.charset));
            if (!isInterface) {
                val.add(new ActionStoreRegister(1, this.charset));
            }
            constr.addAll(this.typeToActions(globalClassTypeStr, val));
        } else {
            constr.addAll(this.toActionList(((FunctionActionItem)constructor).toSource(localData, this)));
            constr.add(new ActionStoreRegister(1, this.charset));
            constr = this.typeToActions(globalClassTypeStr, constr);
        }
        LinkedHashSet properties = new LinkedHashSet();
        HashSet setters = new HashSet();
        HashSet getters = new HashSet();
        LinkedHashSet<String> staticProperties = new LinkedHashSet<String>();
        HashSet<String> staticSetters = new HashSet<String>();
        HashSet<String> staticGetters = new HashSet<String>();
        if (!isInterface) {
            for (int pass = 1; pass <= 2; ++pass) {
                for (int t = 0; t < traits.size(); ++t) {
                    if (constructorIndex == t) continue;
                    MyEntry<GraphTargetItem, GraphTargetItem> en = traits.get(t);
                    boolean isFunc = en.getValue() instanceof FunctionActionItem;
                    if (pass == 1 && isFunc) {
                        FunctionActionItem fi = (FunctionActionItem)en.getValue();
                        if (fi.isGetter || fi.isSetter) {
                            (traitsStatic.get(t) != false ? staticProperties : properties).add(fi.calculatedFunctionName.toString());
                        }
                        String prefix = "";
                        if (fi.isGetter) {
                            (traitsStatic.get(t) != false ? staticGetters : getters).add(fi.calculatedFunctionName.toString());
                            prefix = "__get__";
                        }
                        if (fi.isSetter) {
                            (traitsStatic.get(t) != false ? staticSetters : setters).add(fi.calculatedFunctionName.toString());
                            prefix = "__set__";
                        }
                        ifbody.add(new ActionPush(new RegisterNumber(traitsStatic.get(t) != false ? 1 : 2), this.charset));
                        ifbody.add(this.pushConst(prefix + this.getName(en.getKey())));
                        ifbody.addAll(this.toActionList(fi.toSource(localData, this)));
                        ifbody.add(new ActionSetMember());
                        continue;
                    }
                    if (pass != 2 || isFunc) continue;
                    ifbody.add(new ActionPush(new RegisterNumber(traitsStatic.get(t) != false ? 1 : 2), this.charset));
                    ifbody.add(this.pushConst(this.getName(en.getKey())));
                    ifbody.addAll(this.toActionList(en.getValue().toSource(localData, this)));
                    ifbody.add(new ActionSetMember());
                }
            }
        }
        for (String prop : staticProperties) {
            if (staticSetters.contains(prop)) {
                ifbody.add(new ActionPush(new Object[]{new RegisterNumber(1), "__set__" + prop}, this.charset));
                ifbody.add(new ActionGetMember());
            } else {
                ifbody.add(new ActionDefineFunction("", new ArrayList<String>(), 0, this.swfVersion, this.charset));
            }
            if (staticGetters.contains(prop)) {
                ifbody.add(new ActionPush(new Object[]{new RegisterNumber(1), "__get__" + prop}, this.charset));
                ifbody.add(new ActionGetMember());
            } else {
                ifbody.add(new ActionDefineFunction("", new ArrayList<String>(), 0, this.swfVersion, this.charset));
            }
            ifbody.add(new ActionPush(new Object[]{prop, 3, new RegisterNumber(1), "addProperty"}, this.charset));
            ifbody.add(new ActionCallMethod());
        }
        for (String prop : properties) {
            if (setters.contains(prop)) {
                ifbody.add(new ActionPush(new Object[]{new RegisterNumber(2), "__set__" + prop}, this.charset));
                ifbody.add(new ActionGetMember());
            } else {
                ifbody.add(new ActionDefineFunction("", new ArrayList<String>(), 0, this.swfVersion, this.charset));
            }
            if (getters.contains(prop)) {
                ifbody.add(new ActionPush(new Object[]{new RegisterNumber(2), "__get__" + prop}, this.charset));
                ifbody.add(new ActionGetMember());
            } else {
                ifbody.add(new ActionDefineFunction("", new ArrayList<String>(), 0, this.swfVersion, this.charset));
            }
            ifbody.add(new ActionPush(new Object[]{prop, 3, new RegisterNumber(2), "addProperty"}, this.charset));
            ifbody.add(new ActionCallMethod());
        }
        if (!isInterface) {
            ifbody.add(new ActionPush(1L, this.charset));
            ifbody.add(new ActionPush(Null.INSTANCE, this.charset));
            ifbody.addAll(this.typeToActions(globalClassTypeStr, null));
            ifbody.add(this.pushConst("prototype"));
            ifbody.add(new ActionGetMember());
            ifbody.add(new ActionPush(3L, this.charset));
            ifbody.add(this.pushConst("ASSetPropFlags"));
            ifbody.add(new ActionCallFunction());
        }
        if (constr.isEmpty()) {
            ArrayList<ActionDefineFunction> val = new ArrayList<ActionDefineFunction>();
            val.add(new ActionDefineFunction("", new ArrayList<String>(), 0, 10, this.charset));
            if (!isInterface) {
                val.add((ActionDefineFunction)((Object)new ActionStoreRegister(1, this.charset)));
            }
            constr.addAll(this.typeToActions(globalClassTypeStr, (List<Action>)val));
        }
        if (!extendsStr.isEmpty()) {
            constr.addAll(this.typeToActions(globalClassTypeStr, null));
            constr.addAll(this.typeToActions(extendsStr, null));
            constr.add(new ActionExtends(this.charset));
        }
        if (!isInterface) {
            constr.add(new ActionPush(new RegisterNumber(1), this.charset));
            constr.add(this.pushConst("prototype"));
            constr.add(new ActionGetMember());
            constr.add(new ActionStoreRegister(2, this.charset));
            constr.add(new ActionPop());
        }
        if (!implementsStr.isEmpty()) {
            for (GraphTargetItem imp : implementsStr) {
                List<String> impList = this.getVarParts(imp);
                ArrayList<String> globImp = new ArrayList<String>();
                globImp.add("_global");
                globImp.addAll(impList);
                constr.addAll(this.typeToActions(globImp, null));
            }
            constr.add(new ActionPush(implementsStr.size(), this.charset));
            constr.addAll(this.typeToActions(globalClassTypeStr, null));
            constr.add(new ActionImplementsOp(this.charset));
        }
        ifbody.addAll(0, constr);
        ret.addAll(this.typeToActions(globalClassTypeStr, null));
        ret.add(new ActionNot());
        ret.add(new ActionNot());
        int ifOffset = Action.actionsToBytes(ifbody, false, 10).length;
        if (ifOffset > Short.MAX_VALUE) {
            if (!localData.secondRun) {
                Logger.getLogger(ActionSourceGenerator.class.getName()).warning("The class is long. If offset for its header would be longer than max value for SI16, 0 was stored instead. This should not have any negative impact.");
            }
            ifOffset = 0;
        }
        ret.add(new ActionIf(ifOffset, this.charset));
        ret.addAll(ifbody);
        ret.add(new ActionPop());
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, CommaExpressionItem item, boolean withReturnValue) throws CompilationException {
        if (item.commands.isEmpty()) {
            return new ArrayList<GraphSourceItem>();
        }
        ArrayList<GraphTargetItem> cmds = new ArrayList<GraphTargetItem>(item.commands);
        GraphTargetItem lastExpr = (GraphTargetItem)cmds.remove(cmds.size() - 1);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(this.generate(localData, cmds));
        ret.addAll(withReturnValue ? lastExpr.toSource(localData, this) : lastExpr.toSourceIgnoreReturnValue(localData, this));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TypeItem item) throws CompilationException {
        return new ArrayList<GraphSourceItem>();
    }

    @Override
    public List<GraphSourceItem> generateDiscardValue(SourceGeneratorLocalData localData, GraphTargetItem item) throws CompilationException {
        List<GraphSourceItem> ret = item.toSource(localData, this);
        ret.add(new ActionPop());
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, PushItem item) throws CompilationException {
        return item.value.toSource(localData, this);
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, PopItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        return ret;
    }

    public String getCharset() {
        return this.charset;
    }
}

