/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.operations.Inverted;
import com.jpexs.decompiler.flash.action.model.operations.StringNeActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionStringEquals;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class StringEqActionItem
extends BinaryOpItem
implements Inverted {
    public StringEqActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 7, leftSide, rightSide, "eq", "String", "String");
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return false;
    }

    @Override
    public Object getResult() {
        return StringEqActionItem.getResult(this.rightSide.getResult(), this.leftSide.getResult());
    }

    public static Boolean getResult(Object rightResult, Object leftResult) {
        return EcmaScript.toString(leftResult).equals(EcmaScript.toString(rightResult));
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return StringEqActionItem.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new ActionStringEquals());
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.BOOLEAN;
    }

    @Override
    public GraphTargetItem invert(GraphSourceItem negSrc) {
        return new StringNeActionItem(this.getSrc(), this.getLineStartItem(), this.leftSide, this.rightSide);
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new ActionStringEquals());
        return ret;
    }
}

