/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionSetProperty;
import com.jpexs.decompiler.flash.action.swf4.ActionSetVariable;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionIncrement;
import com.jpexs.decompiler.flash.action.swf5.ActionSetMember;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.UnaryOpItem;
import java.util.ArrayList;
import java.util.List;

public class PreIncrementActionItem
extends UnaryOpItem {
    public PreIncrementActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object) {
        super(instruction, lineStartIns, 2, object, "++", "");
    }

    @Override
    public Object getResult() {
        return this.value.getResultAsNumber() + 1.0;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        GraphTargetItem val = this.value;
        if (val instanceof VariableActionItem) {
            val = ((VariableActionItem)val).getBoxedValue();
        }
        if (val instanceof GetVariableActionItem) {
            GetVariableActionItem gv = (GetVariableActionItem)val;
            ret.addAll(gv.toSource(localData, generator));
            ret.remove(ret.size() - 1);
            ret.addAll(gv.toSource(localData, generator));
            ret.add(new ActionIncrement());
            int tmpReg = asGenerator.getTempRegister(localData);
            ret.add(new ActionStoreRegister(tmpReg, charset));
            ret.add(new ActionSetVariable());
            ret.add(new ActionPush(new RegisterNumber(tmpReg), charset));
            asGenerator.releaseTempRegister(localData, tmpReg);
        } else if (val instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)val;
            ret.addAll(mem.toSource(localData, generator));
            ret.remove(ret.size() - 1);
            ret.addAll(mem.toSource(localData, generator));
            ret.add(new ActionIncrement());
            int tmpReg = asGenerator.getTempRegister(localData);
            ret.add(new ActionStoreRegister(tmpReg, charset));
            ret.add(new ActionSetMember());
            ret.add(new ActionPush(new RegisterNumber(tmpReg), charset));
            asGenerator.releaseTempRegister(localData, tmpReg);
        } else if (val instanceof DirectValueActionItem && ((DirectValueActionItem)val).value instanceof RegisterNumber) {
            RegisterNumber rn = (RegisterNumber)((DirectValueActionItem)val).value;
            ret.add(new ActionPush(new RegisterNumber(rn.number), charset));
            ret.add(new ActionIncrement());
            ret.add(new ActionStoreRegister(rn.number, charset));
        } else if (val instanceof GetPropertyActionItem) {
            GetPropertyActionItem gp = (GetPropertyActionItem)val;
            ret.addAll(gp.toSource(localData, generator));
            ret.addAll(gp.toSource(localData, generator));
            ret.remove(ret.size() - 1);
            ret.addAll(gp.toSource(localData, generator));
            ret.add(new ActionIncrement());
            ret.add(new ActionSetProperty());
        }
        return ret;
    }

    @Override
    public GraphTargetItem returnType() {
        return this.value.returnType();
    }
}

