/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.CompoundableBinaryOpAs12;
import com.jpexs.decompiler.flash.action.swf4.ActionDivide;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import java.util.ArrayList;
import java.util.List;

public class DivideActionItem
extends BinaryOpItem
implements CompoundableBinaryOpAs12 {
    public DivideActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 3, leftSide, rightSide, "/", "Number", "Number");
    }

    @Override
    public Object getResult() {
        return DivideActionItem.getResult(this.rightSide.getResultAsNumber(), this.leftSide.getResultAsNumber());
    }

    public static Double getResult(Double rightResult, Double leftResult) {
        if (Double.compare(rightResult, 0.0) == 0) {
            return leftResult < 0.0 ? Double.NEGATIVE_INFINITY : (leftResult > 0.0 ? Double.POSITIVE_INFINITY : Double.NaN);
        }
        return leftResult / rightResult;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return DivideActionItem.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new ActionDivide());
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new ActionDivide());
        return ret;
    }
}

