/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.CompoundableBinaryOpAs12;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionBitXor;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class BitXorActionItem
extends BinaryOpItem
implements CompoundableBinaryOpAs12 {
    public BitXorActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 9, leftSide, rightSide, "^", "int", "int");
    }

    @Override
    public Object getResult() {
        return BitXorActionItem.getResult(this.rightSide.getResult(), this.leftSide.getResult());
    }

    public static long getResult(Object rightResult, Object leftResult) {
        return EcmaScript.toInt32(leftResult) ^ EcmaScript.toInt32(rightResult);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.rightSide instanceof DirectValueActionItem && ((DirectValueActionItem)this.rightSide).value.equals(4.294967295E9)) {
            writer.append("~");
            if (this.leftSide.getPrecedence() > 2) {
                writer.append("(");
            }
            this.leftSide.appendTry(writer, localData);
            if (this.leftSide.getPrecedence() > 2) {
                writer.append(")");
            }
            return writer;
        }
        return super.appendTo(writer, localData);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return BitXorActionItem.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new ActionBitXor());
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new ActionBitXor());
        return ret;
    }
}

