/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionPop;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineLocal;
import com.jpexs.decompiler.flash.action.swf5.ActionEquals2;
import com.jpexs.decompiler.flash.action.swf5.ActionPushDuplicate;
import com.jpexs.decompiler.flash.action.swf5.ActionStackSwap;
import com.jpexs.decompiler.flash.action.swf7.ActionCastOp;
import com.jpexs.decompiler.flash.action.swf7.ActionThrow;
import com.jpexs.decompiler.flash.action.swf7.ActionTry;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TryActionItem
extends ActionItem
implements Block {
    public List<GraphTargetItem> tryCommands;
    public List<GraphTargetItem> catchExceptionNames;
    public List<GraphTargetItem> catchExceptionTypes;
    public List<List<GraphTargetItem>> catchCommands;
    public List<GraphTargetItem> finallyCommands;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.tryCommands != null) {
            ret.add(this.tryCommands);
        }
        ret.addAll(this.catchCommands);
        if (this.finallyCommands != null) {
            ret.add(this.finallyCommands);
        }
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        if (this.tryCommands != null) {
            visitor.visitAll(this.tryCommands);
        }
        for (List<GraphTargetItem> cc : this.catchCommands) {
            visitor.visitAll(cc);
        }
        if (this.finallyCommands != null) {
            visitor.visitAll(this.finallyCommands);
        }
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
    }

    public TryActionItem(List<GraphTargetItem> tryCommands, List<GraphTargetItem> catchExceptionNames, List<GraphTargetItem> catchExceptionTypes, List<List<GraphTargetItem>> catchCommands, List<GraphTargetItem> finallyCommands) {
        super(null, null, 16);
        this.tryCommands = tryCommands;
        this.catchExceptionNames = catchExceptionNames;
        this.catchExceptionTypes = catchExceptionTypes;
        this.catchCommands = catchCommands;
        this.finallyCommands = finallyCommands;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("try");
        this.appendBlock(null, writer, localData, this.tryCommands);
        for (int e = 0; e < this.catchExceptionNames.size(); ++e) {
            writer.newLine();
            writer.append("catch");
            if (writer.getFormatting().spaceBeforeParenthesesCatchParentheses) {
                writer.append(" ");
            }
            writer.append("(");
            this.catchExceptionNames.get(e).toStringNoQuotes(writer, localData);
            if (this.catchExceptionTypes.get(e) != null) {
                writer.append(":");
                this.catchExceptionTypes.get(e).toStringNoQuotes(writer, localData);
            }
            writer.append(")");
            List<GraphTargetItem> commands = this.catchCommands.get(e);
            this.appendBlock(null, writer, localData, commands);
        }
        if (this.catchExceptionNames.isEmpty() || this.finallyCommands.size() > 0) {
            writer.newLine();
            writer.append("finally");
            this.appendBlock(null, writer, localData, this.finallyCommands);
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem graphTargetItem : this.tryCommands) {
            if (graphTargetItem instanceof ContinueItem) {
                ret.add((ContinueItem)graphTargetItem);
            }
            if (!(graphTargetItem instanceof Block)) continue;
            ret.addAll(((Block)((Object)graphTargetItem)).getContinues());
        }
        if (this.finallyCommands != null) {
            for (GraphTargetItem graphTargetItem : this.finallyCommands) {
                if (graphTargetItem instanceof ContinueItem) {
                    ret.add((ContinueItem)graphTargetItem);
                }
                if (!(graphTargetItem instanceof Block)) continue;
                ret.addAll(((Block)((Object)graphTargetItem)).getContinues());
            }
        }
        for (List list : this.catchCommands) {
            for (GraphTargetItem ti : list) {
                if (ti instanceof ContinueItem) {
                    ret.add((ContinueItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        List<Action> tryCommandsA = asGenerator.toActionList(asGenerator.generate(localData, this.tryCommands));
        List<Action> finallyCommandsA = this.finallyCommands == null ? null : asGenerator.toActionList(asGenerator.generate(localData, this.finallyCommands));
        List<Action> catchCommandsA = null;
        String catchName = null;
        int catchSize = 0;
        int catchRegister = 0;
        boolean catchInRegisterFlag = false;
        if (!this.catchCommands.isEmpty()) {
            List<GraphSourceItem> fullCatchBody = new ArrayList<GraphSourceItem>();
            if (this.catchExceptionNames.size() == 1 && this.catchExceptionTypes.get(0) == null) {
                GraphTargetItem ename = this.catchExceptionNames.get(0);
                if (ename instanceof DirectValueActionItem) {
                    catchName = ((DirectValueActionItem)ename).getAsString();
                } else {
                    Logger.getLogger(TryActionItem.class.getName()).log(Level.SEVERE, "Invalid catchName, string expected");
                }
                catchInRegisterFlag = false;
                fullCatchBody = GraphTargetItem.toSourceMerge(localData, generator, this.catchCommands.get(0));
            } else {
                int i;
                catchInRegisterFlag = true;
                catchRegister = asGenerator.getTempRegister(localData);
                boolean allCatched = false;
                for (i = this.catchExceptionNames.size() - 1; i >= 0; --i) {
                    GraphTargetItem etype = this.catchExceptionTypes.get(i);
                    if (etype != null) continue;
                    allCatched = true;
                    break;
                }
                if (!allCatched) {
                    fullCatchBody.addAll(0, GraphTargetItem.toSourceMerge(localData, generator, new ActionPush(new RegisterNumber(catchRegister), charset), new ActionThrow()));
                }
                for (i = this.catchExceptionNames.size() - 1; i >= 0; --i) {
                    GraphTargetItem ename = this.catchExceptionNames.get(i);
                    GraphTargetItem etype = this.catchExceptionTypes.get(i);
                    List<GraphTargetItem> ebody = this.catchCommands.get(i);
                    if (etype == null) {
                        fullCatchBody.addAll(0, GraphTargetItem.toSourceMerge(localData, generator, new DirectValueActionItem(new RegisterNumber(catchRegister)), ename, new ActionStackSwap(charset), new ActionDefineLocal(), ebody));
                        continue;
                    }
                    List<GraphSourceItem> ifBody = GraphTargetItem.toSourceMerge(localData, generator, ename, new ActionStackSwap(charset), new ActionDefineLocal(), ebody);
                    fullCatchBody.add(0, new ActionPop());
                    int toFinishSize = Action.actionsToBytes(asGenerator.toActionList(fullCatchBody), false, 10).length;
                    ActionJump finishJump = new ActionJump(toFinishSize, charset);
                    ifBody.add(finishJump);
                    List<Action> ifBodyA = asGenerator.toActionList(ifBody);
                    int ifBodySize = Action.actionsToBytes(ifBodyA, false, 10).length;
                    fullCatchBody.addAll(0, ifBody);
                    fullCatchBody.addAll(0, GraphTargetItem.toSourceMerge(localData, generator, etype, new ActionPush(new RegisterNumber(catchRegister), charset), new ActionCastOp(), new ActionPushDuplicate(charset), new ActionPush(Null.INSTANCE, charset), new ActionEquals2(), new ActionIf(ifBodySize, charset)));
                }
                asGenerator.releaseTempRegister(localData, catchRegister);
            }
            catchCommandsA = asGenerator.toActionList(fullCatchBody);
            catchSize = Action.actionsToBytes(catchCommandsA, false, 10).length;
            tryCommandsA.add(new ActionJump(catchSize, charset));
        }
        int finallySize = 0;
        if (finallyCommandsA != null) {
            finallySize = Action.actionsToBytes(finallyCommandsA, false, 10).length;
        }
        int trySize = Action.actionsToBytes(tryCommandsA, false, 10).length;
        ret.add(new ActionTry(catchInRegisterFlag, this.finallyCommands != null, !this.catchCommands.isEmpty(), catchName, catchRegister, trySize, catchSize, finallySize, 10, charset));
        ret.addAll(tryCommandsA);
        if (catchCommandsA != null) {
            ret.addAll(catchCommandsA);
        }
        if (finallyCommandsA != null) {
            ret.addAll(finallyCommandsA);
        }
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

