/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class StoreRegisterActionItem
extends ActionItem
implements SetTypeActionItem {
    public RegisterNumber register;
    public boolean define = false;
    public boolean temporary = false;
    public GraphTargetItem compoundValue;
    public String compoundOperator;
    private int tempRegister = -1;

    @Override
    public GraphPart getFirstPart() {
        return this.value.getFirstPart();
    }

    @Override
    public void setValue(GraphTargetItem value) {
        this.value = value;
    }

    @Override
    public int getTempRegister() {
        return this.tempRegister;
    }

    @Override
    public void setTempRegister(int tempRegister) {
        this.tempRegister = tempRegister;
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    public StoreRegisterActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, RegisterNumber register, GraphTargetItem value, boolean define) {
        super(instruction, lineStartIns, 14, value);
        this.register = register;
        this.define = define;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.temporary) {
            this.value.toString(writer, localData);
        } else {
            HighlightData srcData = this.getSrcData();
            srcData.localName = this.register.translate();
            srcData.regIndex = this.register.number;
            if (this.define) {
                srcData.declaration = true;
                srcData.declaredType = DottedChain.ALL;
                writer.append("var ");
            }
            writer.append(IdentifiersDeobfuscation.printIdentifier(false, this.register.translate(), new String[0]));
            if (this.compoundOperator != null) {
                writer.append(" ");
                writer.append(this.compoundOperator);
                writer.append("= ");
                return this.compoundValue.toString(writer, localData);
            }
            writer.append(" = ");
            this.value.toString(writer, localData);
        }
        return writer;
    }

    @Override
    public GraphTargetItem getObject() {
        return new DirectValueActionItem(this.getSrc(), this.getLineStartItem(), -1, this.register, null);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        return StoreRegisterActionItem.toSourceMerge(localData, generator, this.value, new ActionStoreRegister(this.register.number, charset));
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public Object getResult() {
        return this.value.getResult();
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.register);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreRegisterActionItem other = (StoreRegisterActionItem)obj;
        if (!Objects.equals(this.register, other.register)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreRegisterActionItem other = (StoreRegisterActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.register, other.register)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.value, other.value);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public GraphTargetItem getCompoundValue() {
        return this.compoundValue;
    }

    @Override
    public void setCompoundValue(GraphTargetItem value) {
        this.compoundValue = value;
    }

    @Override
    public void setCompoundOperator(String operator) {
        this.compoundOperator = operator;
    }

    @Override
    public String getCompoundOperator() {
        return this.compoundOperator;
    }
}

