/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionGetURL2;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class LoadVariablesActionItem
extends ActionItem {
    private final GraphTargetItem urlString;
    private final GraphTargetItem targetString;
    private final int method;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.urlString);
        visitor.visit(this.targetString);
    }

    public LoadVariablesActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem urlString, GraphTargetItem targetString, int method) {
        super(instruction, lineStartIns, 0);
        this.urlString = urlString;
        this.targetString = targetString;
        this.method = method;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String methodStr = "";
        if (this.method == 1) {
            methodStr = ",\"GET\"";
        }
        if (this.method == 2) {
            methodStr = ",\"POST\"";
        }
        writer.append("loadVariables");
        writer.spaceBeforeCallParenthesies(2);
        writer.append("(");
        this.urlString.toString(writer, localData);
        writer.append(",");
        this.targetString.toString(writer, localData);
        return writer.append(methodStr).append(")");
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return this.toSource(localData, generator, true);
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return this.toSource(localData, generator, false);
    }

    private List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator, boolean needsReturn) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        return LoadVariablesActionItem.toSourceMerge(localData, generator, this.urlString, this.targetString, new ActionGetURL2(this.method, true, true, charset), needsReturn ? new ActionPush(new Object[]{Undefined.INSTANCE, Undefined.INSTANCE}, charset) : null);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Objects.hashCode(this.urlString);
        hash = 13 * hash + Objects.hashCode(this.targetString);
        hash = 13 * hash + this.method;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadVariablesActionItem other = (LoadVariablesActionItem)obj;
        if (this.method != other.method) {
            return false;
        }
        if (!Objects.equals(this.urlString, other.urlString)) {
            return false;
        }
        return Objects.equals(this.targetString, other.targetString);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadVariablesActionItem other = (LoadVariablesActionItem)obj;
        if (this.method != other.method) {
            return false;
        }
        if (!GraphTargetItem.objectsValueEquals(this.urlString, other.urlString)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.targetString, other.targetString);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

