/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf3.ActionGoToLabel;
import com.jpexs.decompiler.flash.action.swf3.ActionGotoFrame;
import com.jpexs.decompiler.flash.action.swf3.ActionPlay;
import com.jpexs.decompiler.flash.action.swf4.ActionGotoFrame2;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class GotoFrame2ActionItem
extends ActionItem {
    public GraphTargetItem frame;
    public boolean sceneBiasFlag;
    public boolean playFlag;
    public int sceneBias;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.frame);
    }

    public GotoFrame2ActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem frame, boolean sceneBiasFlag, boolean playFlag, int sceneBias) {
        super(instruction, lineStartIns, 0);
        this.frame = frame;
        this.sceneBiasFlag = sceneBiasFlag;
        this.playFlag = playFlag;
        this.sceneBias = sceneBias;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String prefix = "gotoAndStop";
        if (this.playFlag) {
            prefix = "gotoAndPlay";
        }
        writer.append(prefix);
        writer.spaceBeforeCallParenthesies(1);
        writer.append("(");
        if (this.sceneBiasFlag) {
            writer.append(this.sceneBias + ", ");
        }
        this.frame.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.frame.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return this.toSource(localData, generator, true);
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return this.toSource(localData, generator, false);
    }

    private List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator, boolean needsReturn) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        if (!this.sceneBiasFlag && this.frame instanceof DirectValueActionItem && ((DirectValueActionItem)this.frame).isString()) {
            return GotoFrame2ActionItem.toSourceMerge(localData, generator, new ActionGoToLabel(((DirectValueActionItem)this.frame).getAsString(), charset), this.playFlag ? new ActionPlay() : null, needsReturn ? new ActionPush(new Object[]{Undefined.INSTANCE, Undefined.INSTANCE}, charset) : null);
        }
        if (!this.sceneBiasFlag && this.frame instanceof DirectValueActionItem && ((DirectValueActionItem)this.frame).value instanceof Long) {
            return GotoFrame2ActionItem.toSourceMerge(localData, generator, new ActionGotoFrame((int)((Long)((DirectValueActionItem)this.frame).value).longValue() - 1, charset), this.playFlag ? new ActionPlay() : null, needsReturn ? new ActionPush(new Object[]{Undefined.INSTANCE, Undefined.INSTANCE}, charset) : null);
        }
        return GotoFrame2ActionItem.toSourceMerge(localData, generator, this.frame, new ActionGotoFrame2(this.playFlag, this.sceneBiasFlag, this.sceneBias, charset), needsReturn ? new ActionPush(new Object[]{Undefined.INSTANCE, Undefined.INSTANCE}, charset) : null);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.frame);
        hash = 67 * hash + (this.sceneBiasFlag ? 1 : 0);
        hash = 67 * hash + (this.playFlag ? 1 : 0);
        hash = 67 * hash + this.sceneBias;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GotoFrame2ActionItem other = (GotoFrame2ActionItem)obj;
        if (this.sceneBiasFlag != other.sceneBiasFlag) {
            return false;
        }
        if (this.playFlag != other.playFlag) {
            return false;
        }
        if (this.sceneBias != other.sceneBias) {
            return false;
        }
        return Objects.equals(this.frame, other.frame);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GotoFrame2ActionItem other = (GotoFrame2ActionItem)obj;
        if (this.sceneBiasFlag != other.sceneBiasFlag) {
            return false;
        }
        if (this.playFlag != other.playFlag) {
            return false;
        }
        if (this.sceneBias != other.sceneBias) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.frame, other.frame);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

