/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.action.ActionScriptFunction;
import com.jpexs.decompiler.flash.action.ActionScriptWith;
import com.jpexs.decompiler.flash.action.Stage;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.Undefined;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class LocalDataArea {
    public List<String> constantPool;
    public Stack<Object> stack = new Stack();
    public List<ActionScriptFunction> functions = new ArrayList<ActionScriptFunction>();
    public Map<String, Object> localVariables = new HashMap<String, Object>();
    public List<ActionScriptWith> withs = new ArrayList<ActionScriptWith>();
    public Map<Integer, Object> localRegisters = new HashMap<Integer, Object>();
    public Object target;
    public Stage stage;
    public Long jump;
    public Object returnValue;
    public String executionException;
    public boolean checkStackSize = true;
    public int undefinedCount = 0;

    public LocalDataArea(Stage stage) {
        this.stage = stage;
        this.target = this.stage;
    }

    public LocalDataArea(Stage stage, boolean preserveVariableOrder) {
        this.stage = stage;
        this.target = this.stage;
        if (preserveVariableOrder) {
            this.localVariables = new LinkedHashMap<String, Object>();
        }
    }

    public boolean stackIsEmpty() {
        if (!this.checkStackSize) {
            return false;
        }
        return this.stack.isEmpty();
    }

    public boolean stackHasMinSize(int count) {
        if (!this.checkStackSize) {
            return true;
        }
        return this.stack.size() >= count;
    }

    public void clear() {
        this.constantPool = null;
        this.stack.clear();
        this.localVariables.clear();
        this.localRegisters.clear();
        this.withs.clear();
        this.functions.clear();
        this.stage.clear();
        this.jump = null;
        this.returnValue = null;
        this.executionException = null;
        this.target = this.stage;
        this.undefinedCount = 0;
    }

    public synchronized Object push(Object val) {
        return this.stack.push(val);
    }

    public synchronized Object peek() {
        if (!this.checkStackSize && this.stack.isEmpty()) {
            ++this.undefinedCount;
            this.stack.push(Undefined.INSTANCE);
            return Undefined.INSTANCE;
        }
        return this.stack.peek();
    }

    public synchronized Object pop() {
        boolean isEmpty = this.stack.isEmpty();
        if (!this.checkStackSize && this.stack.isEmpty()) {
            ++this.undefinedCount;
            return Undefined.INSTANCE;
        }
        return this.stack.pop();
    }

    public synchronized Double popAsNumber() {
        return EcmaScript.toNumberAs2(this.pop());
    }

    public synchronized String popAsString() {
        return EcmaScript.toString(this.pop());
    }
}

