/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraph;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartChangeException;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionGraphSource
extends GraphSource {
    private final ActionList actions;
    public int version;
    private final HashMap<Integer, String> registerNames;
    private final HashMap<String, GraphTargetItem> variables;
    private final HashMap<String, GraphTargetItem> functions;
    private final boolean insideDoInitAction;
    private final String path;
    private String charset;
    private List<Long> posCache = null;

    public List<Action> getActions() {
        return this.actions;
    }

    public ActionGraphSource(String path, boolean insideDoInitAction, List<Action> actions, int version, HashMap<Integer, String> registerNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, String charset) {
        this.actions = actions instanceof ActionList ? (ActionList)actions : new ActionList(actions, charset);
        this.version = version;
        this.registerNames = registerNames;
        this.variables = variables;
        this.functions = functions;
        this.insideDoInitAction = insideDoInitAction;
        this.path = path;
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public Set<Long> getImportantAddresses() {
        return Action.getActionsAllRefs(this.actions);
    }

    @Override
    public String insToString(int pos) {
        if (pos < this.actions.size()) {
            return ((Action)this.actions.get(pos)).getASMSource(this.actions, this.getImportantAddresses(), ScriptExportMode.PCODE);
        }
        return "";
    }

    @Override
    public int size() {
        return this.actions.size();
    }

    @Override
    public GraphSourceItem get(int pos) {
        return (GraphSourceItem)this.actions.get(pos);
    }

    public void set(int pos, Action t) {
        this.actions.set(pos, t);
    }

    @Override
    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    @Override
    public List<GraphTargetItem> translatePart(Graph graph, GraphPart part, BaseLocalData localData, TranslateStack stack, int start, int end, int staticOperation, String path) throws InterruptedException, GraphPartChangeException {
        Reference<GraphSourceItem> fi = new Reference<GraphSourceItem>(localData.lineStartInstruction);
        List<GraphTargetItem> r = Action.actionsPartToTree((ActionGraph)graph, localData.allSwitchParts, localData.secondPassData, this.insideDoInitAction, fi, this.registerNames, this.variables, this.functions, stack, this.actions, start, end, this.version, staticOperation, path, this.charset);
        localData.lineStartInstruction = fi.getVal();
        return r;
    }

    private void rebuildCache() {
        this.posCache = new ArrayList<Long>();
        for (int i = 0; i < this.size(); ++i) {
            this.posCache.add(this.pos2adr(i));
        }
    }

    @Override
    public int adr2pos(long adr) {
        if (this.posCache == null) {
            this.rebuildCache();
        }
        if (adr == 0L) {
            return 0;
        }
        int ret = this.posCache.indexOf(adr);
        if (ret == -1) {
            if (!this.posCache.isEmpty() && adr > this.posCache.get(this.posCache.size() - 1)) {
                return this.size();
            }
            if (ret == -1) {
                Logger.getLogger(ActionGraphSource.class.getName()).log(Level.SEVERE, "{0} - address loc{1} not found", new Object[]{this.path, Helper.formatAddress(adr)});
            }
        }
        return ret;
    }

    @Override
    public long pos2adr(int pos) {
        GraphSourceItem si = (GraphSourceItem)this.actions.get(pos);
        if (si instanceof Action) {
            return ((Action)si).getAddress();
        }
        return 0L;
    }

    @Override
    public int adr2pos(long adr, boolean nearest) {
        if (this.posCache == null) {
            this.rebuildCache();
        }
        if (adr == 0L) {
            return 0;
        }
        int ret = this.posCache.indexOf(adr);
        if (ret == -1) {
            if (!this.posCache.isEmpty() && adr > this.posCache.get(this.posCache.size() - 1)) {
                return this.size();
            }
            for (int i = 0; i < this.posCache.size(); ++i) {
                Long a = this.posCache.get(i);
                if (a <= adr) continue;
                return i;
            }
            return this.size();
        }
        return ret;
    }

    public HashMap<String, GraphTargetItem> getVariables() {
        return this.variables;
    }
}

