/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionPop;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionReturn;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class ActionDefineFunctionPushRegistersCleaner
extends SWFDecompilerAdapter {
    @Override
    public void actionListParsed(ActionList actions, SWF swf) throws InterruptedException {
        this.cleanActionDefineFunctions(actions);
    }

    private void cleanActionDefineFunctions(ActionList actions) {
        for (int i = actions.size() - 1; i >= 0; --i) {
            Action action = (Action)actions.get(i);
            if (!(action instanceof ActionDefineFunction)) continue;
            ActionDefineFunction def = (ActionDefineFunction)action;
            List<Long> sizes = def.getContainerSizes();
            long endAddress = action.getAddress() + def.getHeaderSize() + sizes.get(0);
            int lastIndex = actions.getIndexByAddress(endAddress);
            int startIndex = i + 1;
            int count = lastIndex - startIndex;
            this.cleanPushRegisters(actions, startIndex, count);
        }
    }

    private boolean cleanPushRegisters(ActionList code, int startIndex, int count) {
        int posBeforeFinishPart;
        RegisterNumber rn;
        if (count == 0) {
            return false;
        }
        ArrayList<Integer> pushedRegisters = new ArrayList<Integer>();
        int pos = startIndex;
        block0: while (code.get(pos) instanceof ActionPush) {
            ActionPush ap = (ActionPush)code.get(pos);
            for (int i = 0; i < ap.values.size(); ++i) {
                if (!(ap.values.get(i) instanceof RegisterNumber)) break block0;
                rn = (RegisterNumber)ap.values.get(i);
                pushedRegisters.add(rn.number);
            }
            if (++pos < code.size()) continue;
            return false;
        }
        if (pushedRegisters.isEmpty()) {
            return false;
        }
        int returnReg = -1;
        pos = startIndex + count - 1;
        if (code.get(pos) instanceof ActionReturn) {
            if (--pos < startIndex) {
                return false;
            }
            if (!(code.get(pos) instanceof ActionPush)) {
                return false;
            }
            ActionPush pu = (ActionPush)code.get(pos);
            if (pu.values.size() != 1) {
                return false;
            }
            if (!(pu.values.get(0) instanceof RegisterNumber)) {
                return false;
            }
            rn = (RegisterNumber)pu.values.get(0);
            returnReg = rn.number;
            if (--pos < startIndex) {
                return false;
            }
        }
        for (int i = 0; i < pushedRegisters.size(); ++i) {
            if (!(code.get(pos) instanceof ActionPop)) {
                return false;
            }
            if (--pos < startIndex) {
                return false;
            }
            if (!(code.get(pos) instanceof ActionStoreRegister)) {
                return false;
            }
            ActionStoreRegister asr = (ActionStoreRegister)code.get(pos);
            int expectedReg = (Integer)pushedRegisters.get(i);
            if (asr.registerNumber != expectedReg) {
                return false;
            }
            if (--pos >= startIndex) continue;
            return false;
        }
        TreeSet<Integer> jumpsToReturnPositions = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        });
        Action actionBeforeFinishPart = null;
        if (returnReg > -1) {
            if (!(code.get(pos) instanceof ActionPop)) {
                return false;
            }
            if (--pos < startIndex) {
                return false;
            }
            if (!(code.get(pos) instanceof ActionStoreRegister)) {
                return false;
            }
            ActionStoreRegister asr = (ActionStoreRegister)code.get(pos);
            int expectedReg = returnReg;
            if (asr.registerNumber != expectedReg) {
                return false;
            }
            ActionStoreRegister actionWithRefs = asr;
            if (code.get(pos - 1) instanceof ActionJump && ((ActionJump)code.get(pos - 1)).getJumpOffset() == 0) {
                Iterator<Action> zit = code.getReferencesFor((Action)code.get(pos));
                int refCnt = 0;
                while (zit.hasNext()) {
                    zit.next();
                    ++refCnt;
                }
                if (refCnt == 1) {
                    actionWithRefs = (Action)code.get(pos - 1);
                    --pos;
                }
            }
            Iterator<Action> ait = code.getReferencesFor(actionWithRefs);
            while (ait.hasNext()) {
                Action a = ait.next();
                if (!(a instanceof ActionJump)) {
                    return false;
                }
                jumpsToReturnPositions.add(code.indexOf(a));
            }
            if (!(code.get(--pos) instanceof ActionJump)) {
                actionBeforeFinishPart = (Action)code.get(pos);
            }
            posBeforeFinishPart = pos;
        } else {
            posBeforeFinishPart = pos;
        }
        for (Integer jp : jumpsToReturnPositions) {
            int index = jp;
            code.removeAction(index);
            code.addAction(index, new ActionReturn());
        }
        if (returnReg > -1 && actionBeforeFinishPart != null) {
            if (actionBeforeFinishPart instanceof ActionPush && ((ActionPush)actionBeforeFinishPart).values.size() == 1 && ((ActionPush)actionBeforeFinishPart).values.get(0) == Undefined.INSTANCE) {
                code.removeAction(posBeforeFinishPart);
                --posBeforeFinishPart;
                --count;
            } else if (!(actionBeforeFinishPart instanceof ActionReturn) && !(actionBeforeFinishPart instanceof ActionJump)) {
                code.addAction(++posBeforeFinishPart, new ActionReturn());
                ++count;
            }
        }
        int removeStartIndex = posBeforeFinishPart + 1;
        int removeCount = startIndex + count - removeStartIndex;
        code.removeAction(removeStartIndex, removeCount);
        pos = startIndex;
        int registersLeft = pushedRegisters.size();
        while (code.get(pos) instanceof ActionPush) {
            ActionPush currentPush = (ActionPush)code.get(pos);
            List<Object> currentPushedValues = currentPush.values;
            ArrayList<Object> newPushedValues = new ArrayList<Object>();
            for (int i = 0; i < currentPushedValues.size(); ++i) {
                if (registersLeft > 0 && currentPushedValues.get(i) instanceof RegisterNumber) {
                    --registersLeft;
                    continue;
                }
                newPushedValues.add(currentPushedValues.get(i));
            }
            if (newPushedValues.size() != currentPushedValues.size()) {
                code.removeAction(pos);
                if (!newPushedValues.isEmpty()) {
                    ActionPush newPush = new ActionPush(newPushedValues.toArray(), code.getCharset());
                    newPush.constantPool = currentPush.constantPool;
                    code.addAction(pos, newPush);
                } else {
                    --pos;
                }
            }
            if (registersLeft == 0) break;
            ++pos;
        }
        return true;
    }
}

