/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types.traits;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitWithSlot;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyParser;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TraitFunction
extends Trait
implements TraitWithSlot {
    public int slot_id;
    public int method_info;

    @Override
    public void delete(ABC abc, boolean d) {
        abc.constants.getMultiname((int)this.name_index).deleted = d;
        abc.method_info.get(this.method_info).delete(abc, d);
    }

    @Override
    public int getSlotIndex() {
        return this.slot_id;
    }

    @Override
    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        return "Function " + abc.constants.getMultiname(this.name_index).toString(abc.constants, fullyQualifiedNames) + " slot=" + this.slot_id + " method_info=" + this.method_info + " metadata=" + Helper.intArrToString(this.metadata);
    }

    @Override
    public GraphTextWriter toStringHeader(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, boolean insideInterface) {
        MethodBody body = abc.findBody(this.method_info);
        if (body == null) {
            writer.appendNoHilight("native ");
        }
        this.getModifiers(abc, isStatic, insideInterface, writer);
        writer.hilightSpecial("function ", HighlightSpecialType.TRAIT_TYPE);
        writer.hilightSpecial(abc.constants.getMultiname(this.name_index).getName(abc.constants, fullyQualifiedNames, false, true), HighlightSpecialType.TRAIT_NAME);
        writer.appendNoHilight("(");
        abc.method_info.get(this.method_info).getParamStr(writer, abc.constants, body, abc, fullyQualifiedNames);
        writer.appendNoHilight(") : ");
        abc.method_info.get(this.method_info).getReturnTypeStr(writer, abc.constants, fullyQualifiedNames);
        return writer;
    }

    @Override
    public void convertHeader(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel) {
    }

    @Override
    public GraphTextWriter toString(AbcIndexing abcIndex, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, boolean insideInterface) throws InterruptedException {
        this.writeImports(abcIndex, scriptIndex, classIndex, false, abc, writer, this.getPackage(abc), fullyQualifiedNames);
        this.getMetaData(parent, convertData, abc, writer);
        writer.startMethod(this.method_info);
        this.toStringHeader(parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel, insideInterface);
        writer.startBlock();
        int bodyIndex = abc.findBodyIndex(this.method_info);
        if (bodyIndex != -1) {
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
            callStack.add(abc.bodies.get(bodyIndex));
            abc.bodies.get(bodyIndex).toString(callStack, abcIndex, path + "." + abc.constants.getMultiname(this.name_index).getName(abc.constants, fullyQualifiedNames, false, true), exportMode, abc, this, writer, fullyQualifiedNames, new HashSet<Integer>());
        }
        writer.endBlock();
        writer.newLine();
        writer.endMethod();
        return writer;
    }

    @Override
    public void convert(AbcIndexing abcIndex, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, ScopeStack scopeStack) throws InterruptedException {
        fullyQualifiedNames = new ArrayList<DottedChain>();
        this.writeImports(abcIndex, scriptIndex, classIndex, false, abc, writer, this.getPackage(abc), fullyQualifiedNames);
        writer.startMethod(this.method_info);
        this.convertHeader(parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel);
        int bodyIndex = abc.findBodyIndex(this.method_info);
        if (bodyIndex != -1) {
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
            callStack.add(abc.bodies.get(bodyIndex));
            abc.bodies.get(bodyIndex).convert(callStack, abcIndex, convertData, path + "." + abc.constants.getMultiname(this.name_index).getName(abc.constants, fullyQualifiedNames, false, true), exportMode, isStatic, this.method_info, scriptIndex, classIndex, abc, this, scopeStack, 0, writer, fullyQualifiedNames, null, true, new HashSet<Integer>());
        }
        writer.endMethod();
    }

    @Override
    public int removeTraps(int scriptIndex, int classIndex, boolean isStatic, ABC abc, String path) throws InterruptedException {
        int bodyIndex = abc.findBodyIndex(this.method_info);
        if (bodyIndex != -1) {
            return abc.bodies.get(bodyIndex).removeTraps(abc, this, scriptIndex, classIndex, isStatic, path);
        }
        return 0;
    }

    @Override
    public TraitFunction clone() {
        TraitFunction ret = (TraitFunction)super.clone();
        return ret;
    }

    @Override
    public void getDependencies(AbcIndexing abcIndex, int scriptIndex, int classIndex, boolean isStatic, String customNs, ABC abc, List<Dependency> dependencies, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames) throws InterruptedException {
        if (ignorePackage == null) {
            ignorePackage = this.getPackage(abc);
        }
        super.getDependencies(abcIndex, scriptIndex, classIndex, false, customNs, abc, dependencies, ignorePackage, fullyQualifiedNames);
        DependencyParser.parseDependenciesFromMethodInfo(abcIndex, this, scriptIndex, classIndex, false, customNs, abc, this.method_info, dependencies, ignorePackage, fullyQualifiedNames, new ArrayList<Integer>());
    }

    @Override
    public GraphTextWriter convertTraitHeader(ABC abc, GraphTextWriter writer) {
        this.convertCommonHeaderFlags("function", abc, writer);
        writer.newLine();
        writer.appendNoHilight("slotid ");
        writer.hilightSpecial(Integer.toString(this.slot_id), HighlightSpecialType.SLOT_ID);
        writer.newLine();
        return writer;
    }

    @Override
    public void getMethodInfos(ABC abc, int traitId, int classIndex, List<MethodId> methodInfos) {
        methodInfos.add(new MethodId(traitId, classIndex, this.method_info));
    }
}

