/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScriptInfo {
    @Internal
    private boolean modified = true;
    @Internal
    public boolean deleted;
    public int init_index;
    public Traits traits;
    private List<ScriptPack> cachedPacks;

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public ScriptInfo() {
        this.traits = new Traits();
    }

    public ScriptInfo(Traits traits) {
        this.traits = traits;
    }

    public void clearPacksCache() {
        this.cachedPacks = null;
    }

    public DottedChain getSimplePackName(ABC abc) {
        ArrayList<Integer> packageTraits = new ArrayList<Integer>();
        for (int j = 0; j < this.traits.traits.size(); ++j) {
            Trait t = this.traits.traits.get(j);
            Multiname name = t.getName(abc);
            Namespace ns = name.getNamespace(abc.constants);
            if (ns.kind != 23 && ns.kind != 22) continue;
            packageTraits.add(j);
        }
        if (packageTraits.isEmpty() || packageTraits.size() > 1) {
            return null;
        }
        return this.traits.traits.get((Integer)packageTraits.get(0)).getName(abc).getNameWithNamespace(abc.constants, true);
    }

    public List<ScriptPack> getPacks(ABC abc, int scriptIndex, String packagePrefix, List<ABC> allAbcs) {
        Namespace ns;
        Multiname name;
        Trait t;
        int j;
        if (packagePrefix == null && this.cachedPacks != null) {
            return new ArrayList<ScriptPack>(this.cachedPacks);
        }
        ArrayList<ScriptPack> ret = new ArrayList<ScriptPack>();
        ArrayList<Integer> otherTraits = new ArrayList<Integer>();
        for (j = 0; j < this.traits.traits.size(); ++j) {
            t = this.traits.traits.get(j);
            name = t.getName(abc);
            ns = name.getNamespace(abc.constants);
            if (ns.kind == 23 || ns.kind == 22) continue;
            otherTraits.add(j);
        }
        for (j = 0; j < this.traits.traits.size(); ++j) {
            t = this.traits.traits.get(j);
            name = t.getName(abc);
            ns = name.getNamespace(abc.constants);
            if (ns.kind != 23 && ns.kind != 22) continue;
            DottedChain packageName = ns.getName(abc.constants);
            String objectName = name.getName(abc.constants, null, true, false);
            String namespaceSuffix = name.getNamespaceSuffix();
            ArrayList<Integer> traitIndices = new ArrayList<Integer>();
            traitIndices.add(j);
            if (!otherTraits.isEmpty()) {
                traitIndices.addAll(otherTraits);
                otherTraits.clear();
            }
            if (packagePrefix != null && !packageName.toPrintableString(true).startsWith(packagePrefix)) continue;
            ClassPath cp = new ClassPath(packageName, objectName, namespaceSuffix);
            ret.add(new ScriptPack(cp, abc, allAbcs, scriptIndex, traitIndices));
        }
        if (ret.size() == 1) {
            ((ScriptPack)ret.get((int)0)).isSimple = true;
        }
        if (ret.isEmpty() && !otherTraits.isEmpty()) {
            Iterator iterator = otherTraits.iterator();
            while (iterator.hasNext()) {
                int traitIndex = (Integer)iterator.next();
                Trait t2 = this.traits.traits.get(traitIndex);
                Multiname name2 = t2.getName(abc);
                Namespace ns2 = name2.getNamespace(abc.constants);
                DottedChain packageName = ns2.getName(abc.constants);
                String objectName = name2.getName(abc.constants, null, true, false);
                String namespaceSuffix = name2.getNamespaceSuffix();
                ArrayList<Integer> traitIndices = new ArrayList<Integer>();
                traitIndices.add(traitIndex);
                ClassPath cp = new ClassPath(packageName, objectName, namespaceSuffix);
                ret.add(new ScriptPack(cp, abc, allAbcs, scriptIndex, traitIndices));
            }
        }
        if (packagePrefix == null) {
            this.cachedPacks = new ArrayList<ScriptPack>(ret);
        }
        return ret;
    }

    public int removeTraps(int scriptIndex, ABC abc, String path) throws InterruptedException {
        return this.traits.removeTraps(scriptIndex, -1, true, abc, path);
    }

    public String toString() {
        return "method_index=" + this.init_index + "\r\n" + this.traits.toString();
    }

    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        return "method_index=" + this.init_index + "\r\n" + this.traits.toString(abc, fullyQualifiedNames);
    }

    public void delete(ABC abc, boolean d) {
        this.deleted = d;
        abc.method_info.get(this.init_index).delete(abc, d);
        this.traits.delete(abc, d);
        if (d) {
            this.clearPacksCache();
        }
    }
}

