/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodInfo {
    @Internal
    public boolean deleted;
    public int[] param_types = new int[0];
    public int ret_type;
    public int name_index;
    public static int FLAG_NEED_ARGUMENTS = 1;
    public static int FLAG_NEED_ACTIVATION = 2;
    public static int FLAG_NEED_REST = 4;
    public static int FLAG_HAS_OPTIONAL = 8;
    public static int FLAG_IGNORE_REST = 16;
    public static int FLAG_NATIVE = 32;
    public static int FLAG_SETSDXNS = 64;
    public static int FLAG_HAS_PARAMNAMES = 128;
    public int flags;
    public ValueKind[] optional = new ValueKind[0];
    public int[] paramNames = new int[0];

    public void delete(ABC abc, boolean d) {
        this.deleted = d;
        MethodBody body = abc.findBody(this);
        if (body != null) {
            for (AVM2Instruction ins : body.getCode().code) {
                if (!(ins.definition instanceof NewFunctionIns) || ins.operands[0] >= abc.method_info.size() || abc.method_info.get((int)ins.operands[0]).deleted) continue;
                abc.method_info.get(ins.operands[0]).delete(abc, d);
            }
        }
    }

    public void setFlagIgnore_Rest() {
        this.flags |= FLAG_IGNORE_REST;
    }

    public void setFlagNative() {
        this.flags |= FLAG_NATIVE;
    }

    public void setFlagNeed_Arguments() {
        this.flags |= FLAG_NEED_ARGUMENTS;
    }

    public void setFlagSetsdxns() {
        this.flags |= FLAG_SETSDXNS;
    }

    public void setFlagSetsdxns(boolean val) {
        if (val) {
            this.setFlagSetsdxns();
        } else {
            this.unsetFlagSetsdxns();
        }
    }

    public void unsetFlagSetsdxns() {
        if (this.flagSetsdxns()) {
            this.flags -= FLAG_SETSDXNS;
        }
    }

    public void setFlagNeed_activation() {
        this.flags |= FLAG_NEED_ACTIVATION;
    }

    public void setFlagNeed_activation(boolean val) {
        if (val) {
            this.setFlagNeed_activation();
        } else {
            this.unsetFlagNeed_activation();
        }
    }

    public void unsetFlagNeed_activation() {
        if (this.flagNeed_activation()) {
            this.flags -= FLAG_NEED_ACTIVATION;
        }
    }

    public void setFlagNeed_rest() {
        this.flags |= FLAG_NEED_REST;
    }

    public void unsetFlagNeed_rest() {
        if (this.flagNeed_rest()) {
            this.flags -= FLAG_NEED_REST;
        }
    }

    public void setFlagNeed_rest(boolean val) {
        if (val) {
            this.setFlagNeed_rest();
        } else {
            this.unsetFlagNeed_rest();
        }
    }

    public void setFlagHas_optional() {
        this.flags |= FLAG_HAS_OPTIONAL;
    }

    public void unsetFlagHas_optional() {
        if (this.flagHas_optional()) {
            this.flags -= FLAG_HAS_OPTIONAL;
        }
    }

    public void setFlagHas_optional(boolean val) {
        if (val) {
            this.setFlagHas_optional();
        } else {
            this.unsetFlagHas_optional();
        }
    }

    public void setFlagHas_paramnames() {
        this.flags |= FLAG_HAS_PARAMNAMES;
    }

    public void unsetFlagHas_paramnames() {
        if (this.flagHas_paramnames()) {
            this.flags -= FLAG_HAS_PARAMNAMES;
        }
    }

    public void setFlagHas_paramnames(boolean val) {
        if (val) {
            this.setFlagHas_paramnames();
        } else {
            this.unsetFlagHas_paramnames();
        }
    }

    public boolean flagNeed_arguments() {
        return (this.flags & FLAG_NEED_ARGUMENTS) == FLAG_NEED_ARGUMENTS;
    }

    public boolean flagNeed_activation() {
        return (this.flags & FLAG_NEED_ACTIVATION) == FLAG_NEED_ACTIVATION;
    }

    public boolean flagNeed_rest() {
        return (this.flags & FLAG_NEED_REST) == FLAG_NEED_REST;
    }

    public boolean flagHas_optional() {
        return (this.flags & FLAG_HAS_OPTIONAL) == FLAG_HAS_OPTIONAL;
    }

    public boolean flagIgnore_rest() {
        return (this.flags & FLAG_IGNORE_REST) == FLAG_IGNORE_REST;
    }

    public boolean flagNative() {
        return (this.flags & FLAG_NATIVE) == FLAG_NATIVE;
    }

    public boolean flagSetsdxns() {
        return (this.flags & FLAG_SETSDXNS) == FLAG_SETSDXNS;
    }

    public boolean flagHas_paramnames() {
        return (this.flags & FLAG_HAS_PARAMNAMES) == FLAG_HAS_PARAMNAMES;
    }

    public MethodInfo() {
    }

    public MethodInfo(int[] param_types, int ret_type, int name_index, int flags, ValueKind[] optional, int[] paramNames) {
        this.param_types = param_types;
        this.ret_type = ret_type;
        this.name_index = name_index;
        this.flags = flags;
        this.optional = optional;
        this.paramNames = paramNames;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("MethodInfo: param_types=");
        Helper.intArrToStringBuilder(this.param_types, ret);
        ret.append(" ret_type=").append(this.ret_type).append(" name_index=").append(this.name_index).append(" flags=").append(this.flags).append(" optional=[");
        if (this.optional != null) {
            for (int i = 0; i < this.optional.length; ++i) {
                if (i > 0) {
                    ret.append(",");
                }
                ret.append(this.optional[i].toString());
            }
        }
        ret.append("]");
        ret.append(" paramNames=");
        Helper.intArrToStringBuilder(this.paramNames, ret);
        return ret.toString();
    }

    public String toString(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        StringBuilder optionalStr = new StringBuilder();
        optionalStr.append("[");
        if (this.optional != null) {
            for (int i = 0; i < this.optional.length; ++i) {
                if (i > 0) {
                    optionalStr.append(",");
                }
                optionalStr.append(this.optional[i].toString(constants));
            }
        }
        optionalStr.append("]");
        StringBuilder param_typesStr = new StringBuilder();
        for (int i = 0; i < this.param_types.length; ++i) {
            if (i > 0) {
                param_typesStr.append(",");
            }
            if (this.param_types[i] == 0) {
                param_typesStr.append("*");
                continue;
            }
            param_typesStr.append(constants.getMultiname(this.param_types[i]).toString(constants, fullyQualifiedNames));
        }
        StringBuilder paramNamesStr = new StringBuilder();
        for (int i = 0; i < this.paramNames.length; ++i) {
            if (i > 0) {
                paramNamesStr.append(",");
            }
            paramNamesStr.append(constants.getString(this.paramNames[i]));
        }
        String ret_typeStr = this.ret_type == 0 ? "*" : constants.getMultiname(this.ret_type).toString(constants, fullyQualifiedNames);
        return "param_types=" + param_typesStr + " ret_type=" + ret_typeStr + " name=\"" + constants.getString(this.name_index) + "\" flags=" + this.flags + " optional=" + optionalStr + " paramNames=" + paramNamesStr;
    }

    public String getName(AVM2ConstantPool constants) {
        if (this.name_index == 0) {
            return "UNKNOWN";
        }
        return constants.getString(this.name_index);
    }

    public int getMaxReservedReg() {
        return this.param_types.length + (this.flagNeed_rest() ? 1 : 0) + (this.flagNeed_arguments() ? 1 : 0);
    }

    public GraphTextWriter getParamStr(GraphTextWriter writer, AVM2ConstantPool constants, MethodBody body, ABC abc, List<DottedChain> fullyQualifiedNames) {
        HighlightData pdata;
        Map<Object, Object> localRegNames = new HashMap();
        if (body != null && Configuration.getLocalNamesFromDebugInfo.get().booleanValue()) {
            localRegNames = body.getCode().getLocalRegNamesFromDebug(abc);
        }
        for (int i = 0; i < this.param_types.length; ++i) {
            if (i > 0) {
                writer.appendNoHilight(", ");
            }
            DottedChain ptype = DottedChain.ALL;
            if (this.param_types[i] > 0) {
                ptype = constants.getMultiname(this.param_types[i]).getNameWithNamespace(constants, true);
            }
            pdata = new HighlightData();
            pdata.declaration = true;
            pdata.declaredType = ptype;
            pdata.regIndex = i + 1;
            if (!localRegNames.isEmpty()) {
                pdata.localName = (String)localRegNames.get(i + 1);
                writer.hilightSpecial(IdentifiersDeobfuscation.printIdentifier(true, (String)localRegNames.get(i + 1), new String[0]), HighlightSpecialType.PARAM_NAME, i, pdata);
            } else if (this.paramNames.length > i && this.paramNames[i] != 0 && Configuration.paramNamesEnable.get().booleanValue()) {
                pdata.localName = constants.getString(this.paramNames[i]);
                writer.hilightSpecial(IdentifiersDeobfuscation.printIdentifier(true, constants.getString(this.paramNames[i]), new String[0]), HighlightSpecialType.PARAM_NAME, i, pdata);
            } else {
                pdata.localName = "param" + (i + 1);
                writer.hilightSpecial(pdata.localName, HighlightSpecialType.PARAM_NAME, i, pdata);
            }
            writer.appendNoHilight(":");
            if (this.param_types[i] == 0) {
                writer.hilightSpecial("*", HighlightSpecialType.PARAM, i);
            } else {
                writer.hilightSpecial(constants.getMultiname(this.param_types[i]).getName(constants, fullyQualifiedNames, false, true), HighlightSpecialType.PARAM, i);
            }
            if (this.optional == null || !this.flagHas_optional() || i < this.param_types.length - this.optional.length) continue;
            int optionalIndex = i - (this.param_types.length - this.optional.length);
            writer.appendNoHilight(" = ");
            writer.hilightSpecial(this.optional[optionalIndex].toString(constants), HighlightSpecialType.OPTIONAL, optionalIndex);
        }
        if (this.flagNeed_rest()) {
            String restAdd = "";
            if (this.param_types != null && this.param_types.length > 0) {
                restAdd = ", ";
            }
            restAdd = restAdd + "... ";
            String restName = !localRegNames.isEmpty() ? (String)localRegNames.get(this.param_types.length + 1) : "rest";
            pdata = new HighlightData();
            pdata.declaration = true;
            pdata.declaredType = DottedChain.ALL;
            pdata.regIndex = this.param_types.length + 1;
            pdata.localName = restName;
            writer.append(restAdd);
            writer.hilightSpecial(restName, HighlightSpecialType.FLAG_NEED_REST, 0, pdata);
        }
        return writer;
    }

    public GraphTextWriter getReturnTypeStr(GraphTextWriter writer, AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        String rname = "*";
        if (this.ret_type > 0) {
            Multiname multiname = constants.getMultiname(this.ret_type);
            rname = multiname.kind != 29 && multiname.name_index > 0 && constants.getString(multiname.name_index).equals("void") ? "void" : multiname.getName(constants, fullyQualifiedNames, false, true);
        }
        return writer.hilightSpecial(rname, HighlightSpecialType.RETURNS);
    }

    public String getReturnTypeRaw(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        String rname = "*";
        if (this.ret_type > 0) {
            Multiname multiname = constants.getMultiname(this.ret_type);
            rname = multiname.kind != 29 && multiname.name_index > 0 && constants.getString(multiname.name_index).equals("void") ? "void" : multiname.getName(constants, fullyQualifiedNames, false, true);
        }
        return rname;
    }

    public void toASMSource(AVM2ConstantPool constants, GraphTextWriter writer) {
        writer.appendNoHilight("name ");
        writer.hilightSpecial(this.name_index == 0 ? "null" : "\"" + Helper.escapeActionScriptString(this.getName(constants)) + "\"", HighlightSpecialType.METHOD_NAME);
        writer.newLine();
        if (this.flagNative()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("NATIVE", HighlightSpecialType.FLAG_NATIVE);
            writer.newLine();
        }
        if (this.flagHas_optional()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("HAS_OPTIONAL", HighlightSpecialType.FLAG_HAS_OPTIONAL);
            writer.newLine();
        }
        if (this.flagHas_paramnames()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("HAS_PARAM_NAMES", HighlightSpecialType.FLAG_HAS_PARAM_NAMES);
            writer.newLine();
        }
        if (this.flagIgnore_rest()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("IGNORE_REST", HighlightSpecialType.FLAG_IGNORE_REST);
            writer.newLine();
        }
        if (this.flagNeed_activation()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("NEED_ACTIVATION", HighlightSpecialType.FLAG_NEED_ACTIVATION);
            writer.newLine();
        }
        if (this.flagNeed_arguments()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("NEED_ARGUMENTS", HighlightSpecialType.FLAG_NEED_ARGUMENTS);
            writer.newLine();
        }
        if (this.flagNeed_rest()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("NEED_REST", HighlightSpecialType.FLAG_NEED_REST);
            writer.newLine();
        }
        if (this.flagSetsdxns()) {
            writer.appendNoHilight("flag ");
            writer.hilightSpecial("SET_DXNS", HighlightSpecialType.FLAG_SET_DXNS);
            writer.newLine();
        }
        for (int p = 0; p < this.param_types.length; ++p) {
            writer.appendNoHilight("param ");
            writer.hilightSpecial(constants.multinameToString(this.param_types[p]), HighlightSpecialType.PARAM, p);
            writer.newLine();
        }
        if (this.flagHas_paramnames()) {
            for (int n : this.paramNames) {
                writer.appendNoHilight("paramname ");
                if (n == 0) {
                    writer.appendNoHilight("null");
                } else {
                    writer.appendNoHilight("\"");
                    writer.appendNoHilight(constants.getString(n));
                    writer.appendNoHilight("\"");
                }
                writer.newLine();
            }
        }
        if (this.flagHas_optional()) {
            for (int i = 0; i < this.optional.length; ++i) {
                ValueKind vk = this.optional[i];
                writer.appendNoHilight("optional ");
                writer.hilightSpecial(vk.toASMString(constants), HighlightSpecialType.OPTIONAL, i);
                writer.newLine();
            }
        }
        writer.appendNoHilight("returns ");
        writer.hilightSpecial(constants.multinameToString(this.ret_type), HighlightSpecialType.RETURNS);
        writer.newLine();
    }
}

