/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCInputStream;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.CodeStats;
import com.jpexs.decompiler.flash.abc.avm2.UnknownInstructionCode;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.DeobfuscationLevel;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.stat.Statistics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MethodBody
implements Cloneable {
    private static final Logger logger = Logger.getLogger(MethodBody.class.getName());
    private static final String DEBUG_FIXED = null;
    @Internal
    public boolean deleted;
    @Internal
    boolean debugMode = false;
    public int method_info;
    public int max_stack;
    public int max_regs;
    public int init_scope_depth;
    public int max_scope_depth;
    @SWFField
    private byte[] codeBytes;
    private AVM2Code code;
    public ABCException[] exceptions;
    public Traits traits;
    @Internal
    public transient List<GraphTargetItem> convertedItems;
    @Internal
    public transient Throwable convertException;
    @Internal
    private ABC abc;
    @Internal
    private transient MethodBody lastConvertedBody = null;

    public MethodBody() {
        this.traits = new Traits();
        this.codeBytes = SWFInputStream.BYTE_ARRAY_EMPTY;
        this.exceptions = new ABCException[0];
        this.abc = null;
    }

    public void setAbc(ABC abc) {
        this.abc = abc;
    }

    public MethodBody(ABC abc, Traits traits, byte[] codeBytes, ABCException[] exceptions) {
        this.traits = traits;
        this.codeBytes = codeBytes;
        this.exceptions = exceptions;
        this.abc = abc;
    }

    public synchronized void setCodeBytes(byte[] codeBytes) {
        this.codeBytes = codeBytes;
        this.code = null;
    }

    public void setModified() {
        this.codeBytes = null;
    }

    public synchronized byte[] getCodeBytes() {
        if (this.codeBytes != null) {
            return this.codeBytes;
        }
        return this.code.getBytes();
    }

    public synchronized AVM2Code getCode() {
        if (this.code == null) {
            AVM2Code avm2Code;
            try {
                ABCInputStream ais = new ABCInputStream(new MemoryInputStream(this.codeBytes));
                avm2Code = new AVM2Code(ais, this);
                avm2Code.removeWrongIndices(this.abc.constants);
            }
            catch (UnknownInstructionCode | IOException ex) {
                avm2Code = new AVM2Code();
                logger.log(Level.SEVERE, null, ex);
            }
            avm2Code.compact();
            this.code = avm2Code;
        }
        return this.code;
    }

    public void setCode(AVM2Code code) {
        this.code = code;
        this.codeBytes = null;
    }

    public void markOffsets() {
        this.getCode().markOffsets();
    }

    public String toString() {
        String s = "";
        s = s + "method_info=" + this.method_info + " max_stack=" + this.max_stack + " max_regs=" + this.max_regs + " scope_depth=" + this.init_scope_depth + " max_scope=" + this.max_scope_depth;
        s = s + "\r\nCode:\r\n" + this.getCode().toString();
        return s;
    }

    public int removeDeadCode(AVM2ConstantPool constants, Trait trait, MethodInfo info) throws InterruptedException {
        return this.getCode().removeDeadCode(this);
    }

    public int removeTraps(ABC abc, Trait trait, int scriptIndex, int classIndex, boolean isStatic, String path) throws InterruptedException {
        return this.getCode().removeTraps(trait, this.method_info, this, abc, scriptIndex, classIndex, isStatic, path);
    }

    public void deobfuscate(DeobfuscationLevel level, Trait trait, int scriptIndex, int classIndex, boolean isStatic, String path) throws InterruptedException {
        if (level == DeobfuscationLevel.LEVEL_REMOVE_DEAD_CODE) {
            this.removeDeadCode(this.abc.constants, trait, this.abc.method_info.get(this.method_info));
        } else if (level == DeobfuscationLevel.LEVEL_REMOVE_TRAPS) {
            this.removeTraps(this.abc, trait, scriptIndex, classIndex, isStatic, path);
        }
        ((Tag)((Object)this.abc.parentTag)).setModified(true);
    }

    public void removeInstruction(int pos) {
        this.getCode().removeInstruction(pos, this);
    }

    public void replaceInstruction(int pos, AVM2Instruction instruction) {
        this.getCode().replaceInstruction(pos, instruction, this);
    }

    public void insertInstruction(int pos, AVM2Instruction instruction) {
        this.getCode().insertInstruction(pos, instruction, this);
    }

    public void insertAll(int pos, List<AVM2Instruction> list) {
        for (AVM2Instruction ins : list) {
            this.insertInstruction(pos++, ins);
        }
    }

    public void insertInstruction(int pos, AVM2Instruction instruction, boolean mapOffsetsAfterIns) {
        this.getCode().insertInstruction(pos, instruction, mapOffsetsAfterIns, this);
    }

    public int getLocalReservedCount() {
        MethodInfo methodInfo = this.abc.method_info.get(this.method_info);
        int pos = methodInfo.param_types.length + 1;
        if (methodInfo.flagNeed_arguments()) {
            ++pos;
        }
        if (methodInfo.flagNeed_rest()) {
            ++pos;
        }
        return pos;
    }

    public HashMap<Integer, String> getLocalRegNames(ABC abc) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (int i = 1; i <= abc.method_info.get((int)this.method_info).param_types.length; ++i) {
            String paramName = "param" + i;
            if (abc.method_info.get(this.method_info).flagHas_paramnames() && Configuration.paramNamesEnable.get().booleanValue()) {
                paramName = abc.constants.getString(abc.method_info.get((int)this.method_info).paramNames[i - 1]);
            }
            ret.put(i, paramName);
        }
        int pos = abc.method_info.get((int)this.method_info).param_types.length + 1;
        if (abc.method_info.get(this.method_info).flagNeed_arguments()) {
            ret.put(pos, "arguments");
            ++pos;
        }
        if (abc.method_info.get(this.method_info).flagNeed_rest()) {
            ret.put(pos, "rest");
            ++pos;
        }
        if (Configuration.getLocalNamesFromDebugInfo.get().booleanValue()) {
            Map<Integer, String> debugRegNames = this.getCode().getLocalRegNamesFromDebug(abc);
            for (int k : debugRegNames.keySet()) {
                ret.put(k, debugRegNames.get(k));
            }
        }
        return ret;
    }

    public void convert(final List<MethodBody> callStack, final AbcIndexing abcIndex, final ConvertData convertData, final String path, ScriptExportMode exportMode, final boolean isStatic, final int methodIndex, final int scriptIndex, final int classIndex, final ABC abc, final Trait trait, final ScopeStack scopeStack, final int initializerType, final NulWriter writer, final List<DottedChain> fullyQualifiedNames, final List<Traits> initTraits, boolean firstLevel, final Set<Integer> seenMethods) throws InterruptedException {
        seenMethods.add(this.method_info);
        if (this.debugMode) {
            System.err.println("Decompiling " + path);
        }
        if (exportMode != ScriptExportMode.AS) {
            this.getCode().toASMSource(abc, abc.constants, abc.method_info.get(this.method_info), this, exportMode, writer);
        } else {
            if (DEBUG_FIXED != null && !path.endsWith(DEBUG_FIXED) || !Configuration.decompile.get().booleanValue()) {
                writer.appendNoHilight(Helper.getDecompilationSkippedComment()).newLine();
                return;
            }
            int timeout = Configuration.decompilationTimeoutSingleMethod.get();
            this.convertException = null;
            try {
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() throws InterruptedException {
                        try (Statistics s1 = new Statistics("MethodBody.convert");){
                            List<GraphTargetItem> convertedItems1;
                            MethodBody converted = MethodBody.this.convertMethodBody(convertData.deobfuscationMode != 0, path, isStatic, scriptIndex, classIndex, abc, trait);
                            HashMap<Integer, String> localRegNames = MethodBody.this.getLocalRegNames(abc);
                            try (Statistics s = new Statistics("AVM2Code.toGraphTargetItems");){
                                convertedItems1 = converted.getCode().toGraphTargetItems(callStack, abcIndex, convertData.thisHasDefaultToPrimitive, convertData, path, methodIndex, isStatic, scriptIndex, classIndex, abc, converted, localRegNames, scopeStack, initializerType, fullyQualifiedNames, initTraits, 0, new HashMap<Integer, Integer>());
                            }
                            s = new Statistics("Graph.graphToString");
                            var7_8 = null;
                            try {
                                Graph.graphToString(convertedItems1, writer, LocalData.create(callStack, abcIndex, abc, localRegNames, fullyQualifiedNames, seenMethods));
                            }
                            catch (Throwable throwable) {
                                var7_8 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (s != null) {
                                    if (var7_8 != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (Throwable throwable) {
                                            var7_8.addSuppressed(throwable);
                                        }
                                    } else {
                                        s.close();
                                    }
                                }
                            }
                            MethodBody.this.convertedItems = convertedItems1;
                        }
                        return null;
                    }
                };
                if (firstLevel) {
                    CancellableWorker.call(callable, timeout, TimeUnit.SECONDS);
                } else {
                    callable.call();
                }
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (CancellationException ex) {
                throw new InterruptedException();
            }
            catch (Exception | OutOfMemoryError | StackOverflowError ex) {
                this.convertException = ex;
                Throwable cause = ex.getCause();
                if (ex instanceof ExecutionException && cause instanceof Exception) {
                    this.convertException = (Exception)cause;
                }
                if (this.convertException instanceof TimeoutException) {
                    logger.log(Level.SEVERE, "Decompilation timeout in: " + path, this.convertException);
                }
                logger.log(Level.SEVERE, "Decompilation error in: " + path, this.convertException);
            }
        }
    }

    public GraphTextWriter toString(List<MethodBody> callStack, AbcIndexing abcIndex, String path, ScriptExportMode exportMode, ABC abc, Trait trait, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, Set<Integer> seenMethods) throws InterruptedException {
        seenMethods.add(this.method_info);
        if (exportMode != ScriptExportMode.AS) {
            this.getCode().toASMSource(abc, abc.constants, abc.method_info.get(this.method_info), this, exportMode, writer);
        } else {
            if (DEBUG_FIXED != null && !path.endsWith(DEBUG_FIXED) || !Configuration.decompile.get().booleanValue()) {
                writer.appendNoHilight(Helper.getDecompilationSkippedComment()).newLine();
                return writer;
            }
            int timeout = Configuration.decompilationTimeoutSingleMethod.get();
            try (Statistics s = new Statistics("MethodBody.toString");){
                if (this.convertException == null) {
                    HashMap<Integer, String> localRegNames = this.getLocalRegNames(abc);
                    if (Configuration.showMethodBodyId.get().booleanValue()) {
                        writer.appendNoHilight("// method body index: ");
                        writer.appendNoHilight(abc.findBodyIndex(this.method_info));
                        writer.appendNoHilight(" method index: ");
                        writer.appendNoHilight(this.method_info);
                        writer.newLine();
                    }
                    Graph.graphToString(this.convertedItems, writer, LocalData.create(callStack, abcIndex, abc, localRegNames, fullyQualifiedNames, seenMethods));
                } else if (this.convertException instanceof TimeoutException) {
                    Helper.appendTimeoutCommentAs3(writer, timeout, this.getCode().code.size());
                } else {
                    Helper.appendErrorComment(writer, this.convertException);
                }
            }
        }
        return writer;
    }

    public MethodBody convertMethodBodyCanUseLast(boolean deobfuscate, String path, boolean isStatic, int scriptIndex, int classIndex, ABC abc, Trait trait) throws InterruptedException {
        if (this.lastConvertedBody != null) {
            return this.lastConvertedBody;
        }
        return this.convertMethodBody(deobfuscate, path, isStatic, scriptIndex, classIndex, abc, trait);
    }

    public void clearLastConverted() {
        this.lastConvertedBody = null;
    }

    public MethodBody convertMethodBody(boolean deobfuscate, String path, boolean isStatic, int scriptIndex, int classIndex, ABC abc, Trait trait) throws InterruptedException {
        MethodBody body = this.clone();
        AVM2Code code = body.getCode();
        code.markVirtualAddresses();
        code.fixJumps(path, body);
        if (deobfuscate) {
            try {
                code.removeTraps(trait, this.method_info, body, abc, scriptIndex, classIndex, isStatic, path);
            }
            catch (InterruptedException | ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "Deobfuscation failed in: " + path, ex);
                body = this.clone();
                code = body.getCode();
                code.fixJumps(path, body);
                return body;
            }
        }
        this.lastConvertedBody = body;
        return body;
    }

    public String toSource(List<MethodBody> callStack, AbcIndexing abcIndex, int scriptIndex, Set<Integer> seenMethods) {
        ConvertData convertData = new ConvertData();
        convertData.deobfuscationMode = 0;
        try {
            this.convert(callStack, abcIndex, convertData, "", ScriptExportMode.AS, false, this.method_info, 0, 0, this.abc, null, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true, seenMethods);
            HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
            writer.indent().indent().indent();
            this.toString(callStack, abcIndex, "", ScriptExportMode.AS, this.abc, null, writer, new ArrayList<DottedChain>(), seenMethods);
            writer.unindent().unindent().unindent();
            return writer.toString();
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public MethodBody clone() {
        return this.clone(false);
    }

    public MethodBody clone(boolean deepTraits) {
        try {
            MethodBody ret = (MethodBody)super.clone();
            if (this.code != null) {
                ret.code = this.code.clone();
            }
            if (this.exceptions != null) {
                ret.exceptions = new ABCException[this.exceptions.length];
                for (int i = 0; i < this.exceptions.length; ++i) {
                    ret.exceptions[i] = this.exceptions[i].clone();
                }
            }
            if (deepTraits && this.traits != null) {
                ret.traits = this.traits.clone();
            }
            ret.convertedItems = null;
            ret.convertException = null;
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public boolean autoFillStats(ABC abc, int initScope, boolean hasThis) {
        CodeStats stats = this.getCode().getStats(abc, this, initScope, true);
        if (stats == null) {
            return false;
        }
        if (stats.has_activation) {
            ++initScope;
        }
        this.max_stack = stats.maxstack;
        this.max_scope_depth = stats.maxscope + (stats.has_activation ? 1 : 0);
        this.max_regs = stats.maxlocal;
        this.init_scope_depth = initScope;
        abc.method_info.get(this.method_info).setFlagSetsdxns(stats.has_set_dxns);
        abc.method_info.get(this.method_info).setFlagNeed_activation(stats.has_activation);
        MethodInfo mi = abc.method_info.get(this.method_info);
        int min_regs = mi.param_types.length + 1 + (mi.flagNeed_rest() ? 1 : 0);
        if (this.max_regs < min_regs) {
            this.max_regs = min_regs;
        }
        return true;
    }

    public boolean autoFillMaxRegs(ABC abc) {
        CodeStats stats = this.getCode().getMaxLocal();
        if (stats == null) {
            return false;
        }
        this.max_regs = stats.maxlocal;
        MethodInfo mi = abc.method_info.get(this.method_info);
        int min_regs = mi.param_types.length + 1 + (mi.flagNeed_rest() ? 1 : 0);
        if (this.max_regs < min_regs) {
            this.max_regs = min_regs;
        }
        return true;
    }
}

