/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.util.List;

public class InstanceInfo {
    public int name_index;
    public int super_index;
    public int flags;
    public int protectedNS;
    public int[] interfaces;
    public int iinit_index;
    public Traits instance_traits;
    public static final int CLASS_SEALED = 1;
    public static final int CLASS_FINAL = 2;
    public static final int CLASS_INTERFACE = 4;
    public static final int CLASS_PROTECTEDNS = 8;
    public static final int CLASS_NON_NULLABLE = 16;
    @Internal
    public boolean deleted;

    public InstanceInfo() {
        this.instance_traits = new Traits();
    }

    public InstanceInfo(Traits traits) {
        this.instance_traits = traits;
    }

    public String toString() {
        return "name_index=" + this.name_index + " super_index=" + this.super_index + " flags=" + this.flags + " protectedNS=" + this.protectedNS + " interfaces=" + Helper.intArrToString(this.interfaces) + " method_index=" + this.iinit_index + "\r\n" + this.instance_traits.toString();
    }

    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        String supIndexStr = "[nothing]";
        if (this.super_index > 0) {
            supIndexStr = abc.constants.getMultiname(this.super_index).toString(abc.constants, fullyQualifiedNames);
        }
        return "name_index=" + abc.constants.getMultiname(this.name_index).toString(abc.constants, fullyQualifiedNames) + " super_index=" + supIndexStr + " flags=" + this.flags + " protectedNS=" + this.protectedNS + " interfaces=" + Helper.intArrToString(this.interfaces) + " method_index=" + this.iinit_index + "\r\n" + this.instance_traits.toString(abc, fullyQualifiedNames);
    }

    public GraphTextWriter getClassHeaderStr(GraphTextWriter writer, ABC abc, List<DottedChain> fullyQualifiedNames, boolean allowPrivate) {
        Namespace ns = abc.constants.getMultiname(this.name_index).getNamespace(abc.constants);
        String modifiers = ns.getPrefix(abc);
        if (!allowPrivate && modifiers.equals("private")) {
            modifiers = "";
        }
        if (!modifiers.isEmpty()) {
            modifiers = modifiers + " ";
        }
        if (this.isFinal()) {
            modifiers = modifiers + "final ";
        }
        if (!this.isInterface() && this.isDynamic()) {
            modifiers = modifiers + "dynamic ";
        }
        String objType = "class ";
        if (this.isInterface()) {
            objType = "interface ";
        }
        writer.appendNoHilight(modifiers + objType);
        String classTypeName = abc.constants.getMultiname(this.name_index).getNameWithNamespace(abc.constants, true).toRawString();
        writer.hilightSpecial(abc.constants.getMultiname(this.name_index).getName(abc.constants, null, false, true), HighlightSpecialType.CLASS_NAME, classTypeName);
        if (this.super_index > 0) {
            String typeName = abc.constants.getMultiname(this.super_index).getNameWithNamespace(abc.constants, true).toRawString();
            String parentName = abc.constants.getMultiname(this.super_index).getName(abc.constants, fullyQualifiedNames, false, true);
            if (!parentName.equals("Object")) {
                writer.appendNoHilight(" extends ");
                writer.hilightSpecial(parentName, HighlightSpecialType.TYPE_NAME, typeName);
            }
        }
        if (this.interfaces.length > 0) {
            if (this.isInterface()) {
                writer.appendNoHilight(" extends ");
            } else {
                writer.appendNoHilight(" implements ");
            }
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                String typeName = abc.constants.getMultiname(this.interfaces[i]).getNameWithNamespace(abc.constants, true).toRawString();
                writer.hilightSpecial(abc.constants.getMultiname(this.interfaces[i]).getName(abc.constants, fullyQualifiedNames, false, true), HighlightSpecialType.TYPE_NAME, typeName);
            }
        }
        return writer;
    }

    public Multiname getName(AVM2ConstantPool constants) {
        return constants.getMultiname(this.name_index);
    }

    public boolean isInterface() {
        return (this.flags & 4) == 4;
    }

    public boolean isDynamic() {
        return (this.flags & 1) == 0;
    }

    public boolean isFinal() {
        return (this.flags & 2) == 2;
    }

    public boolean isNullable() {
        return (this.flags & 0x10) != 16;
    }
}

