/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.BooleanAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NanAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.UndefinedAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AssignableAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.NamespaceItem;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.UnresolvedAVM2Item;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class NameAVM2Item
extends AssignableAVM2Item {
    private boolean attribute;
    private String variableName;
    private boolean definition;
    private int nsKind = -1;
    public List<NamespaceItem> openedNamespaces;
    public int line;
    public GraphTargetItem type;
    private GraphTargetItem ns = null;
    private int regNumber = -1;
    public boolean unresolved = false;
    private int slotNumber = -1;
    private int slotScope = 0;
    public GraphTargetItem redirect;
    private AbcIndexing abcIndex;
    private String namespaceSuffix;

    @Override
    public AssignableAVM2Item copy() {
        NameAVM2Item c = new NameAVM2Item(this.type, this.line, this.attribute, this.variableName, this.namespaceSuffix, this.assignedValue, this.definition, this.openedNamespaces, this.abcIndex);
        c.setNs(this.ns);
        c.regNumber = this.regNumber;
        c.unresolved = this.unresolved;
        c.nsKind = this.nsKind;
        return c;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public void setSlotScope(int slotScope) {
        this.slotScope = slotScope;
    }

    public int getSlotScope() {
        return this.slotScope;
    }

    public void setNs(GraphTargetItem ns) {
        this.ns = ns;
    }

    public void setRegNumber(int regNumber) {
        this.regNumber = regNumber;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public int getRegNumber() {
        return this.regNumber;
    }

    public GraphTargetItem getNs() {
        return this.ns;
    }

    public void appendName(String name) {
        this.variableName = this.variableName + "." + name;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public void setNsKind(int nsKind) {
        this.nsKind = nsKind;
    }

    public int getNsKind() {
        return this.nsKind;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getNamespaceSuffix() {
        return this.namespaceSuffix;
    }

    public NameAVM2Item(GraphTargetItem type, int line, boolean attribute, String variableName, String namespaceSuffix, GraphTargetItem storeValue, boolean definition, List<NamespaceItem> openedNamespaces, AbcIndexing abcIndex) {
        super(storeValue);
        this.attribute = attribute;
        this.variableName = variableName;
        this.namespaceSuffix = namespaceSuffix;
        this.assignedValue = storeValue;
        this.definition = definition;
        this.line = line;
        this.type = type;
        this.openedNamespaces = openedNamespaces;
        this.abcIndex = abcIndex;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public GraphTargetItem getStoreValue() {
        return this.assignedValue;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return writer;
    }

    public static GraphTargetItem getDefaultValue(String type) {
        switch (type) {
            case "*": {
                return new UndefinedAVM2Item(null, null);
            }
            case "int": {
                return new IntegerValueAVM2Item(null, null, (Integer)0);
            }
            case "Boolean": {
                return new BooleanAVM2Item(null, null, Boolean.FALSE);
            }
            case "Number": {
                return new NanAVM2Item(null, null);
            }
        }
        return new NullAVM2Item(null, null);
    }

    public static AVM2Instruction generateCoerce(SourceGeneratorLocalData localData, SourceGenerator generator, GraphTargetItem ttype) throws CompilationException {
        AVM2Instruction ins;
        if (ttype instanceof UnresolvedAVM2Item) {
            ttype = ((UnresolvedAVM2Item)ttype).resolved;
        }
        switch (ttype.toString()) {
            case "int": {
                ins = NameAVM2Item.ins(115, new Integer[0]);
                break;
            }
            case "*": {
                ins = NameAVM2Item.ins(130, new Integer[0]);
                break;
            }
            case "String": {
                ins = NameAVM2Item.ins(133, new Integer[0]);
                break;
            }
            case "Boolean": {
                ins = NameAVM2Item.ins(118, new Integer[0]);
                break;
            }
            case "uint": {
                ins = NameAVM2Item.ins(116, new Integer[0]);
                break;
            }
            case "Number": {
                ins = NameAVM2Item.ins(117, new Integer[0]);
                break;
            }
            default: {
                int type_index = AVM2SourceGenerator.resolveType(localData, ttype, ((AVM2SourceGenerator)generator).abcIndex);
                ins = NameAVM2Item.ins(128, type_index);
            }
        }
        return ins;
    }

    private List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator, boolean needsReturn) throws CompilationException {
        this.addTraitUsage(localData, localData.callStack);
        if (this.variableName != null && this.regNumber == -1 && this.slotNumber == -1 && this.ns == null) {
            throw new CompilationException("No register or slot set for " + this.variableName, this.line);
        }
        if (this.definition && this.assignedValue == null) {
            return new ArrayList<GraphSourceItem>();
        }
        String name = this.variableName;
        boolean attr = false;
        if (name != null && name.startsWith("@")) {
            attr = true;
        }
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        Reference<Integer> ns_temp = new Reference<Integer>(-1);
        Reference<Integer> index_temp = new Reference<Integer>(-1);
        Reference<Integer> ret_temp = new Reference<Integer>(-1);
        if (this.assignedValue != null) {
            List<String> basicTypes = Arrays.asList("int", "Number");
            if (this.slotNumber > -1) {
                return NameAVM2Item.toSourceMerge(localData, generator, NameAVM2Item.ins(101, this.slotScope), this.assignedValue, !("" + this.assignedValue.returnType()).equals("" + this.type) || !basicTypes.contains("" + this.type) ? NameAVM2Item.generateCoerce(localData, generator, this.type) : null, needsReturn ? NameAVM2Item.dupSetTemp(localData, generator, ret_temp) : null, NameAVM2Item.generateSetLoc(this.regNumber), this.slotNumber > -1 ? NameAVM2Item.ins(109, this.slotNumber) : null, needsReturn ? NameAVM2Item.getTemp(localData, generator, ret_temp) : null, NameAVM2Item.killTemp(localData, generator, Arrays.asList(ret_temp)));
            }
            return NameAVM2Item.toSourceMerge(localData, generator, this.assignedValue, NameAVM2Item.generateCoerce(localData, generator, this.type), needsReturn ? NameAVM2Item.ins(42, new Integer[0]) : null, NameAVM2Item.generateSetLoc(this.regNumber));
        }
        return NameAVM2Item.toSourceMerge(localData, generator, NameAVM2Item.generateGetLoc(this.regNumber), NameAVM2Item.generateGetSlot(this.slotScope, this.slotNumber), needsReturn ? null : NameAVM2Item.ins(41, new Integer[0]));
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        this.addTraitUsage(localData, localData.callStack);
        if (this.redirect != null) {
            return this.redirect.toSource(localData, generator);
        }
        return this.toSource(localData, generator, true);
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (this.redirect != null) {
            return this.redirect.toSourceIgnoreReturnValue(localData, generator);
        }
        return this.toSource(localData, generator, false);
    }

    @Override
    public boolean hasReturnValue() {
        return !this.definition;
    }

    @Override
    public boolean needsSemicolon() {
        return this.definition;
    }

    @Override
    public String toString() {
        return this.variableName;
    }

    @Override
    public GraphTargetItem returnType() {
        if (this.type == null) {
            return TypeItem.UNBOUNDED;
        }
        return this.type;
    }

    private void addTraitUsage(SourceGeneratorLocalData localData, List<MethodBody> callStack) {
        ABC abcV = this.abcIndex.getSelectedAbc();
        AVM2ConstantPool constants = abcV.constants;
        for (MethodBody b : callStack) {
            for (int i = 0; i < b.traits.traits.size(); ++i) {
                Trait t = b.traits.traits.get(i);
                if (!t.getName(abcV).getName(constants, null, true, true).equals(this.variableName) || !(t instanceof TraitSlotConst)) continue;
                if (!localData.traitUsages.containsKey(b)) {
                    localData.traitUsages.put(b, new ArrayList());
                }
                localData.traitUsages.get(b).add(i);
            }
        }
    }

    @Override
    public List<GraphSourceItem> toSourceChange(SourceGeneratorLocalData localData, SourceGenerator generator, boolean post, boolean decrement, boolean needsReturn) throws CompilationException {
        this.addTraitUsage(localData, localData.callStack);
        if (this.redirect != null) {
            return ((AssignableAVM2Item)this.redirect).toSourceChange(localData, generator, post, decrement, needsReturn);
        }
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        Reference<Integer> ns_temp = new Reference<Integer>(-1);
        Reference<Integer> name_temp = new Reference<Integer>(-1);
        Reference<Integer> index_temp = new Reference<Integer>(-1);
        Reference<Integer> ret_temp = new Reference<Integer>(-1);
        boolean isInteger = this.returnType().toString().equals("int");
        if (!needsReturn) {
            if (this.slotNumber > -1) {
                return NameAVM2Item.toSourceMerge(localData, generator, NameAVM2Item.ins(101, this.slotScope), NameAVM2Item.generateGetSlot(this.slotScope, this.slotNumber), decrement ? NameAVM2Item.ins(isInteger ? 193 : 147, new Integer[0]) : NameAVM2Item.ins(isInteger ? 192 : 145, new Integer[0]), NameAVM2Item.ins(109, this.slotNumber));
            }
            return NameAVM2Item.toSourceMerge(localData, generator, decrement ? NameAVM2Item.ins(isInteger ? 195 : 148, this.regNumber) : NameAVM2Item.ins(isInteger ? 194 : 146, this.regNumber));
        }
        Object[] objectArray = new Object[8];
        objectArray[0] = NameAVM2Item.generateGetLoc(this.regNumber);
        objectArray[1] = NameAVM2Item.generateGetSlot(this.slotScope, this.slotNumber);
        objectArray[2] = !post ? (decrement ? NameAVM2Item.ins(isInteger ? 193 : 147, new Integer[0]) : NameAVM2Item.ins(isInteger ? 192 : 145, new Integer[0])) : null;
        Object object = objectArray[3] = needsReturn ? NameAVM2Item.ins(42, new Integer[0]) : null;
        objectArray[4] = post ? (decrement ? NameAVM2Item.ins(isInteger ? 193 : 147, new Integer[0]) : NameAVM2Item.ins(isInteger ? 192 : 145, new Integer[0])) : null;
        objectArray[5] = NameAVM2Item.generateCoerce(localData, generator, this.returnType());
        objectArray[6] = NameAVM2Item.generateSetLoc(this.regNumber);
        objectArray[7] = this.slotNumber > -1 ? Arrays.asList(NameAVM2Item.ins(101, this.slotScope), NameAVM2Item.ins(43, new Integer[0]), NameAVM2Item.ins(109, this.slotNumber)) : null;
        return NameAVM2Item.toSourceMerge(localData, generator, objectArray);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.attribute ? 1 : 0);
        hash = 29 * hash + Objects.hashCode(this.variableName);
        hash = 29 * hash + (this.definition ? 1 : 0);
        hash = 29 * hash + this.regNumber;
        hash = 29 * hash + this.slotNumber;
        hash = 29 * hash + this.slotScope;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameAVM2Item other = (NameAVM2Item)obj;
        if (this.attribute != other.attribute) {
            return false;
        }
        if (this.definition != other.definition) {
            return false;
        }
        if (this.regNumber != other.regNumber) {
            return false;
        }
        if (this.slotNumber != other.slotNumber) {
            return false;
        }
        if (this.slotScope != other.slotScope) {
            return false;
        }
        return Objects.equals(this.variableName, other.variableName);
    }
}

