/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AbcIndexing {
    private AbcIndexing parent = null;
    private final List<ABC> abcs = new ArrayList<ABC>();
    private ABC selectedAbc = null;
    private Map<DottedChain, Set<String>> pkgToObjectsName = new LinkedHashMap<DottedChain, Set<String>>();
    private final Map<ClassDef, ClassIndex> classes = new HashMap<ClassDef, ClassIndex>();
    private final Map<PropertyDef, TraitIndex> instanceProperties = new HashMap<PropertyDef, TraitIndex>();
    private final Map<PropertyDef, TraitIndex> classProperties = new HashMap<PropertyDef, TraitIndex>();
    private final Map<PropertyNsDef, TraitIndex> instanceNsProperties = new HashMap<PropertyNsDef, TraitIndex>();
    private final Map<PropertyNsDef, TraitIndex> classNsProperties = new HashMap<PropertyNsDef, TraitIndex>();
    private final Map<PropertyNsDef, TraitIndex> scriptProperties = new HashMap<PropertyNsDef, TraitIndex>();

    public AbcIndexing(AbcIndexing parent) {
        this(null, parent);
    }

    public AbcIndexing(SWF swf, AbcIndexing parent) {
        this.parent = parent;
        if (swf != null) {
            for (ABCContainerTag at : swf.getAbcList()) {
                this.addAbc(at.getABC());
            }
            this.rebuildPkgToObjectsNameMap();
        }
    }

    public AbcIndexing(SWF swf) {
        this(swf, null);
    }

    public AbcIndexing() {
        this(null, null);
    }

    public void rebuildPkgToObjectsNameMap() {
        this.pkgToObjectsName.clear();
        for (ClassDef cd : this.classes.keySet()) {
            if (!(cd.type instanceof TypeItem)) continue;
            if (!this.pkgToObjectsName.containsKey(cd.pkg)) {
                this.pkgToObjectsName.put(cd.pkg, new LinkedHashSet());
            }
            this.pkgToObjectsName.get(cd.pkg).add(((TypeItem)cd.type).fullTypeName.getLast());
        }
        for (PropertyNsDef nsdef : this.scriptProperties.keySet()) {
            if (!this.pkgToObjectsName.containsKey(nsdef.ns)) {
                this.pkgToObjectsName.put(nsdef.ns, new LinkedHashSet());
            }
            this.pkgToObjectsName.get(nsdef.ns).add(nsdef.propName);
        }
    }

    public Set<String> getPackageObjects(DottedChain pkg) {
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        if (this.pkgToObjectsName.containsKey(pkg)) {
            classNames.addAll((Collection<String>)this.pkgToObjectsName.get(pkg));
        }
        if (this.parent != null) {
            classNames.addAll(this.parent.getPackageObjects(pkg));
        }
        return classNames;
    }

    public ClassIndex findClass(GraphTargetItem cls, ABC abc, Integer scriptIndex) {
        ClassDef keyWithScriptIndex = new ClassDef(cls, abc, scriptIndex);
        if (this.classes.containsKey(keyWithScriptIndex)) {
            return this.classes.get(keyWithScriptIndex);
        }
        ClassDef keyWithNoScriptIndex = new ClassDef(cls, abc, null);
        if (this.classes.containsKey(keyWithNoScriptIndex)) {
            return this.classes.get(keyWithNoScriptIndex);
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.findClass(cls, abc, scriptIndex);
    }

    public void findPropertyTypeOrCallType(ABC abc, GraphTargetItem cls, String propName, int ns, boolean findStatic, boolean findInstance, boolean findProtected, Reference<GraphTargetItem> type, Reference<GraphTargetItem> callType) {
        TraitIndex traitIndex = this.findProperty(new PropertyDef(propName, cls, abc, ns), findStatic, findInstance, findProtected);
        if (traitIndex == null) {
            type.setVal(TypeItem.UNKNOWN);
            callType.setVal(TypeItem.UNKNOWN);
        } else {
            type.setVal(traitIndex.returnType);
            callType.setVal(traitIndex.callReturnType);
        }
    }

    public GraphTargetItem findPropertyType(ABC abc, GraphTargetItem cls, String propName, int ns, boolean findStatic, boolean findInstance, boolean findProtected) {
        TraitIndex traitIndex = this.findProperty(new PropertyDef(propName, cls, abc, ns), findStatic, findInstance, findProtected);
        if (traitIndex == null) {
            return TypeItem.UNBOUNDED;
        }
        return traitIndex.returnType;
    }

    public GraphTargetItem findPropertyCallType(ABC abc, GraphTargetItem cls, String propName, int ns, boolean findStatic, boolean findInstance, boolean findProtected) {
        TraitIndex traitIndex = this.findProperty(new PropertyDef(propName, cls, abc, ns), findStatic, findInstance, findProtected);
        if (traitIndex == null) {
            return TypeItem.UNBOUNDED;
        }
        return traitIndex.callReturnType;
    }

    public TraitIndex findScriptProperty(DottedChain ns) {
        return this.findScriptProperty(ns.getLast(), ns.getWithoutLast());
    }

    public TraitIndex findScriptProperty(String propName, DottedChain ns) {
        PropertyNsDef nsd = new PropertyNsDef(propName, ns, null, 0);
        if (!this.scriptProperties.containsKey(nsd)) {
            if (this.parent != null) {
                return this.parent.findScriptProperty(propName, ns);
            }
            return null;
        }
        return this.scriptProperties.get(nsd);
    }

    public TraitIndex findNsProperty(PropertyNsDef prop, boolean findStatic, boolean findInstance) {
        TraitIndex ret;
        if (findStatic && this.classNsProperties.containsKey(prop)) {
            if (!this.classNsProperties.containsKey(prop)) {
                if (this.parent != null && (ret = this.parent.findNsProperty(prop, findStatic, findInstance)) != null) {
                    return ret;
                }
            } else {
                return this.classNsProperties.get(prop);
            }
        }
        if (findInstance && this.instanceNsProperties.containsKey(prop)) {
            if (!this.instanceNsProperties.containsKey(prop)) {
                if (this.parent != null && (ret = this.parent.findNsProperty(prop, findStatic, findInstance)) != null) {
                    return ret;
                }
            } else {
                return this.instanceNsProperties.get(prop);
            }
        }
        return null;
    }

    public TraitIndex findProperty(PropertyDef prop, boolean findStatic, boolean findInstance, boolean findProtected) {
        TraitIndex pti;
        TraitIndex pti2;
        ClassIndex ci;
        TraitIndex ret;
        TraitIndex ti;
        if (findStatic && this.classProperties.containsKey(prop)) {
            ti = this.classProperties.get(prop);
            if (ti != null) {
                return ti;
            }
            if (this.parent != null && (ret = this.parent.findProperty(prop, findStatic, findInstance, findProtected)) != null) {
                return ret;
            }
        }
        if (findInstance && this.instanceProperties.containsKey(prop)) {
            ti = this.instanceProperties.get(prop);
            if (ti != null) {
                return ti;
            }
            if (this.parent != null && (ret = this.parent.findProperty(prop, findStatic, findInstance, findProtected)) != null) {
                return ret;
            }
        }
        if ((ci = this.findClass(prop.parent, prop.abc, null)) != null && ci.parent != null && (prop.abc == null || prop.propNsIndex == 0)) {
            ClassIndex ciParent = ci.parent;
            DottedChain parentClass = ciParent.abc.instance_info.get(ciParent.index).getName(ciParent.abc.constants).getNameWithNamespace(ciParent.abc.constants, true);
            pti2 = this.findProperty(new PropertyDef(prop.propName, new TypeItem(parentClass), prop.getPropNsString()), findStatic, findInstance, findProtected);
            if (pti2 != null) {
                return pti2;
            }
        }
        if (findProtected && prop.propNsIndex == 0 && ci != null) {
            int protNs = ci.abc.instance_info.get((int)ci.index).protectedNS;
            PropertyDef prop2 = new PropertyDef(prop.propName, prop.parent, ci.abc, protNs);
            pti2 = this.findProperty(prop2, findStatic, findInstance, false);
            if (pti2 != null) {
                return pti2;
            }
        }
        if (this.parent != null && (pti = this.parent.findProperty(prop, findStatic, findInstance, findProtected)) != null) {
            return pti;
        }
        return null;
    }

    private static GraphTargetItem multinameToType(Set<Integer> visited, int m_index, AVM2ConstantPool constants) {
        if (visited.contains(m_index)) {
            Logger.getLogger(AbcIndexing.class.getName()).log(Level.WARNING, "Recursive typename detected");
            return null;
        }
        if (m_index == 0) {
            return TypeItem.UNBOUNDED;
        }
        Multiname m = constants.getMultiname(m_index);
        if (m.kind == 29) {
            visited.add(m_index);
            GraphTargetItem obj = AbcIndexing.multinameToType(visited, m.qname_index, constants);
            if (obj == null) {
                return null;
            }
            ArrayList<GraphTargetItem> params = new ArrayList<GraphTargetItem>();
            for (int pm : m.params) {
                GraphTargetItem r = AbcIndexing.multinameToType(visited, pm, constants);
                if (r == null) {
                    return null;
                }
                if (pm == 0) {
                    r = new NullAVM2Item(null, null);
                }
                params.add(r);
            }
            return new ApplyTypeAVM2Item(null, null, obj, params);
        }
        if (m.namespace_index != 0 && m.getNamespace((AVM2ConstantPool)constants).kind == 5) {
            return new TypeItem(m.getName(constants, new ArrayList<DottedChain>(), true, true), "ns:" + m.namespace_index);
        }
        return new TypeItem(m.getNameWithNamespace(constants, true));
    }

    public static GraphTargetItem multinameToType(int m_index, AVM2ConstantPool constants) {
        return AbcIndexing.multinameToType(new HashSet<Integer>(), m_index, constants);
    }

    private static GraphTargetItem getTraitCallReturnType(ABC abc, Trait t) {
        if (t instanceof TraitSlotConst) {
            return TypeItem.UNBOUNDED;
        }
        if (t instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
            if (tmgs.kindType == 2) {
                return TypeItem.UNBOUNDED;
            }
            if (tmgs.kindType == 3) {
                return TypeItem.UNBOUNDED;
            }
            return AbcIndexing.multinameToType(abc.method_info.get((int)tmgs.method_info).ret_type, abc.constants);
        }
        if (t instanceof TraitFunction) {
            TraitFunction tf = (TraitFunction)t;
            return AbcIndexing.multinameToType(abc.method_info.get((int)tf.method_info).ret_type, abc.constants);
        }
        return TypeItem.UNBOUNDED;
    }

    private static GraphTargetItem getTraitReturnType(ABC abc, Trait t) {
        if (t instanceof TraitSlotConst) {
            TraitSlotConst tsc = (TraitSlotConst)t;
            if (tsc.type_index == 0) {
                return TypeItem.UNBOUNDED;
            }
            return AbcIndexing.multinameToType(tsc.type_index, abc.constants);
        }
        if (t instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
            if (tmgs.kindType == 2) {
                return AbcIndexing.multinameToType(abc.method_info.get((int)tmgs.method_info).ret_type, abc.constants);
            }
            if (tmgs.kindType == 3) {
                if (abc.method_info.get((int)tmgs.method_info).param_types.length > 0) {
                    return AbcIndexing.multinameToType(abc.method_info.get((int)tmgs.method_info).param_types[0], abc.constants);
                }
                return TypeItem.UNBOUNDED;
            }
            return new TypeItem(DottedChain.FUNCTION);
        }
        if (t instanceof TraitFunction) {
            return new TypeItem(DottedChain.FUNCTION);
        }
        return TypeItem.UNBOUNDED;
    }

    protected void indexTraits(ABC abc, int name_index, Traits ts, Map<PropertyDef, TraitIndex> map, Map<PropertyNsDef, TraitIndex> mapNs) {
        for (Trait t : ts.traits) {
            ValueKind propValue = null;
            if (t instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)t;
                propValue = new ValueKind(tsc.value_index, tsc.value_kind);
            }
            if (map != null) {
                PropertyDef dp = new PropertyDef(t.getName(abc).getName(abc.constants, new ArrayList<DottedChain>(), true, false), AbcIndexing.multinameToType(name_index, abc.constants), abc, abc.constants.getMultiname((int)t.name_index).namespace_index);
                map.put(dp, new TraitIndex(t, abc, AbcIndexing.getTraitReturnType(abc, t), AbcIndexing.getTraitCallReturnType(abc, t), propValue, AbcIndexing.multinameToType(name_index, abc.constants)));
            }
            if (mapNs == null) continue;
            Multiname m = abc.constants.getMultiname(t.name_index);
            PropertyNsDef ndp = new PropertyNsDef(t.getName(abc).getName(abc.constants, new ArrayList<DottedChain>(), true, true), m == null || m.namespace_index == 0 ? DottedChain.EMPTY : m.getNamespace(abc.constants).getName(abc.constants), abc, m == null ? 0 : m.namespace_index);
            TraitIndex ti = new TraitIndex(t, abc, AbcIndexing.getTraitReturnType(abc, t), AbcIndexing.getTraitCallReturnType(abc, t), propValue, AbcIndexing.multinameToType(name_index, abc.constants));
            if (mapNs.containsKey(ndp)) continue;
            mapNs.put(ndp, ti);
        }
    }

    public void refreshSelected() {
        this.refreshAbc(this.getSelectedAbc());
    }

    public void refreshAbc(ABC abc) {
        if (abc == null) {
            return;
        }
        this.removeAbc(abc);
        this.addAbc(abc);
        this.rebuildPkgToObjectsNameMap();
    }

    public void removeAbc(ABC abc) {
        this.abcs.remove(abc);
        HashSet<ClassDef> gti_keys = new HashSet<ClassDef>(this.classes.keySet());
        for (ClassDef classDef : gti_keys) {
            if (this.classes.get((Object)classDef).abc != abc) continue;
            this.classes.remove(classDef);
        }
        HashSet<PropertyDef> pd_keys = new HashSet<PropertyDef>(this.instanceProperties.keySet());
        for (PropertyDef key : pd_keys) {
            if (this.instanceProperties.get((Object)key).abc != abc) continue;
            this.instanceProperties.remove(key);
        }
        pd_keys = new HashSet<PropertyDef>(this.classProperties.keySet());
        for (PropertyDef key : pd_keys) {
            if (this.classProperties.get((Object)key).abc != abc) continue;
            this.classProperties.remove(key);
        }
        HashSet<PropertyNsDef> hashSet = new HashSet<PropertyNsDef>(this.scriptProperties.keySet());
        for (PropertyNsDef key : hashSet) {
            if (this.scriptProperties.get((Object)key).abc != abc) continue;
            this.scriptProperties.remove(key);
        }
        HashSet<PropertyNsDef> hashSet2 = new HashSet<PropertyNsDef>(this.classNsProperties.keySet());
        for (PropertyNsDef key : hashSet2) {
            if (this.classNsProperties.get((Object)key).abc != abc) continue;
            this.classNsProperties.remove(key);
        }
        HashSet<PropertyNsDef> hashSet3 = new HashSet<PropertyNsDef>(this.instanceNsProperties.keySet());
        for (PropertyNsDef key : hashSet3) {
            if (this.instanceNsProperties.get((Object)key).abc != abc) continue;
            this.instanceNsProperties.remove(key);
        }
    }

    public void addAbc(ABC abc) {
        if (abc == null) {
            return;
        }
        ArrayList<ClassIndex> addedClasses = new ArrayList<ClassIndex>();
        for (int i = 0; i < abc.script_info.size(); ++i) {
            this.indexTraits(abc, 0, abc.script_info.get((int)i).traits, null, this.scriptProperties);
            for (int t = 0; t < abc.script_info.get((int)i).traits.traits.size(); ++t) {
                Trait tr = abc.script_info.get((int)i).traits.traits.get(t);
                if (!(tr instanceof TraitClass)) continue;
                TraitClass tc = (TraitClass)tr;
                InstanceInfo ii = abc.instance_info.get(tc.class_info);
                if (ii.deleted) continue;
                ClassInfo ci = abc.class_info.get(tc.class_info);
                int nsKind = abc.constants.getMultiname((int)tc.name_index).getNamespace((AVM2ConstantPool)abc.constants).kind;
                Integer classScriptIndex = nsKind == 22 ? null : Integer.valueOf(i);
                ClassIndex cindex = new ClassIndex(tc.class_info, abc, null, classScriptIndex);
                addedClasses.add(cindex);
                GraphTargetItem cname = AbcIndexing.multinameToType(ii.name_index, abc.constants);
                this.classes.put(new ClassDef(cname, abc, classScriptIndex), cindex);
                this.indexTraits(abc, ii.name_index, ii.instance_traits, this.instanceProperties, this.instanceNsProperties);
                this.indexTraits(abc, ii.name_index, ci.static_traits, this.classProperties, this.classNsProperties);
            }
        }
        for (ClassIndex cindex : addedClasses) {
            int parentClassName = abc.instance_info.get((int)cindex.index).super_index;
            if (parentClassName <= 0) continue;
            TypeItem parentClass = new TypeItem(abc.constants.getMultiname(parentClassName).getNameWithNamespace(abc.constants, true));
            ClassIndex parentClassIndex = this.findClass(parentClass, abc, null);
            if (parentClassIndex == null) {
                // empty if block
            }
            cindex.parent = parentClassIndex;
        }
        this.abcs.add(abc);
        this.selectedAbc = abc;
    }

    public void selectAbc(ABC abc) {
        if (this.abcs.contains(abc)) {
            this.selectedAbc = abc;
        } else {
            this.addAbc(abc);
            this.rebuildPkgToObjectsNameMap();
        }
    }

    public ABC getSelectedAbc() {
        return this.selectedAbc;
    }

    public DottedChain nsValueToName(String valueStr) {
        for (ABC abc : this.abcs) {
            DottedChain ret = abc.nsValueToName(valueStr);
            if (ret.isEmpty()) continue;
            return ret;
        }
        if (this.parent != null) {
            return this.parent.nsValueToName(valueStr);
        }
        return null;
    }

    public static class ClassIndex {
        public int index;
        public ABC abc;
        public ClassIndex parent;
        public Integer scriptIndex;

        public String toString() {
            return this.abc.constants.getMultiname(this.abc.instance_info.get((int)this.index).name_index).getNameWithNamespace(this.abc.constants, true).toPrintableString(true);
        }

        public ClassIndex(int index, ABC abc, ClassIndex parent, Integer scriptIndex) {
            this.index = index;
            this.abc = abc;
            this.parent = parent;
            this.scriptIndex = scriptIndex;
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + this.index;
            hash = 37 * hash + System.identityHashCode(this.abc);
            hash = 37 * hash + Objects.hashCode(this.parent);
            hash = 37 * hash + Objects.hashCode(this.scriptIndex);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassIndex other = (ClassIndex)obj;
            if (this.index != other.index) {
                return false;
            }
            if (this.abc != other.abc) {
                return false;
            }
            if (!Objects.equals(this.parent, other.parent)) {
                return false;
            }
            return Objects.equals(this.scriptIndex, other.scriptIndex);
        }
    }

    private static class ClassDef {
        public GraphTargetItem type;
        public DottedChain pkg;

        private GraphTargetItem noNsType(GraphTargetItem type) {
            TypeItem ti = (TypeItem)type;
            ti = (TypeItem)ti.clone();
            ti.ns = null;
            return ti;
        }

        public ClassDef(GraphTargetItem type, ABC abc, Integer scriptIndex) {
            this.type = type;
            if (scriptIndex != null) {
                for (Trait t : abc.script_info.get((int)scriptIndex.intValue()).traits.traits) {
                    Namespace ns = t.getName(abc).getNamespace(abc.constants);
                    if (ns.kind != 22) continue;
                    this.pkg = ns.getName(abc.constants);
                }
            }
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + Objects.hashCode(this.noNsType(this.type));
            hash = 17 * hash + Objects.hashCode(this.pkg);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassDef other = (ClassDef)obj;
            if (!Objects.equals(this.noNsType(this.type), this.noNsType(other.type))) {
                return false;
            }
            return Objects.equals(this.pkg, other.pkg);
        }
    }

    public static class TraitIndex {
        public Trait trait;
        public ABC abc;
        public GraphTargetItem returnType;
        public GraphTargetItem callReturnType;
        public ValueKind value;
        public GraphTargetItem objType;

        public TraitIndex(Trait trait, ABC abc, GraphTargetItem type, GraphTargetItem callType, ValueKind value, GraphTargetItem objType) {
            this.trait = trait;
            this.abc = abc;
            this.returnType = type;
            this.callReturnType = callType;
            this.value = value;
            this.objType = objType;
        }
    }

    public static class PropertyNsDef {
        private final String propName;
        private final DottedChain ns;
        private int propNsIndex = 0;
        private ABC abc = null;

        private void setPrivate(ABC abc, int propNsIndex) {
            this.propNsIndex = propNsIndex;
            this.abc = abc;
        }

        public String getPropertyName() {
            return this.propName;
        }

        public String toString() {
            return this.ns.toString() + ":" + this.propName + (this.propNsIndex > 0 ? "[ns:" + this.propNsIndex + "]" : "");
        }

        public PropertyNsDef(String propName, DottedChain ns, ABC abc, int nsIndex) {
            this.propName = propName;
            this.ns = ns;
            if (abc == null || nsIndex <= 0) {
                return;
            }
            int k = abc.constants.getNamespace((int)nsIndex).kind;
            if (k != 22) {
                this.setPrivate(abc, nsIndex);
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Objects.hashCode(this.propName);
            hash = 19 * hash + Objects.hashCode(this.ns);
            hash = 19 * hash + this.propNsIndex;
            hash = 19 * hash + System.identityHashCode(this.abc);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyNsDef other = (PropertyNsDef)obj;
            if (!Objects.equals(this.propName, other.propName)) {
                return false;
            }
            if (!Objects.equals(this.ns, other.ns)) {
                return false;
            }
            if (this.propNsIndex != other.propNsIndex) {
                return false;
            }
            return this.abc == other.abc;
        }
    }

    public static class PropertyDef {
        private static final String BUILT_IN_NS = "http://adobe.com/AS3/2006/builtin";
        private static Map<ABC, Integer> builtInNsPerAbc = new WeakHashMap<ABC, Integer>();
        private final String propName;
        private String propNsString = null;
        private final GraphTargetItem parent;
        private int propNsIndex = 0;
        private ABC abc = null;

        public String toString() {
            return this.parent.toString() + ":" + this.propName + (this.propNsIndex > 0 ? "[ns:" + this.propNsIndex + "]" : "") + (this.propNsString != null ? "[ns: " + this.propNsString + "]" : "");
        }

        private void setPrivate(ABC abc, int propNsIndex) {
            this.propNsIndex = propNsIndex;
            this.abc = abc;
        }

        private void setProtected(ABC abc, int propNsIndex) {
            this.abc = null;
            this.propNsString = abc.constants.getNamespace(propNsIndex).getRawName(abc.constants);
        }

        public String getPropertyName() {
            return this.propName;
        }

        public String getPropNsString() {
            return this.propNsString;
        }

        public PropertyDef(String propName, GraphTargetItem parent, ABC abc, int propNsIndex) {
            int builtInIndex = -1;
            if (abc != null) {
                if (!builtInNsPerAbc.containsKey(abc)) {
                    int index = abc.constants.getNamespaceId(8, BUILT_IN_NS, 0, true);
                    builtInNsPerAbc.put(abc, index);
                }
                builtInIndex = builtInNsPerAbc.get(abc);
            }
            this.propName = propName;
            this.parent = parent;
            if (abc == null || propNsIndex <= 0) {
                return;
            }
            int k = abc.constants.getNamespace((int)propNsIndex).kind;
            if (k != 22 && propNsIndex != builtInIndex) {
                if (k == 24 || k == 26) {
                    this.setProtected(abc, propNsIndex);
                } else {
                    this.setPrivate(abc, propNsIndex);
                }
            }
        }

        public PropertyDef(String propName, GraphTargetItem parent, String propNsString) {
            this.propName = propName;
            this.parent = parent;
            this.abc = null;
            this.propNsString = propNsString;
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.propName);
            hash = 37 * hash + Objects.hashCode(this.propNsString);
            hash = 37 * hash + Objects.hashCode(this.parent);
            hash = 37 * hash + this.propNsIndex;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyDef other = (PropertyDef)obj;
            if (this.propNsIndex != other.propNsIndex) {
                return false;
            }
            if (!Objects.equals(this.propName, other.propName)) {
                return false;
            }
            if (!Objects.equals(this.propNsString, other.propNsString)) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }
    }
}

