/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.UnaryOpItem;
import java.util.List;
import java.util.Set;

public class TypeOfAVM2Item
extends UnaryOpItem {
    public TypeOfAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value) {
        super(instruction, lineStartIns, 2, value, "typeof ", "");
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isCompileTime(dependencies);
    }

    @Override
    public Object getResult() {
        Object res = this.value.getResult();
        EcmaType type = EcmaScript.type(res);
        switch (type) {
            case UNDEFINED: {
                return "undefined";
            }
            case NULL: {
                return "object";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case NUMBER: {
                return "number";
            }
            case STRING: {
                return "string";
            }
            case OBJECT: {
                return "object";
            }
        }
        return "object";
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return TypeOfAVM2Item.toSourceMerge(localData, generator, this.value, new AVM2Instruction(0L, 149, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.STRING;
    }
}

