/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.IfCondition;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.StrictEqAVM2Item;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.LogicalOpItem;
import java.util.ArrayList;
import java.util.List;

public class StrictNeqAVM2Item
extends BinaryOpItem
implements LogicalOpItem,
IfCondition {
    public StrictNeqAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 7, leftSide, rightSide, "!==", "", "");
    }

    @Override
    public int getIfDefinition() {
        return 26;
    }

    @Override
    public int getIfNotDefinition() {
        return 25;
    }

    @Override
    public GraphTargetItem invert(GraphSourceItem neqSrc) {
        return new StrictEqAVM2Item(this.getSrc(), this.getLineStartItem(), this.leftSide, this.rightSide);
    }

    @Override
    public Object getResult() {
        Object x = this.leftSide.getResult();
        Object y = this.rightSide.getResult();
        return EcmaScript.type(x) != EcmaScript.type(y) || !EcmaScript.equals(x, y);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return StrictNeqAVM2Item.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new AVM2Instruction(0L, 172, null), new AVM2Instruction(0L, 150, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.BOOLEAN;
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new AVM2Instruction(0L, 172, null));
        ret.add(new AVM2Instruction(0L, 150, null));
        return ret;
    }
}

