/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.IndexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.NamespacedAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.PropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.UnresolvedAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DeletePropertyAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public GraphTargetItem propertyName;
    private int line;
    public boolean isStatic;

    public DeletePropertyAVM2Item(GraphTargetItem property, int line) {
        this(null, null, property, null, false);
        this.line = line;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.propertyName);
    }

    public DeletePropertyAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, GraphTargetItem propertyName, boolean isStatic) {
        super(instruction, lineStartIns, 2);
        this.object = object;
        this.propertyName = propertyName;
        this.isStatic = isStatic;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("delete ");
        this.formatProperty(writer, this.object, this.propertyName, localData, this.isStatic);
        return writer;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        GraphTargetItem p = this.object;
        if (p instanceof UnresolvedAVM2Item) {
            p = ((UnresolvedAVM2Item)p).resolved;
        }
        if (p instanceof PropertyAVM2Item) {
            PropertyAVM2Item prop = (PropertyAVM2Item)p;
            return DeletePropertyAVM2Item.toSourceMerge(localData, generator, prop.resolveObject(localData, generator, true), DeletePropertyAVM2Item.ins(106, prop.resolveProperty(localData)));
        }
        if (p instanceof IndexAVM2Item) {
            IndexAVM2Item ind = (IndexAVM2Item)p;
            return ind.toSource(localData, generator, true, false, new ArrayList<GraphTargetItem>(), true, false);
        }
        if (p instanceof NamespacedAVM2Item) {
            NamespacedAVM2Item n = (NamespacedAVM2Item)p;
            return n.toSource(localData, generator, true, false, new ArrayList<GraphTargetItem>(), true, false);
        }
        throw new CompilationException("Not a property", this.line);
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.BOOLEAN);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.object);
        hash = 53 * hash + Objects.hashCode(this.propertyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeletePropertyAVM2Item other = (DeletePropertyAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Objects.equals(this.propertyName, other.propertyName);
    }
}

