/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AssignableAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.NameAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class TryAVM2Item
extends AVM2Item
implements Block {
    public List<GraphTargetItem> tryCommands;
    public List<ABCException> catchExceptions;
    public List<NameAVM2Item> catchExceptions2;
    public List<List<GraphTargetItem>> catchCommands;
    public List<GraphTargetItem> finallyCommands;
    public List<List<AssignableAVM2Item>> catchVariables = new ArrayList<List<AssignableAVM2Item>>();
    public String finCatchName = "";

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.tryCommands != null) {
            ret.add(this.tryCommands);
        }
        ret.addAll(this.catchCommands);
        if (this.finallyCommands != null) {
            ret.add(this.finallyCommands);
        }
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        if (this.tryCommands != null) {
            visitor.visitAll(this.tryCommands);
        }
        for (List<AssignableAVM2Item> list : this.catchVariables) {
            for (AssignableAVM2Item assignableAVM2Item : list) {
                visitor.visit(assignableAVM2Item);
            }
        }
        for (List<GraphTargetItem> list : this.catchCommands) {
            visitor.visitAll(list);
        }
        if (this.finallyCommands != null) {
            visitor.visitAll(this.finallyCommands);
        }
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
    }

    public TryAVM2Item(List<GraphTargetItem> tryCommands, List<ABCException> catchExceptions, List<List<GraphTargetItem>> catchCommands, List<GraphTargetItem> finallyCommands, String finCatchName) {
        super(null, null, 16);
        this.tryCommands = tryCommands;
        this.catchExceptions = catchExceptions;
        this.catchCommands = catchCommands;
        this.finallyCommands = finallyCommands;
        this.finCatchName = finCatchName;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("try");
        this.appendBlock(null, writer, localData, this.tryCommands);
        for (int e = 0; e < this.catchExceptions.size(); ++e) {
            writer.newLine();
            writer.append("catch(");
            String localName = this.catchExceptions.get(e).getVarName(localData.constantsAvm2, localData.fullyQualifiedNames);
            if (localName.isEmpty()) {
                localName = this.finCatchName;
            }
            HighlightData data = new HighlightData();
            data.localName = localName;
            data.declaration = true;
            int eti = this.catchExceptions.get((int)e).type_index;
            data.declaredType = eti <= 0 ? DottedChain.ALL : localData.constantsAvm2.getMultiname(eti).getNameWithNamespace(localData.constantsAvm2, true);
            writer.hilightSpecial(localName, HighlightSpecialType.TRY_NAME, e, data);
            writer.append(":");
            writer.hilightSpecial(this.catchExceptions.get(e).getTypeName(localData.constantsAvm2, localData.fullyQualifiedNames), HighlightSpecialType.TRY_TYPE, e);
            writer.append(")");
            List<GraphTargetItem> commands = this.catchCommands.get(e);
            this.appendBlock(null, writer, localData, commands);
        }
        if (this.catchExceptions.isEmpty() || this.finallyCommands.size() > 0) {
            writer.newLine();
            writer.append("finally");
            this.appendBlock(null, writer, localData, this.finallyCommands);
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem graphTargetItem : this.tryCommands) {
            if (graphTargetItem instanceof ContinueItem) {
                ret.add((ContinueItem)graphTargetItem);
            }
            if (!(graphTargetItem instanceof Block)) continue;
            ret.addAll(((Block)((Object)graphTargetItem)).getContinues());
        }
        if (this.finallyCommands != null) {
            for (GraphTargetItem graphTargetItem : this.finallyCommands) {
                if (graphTargetItem instanceof ContinueItem) {
                    ret.add((ContinueItem)graphTargetItem);
                }
                if (!(graphTargetItem instanceof Block)) continue;
                ret.addAll(((Block)((Object)graphTargetItem)).getContinues());
            }
        }
        for (List list : this.catchCommands) {
            for (GraphTargetItem ti : list) {
                if (ti instanceof ContinueItem) {
                    ret.add((ContinueItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return ((AVM2SourceGenerator)generator).generate(localData, this);
    }
}

