/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.EscapeXAttrAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.EscapeXElemAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class XMLAVM2Item
extends AVM2Item {
    public List<GraphTargetItem> parts;

    public XMLAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, List<GraphTargetItem> parts) {
        super(instruction, lineStartIns, 16);
        this.parts = parts;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.parts);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        for (int i = 0; i < this.parts.size(); ++i) {
            GraphTargetItem partAfter;
            GraphTargetItem part = this.parts.get(i);
            GraphTargetItem partBefore = i > 0 ? this.parts.get(i - 1) : null;
            GraphTargetItem graphTargetItem = partAfter = i < this.parts.size() - 1 ? this.parts.get(i + 1) : null;
            if (part instanceof StringAVM2Item) {
                String s = ((StringAVM2Item)part).getValue();
                if (partAfter instanceof EscapeXAttrAVM2Item && s.endsWith("\"")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (partBefore instanceof EscapeXAttrAVM2Item && s.startsWith("\"")) {
                    s = s.substring(1);
                }
                writer.append(s);
                continue;
            }
            if (part instanceof EscapeXElemAVM2Item || part instanceof EscapeXAttrAVM2Item) {
                part.toString(writer, localData);
                continue;
            }
            writer.append("{");
            part.appendTo(writer, localData);
            writer.append("}");
        }
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.XML);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.parts);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLAVM2Item other = (XMLAVM2Item)obj;
        return Objects.equals(this.parts, other.parts);
    }
}

